/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateAddressResponse extends Ec2Response implements
        ToCopyableBuilder<AllocateAddressResponse.Builder, AllocateAddressResponse> {
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressResponse::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressResponse::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("allocationId").build()).build();

    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressResponse::publicIpv4Pool))
            .setter(setter(Builder::publicIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool")
                    .unmarshallLocationName("publicIpv4Pool").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AllocateAddressResponse::domainAsString))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_IP_FIELD,
            ALLOCATION_ID_FIELD, PUBLIC_IPV4_POOL_FIELD, DOMAIN_FIELD));

    private final String publicIp;

    private final String allocationId;

    private final String publicIpv4Pool;

    private final String domain;

    private AllocateAddressResponse(BuilderImpl builder) {
        super(builder);
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in
     * a VPC.
     * </p>
     * 
     * @return [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with
     *         instances in a VPC.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID of an address pool.
     * </p>
     * 
     * @return The ID of an address pool.
     */
    public String publicIpv4Pool() {
        return publicIpv4Pool;
    }

    /**
     * <p>
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
     * instances in a VPC (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>
     *         ) or instances in a VPC (<code>vpc</code>).
     * @see DomainType
     */
    public DomainType domain() {
        return DomainType.fromValue(domain);
    }

    /**
     * <p>
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
     * instances in a VPC (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>
     *         ) or instances in a VPC (<code>vpc</code>).
     * @see DomainType
     */
    public String domainAsString() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressResponse)) {
            return false;
        }
        AllocateAddressResponse other = (AllocateAddressResponse) obj;
        return Objects.equals(publicIp(), other.publicIp()) && Objects.equals(allocationId(), other.allocationId())
                && Objects.equals(publicIpv4Pool(), other.publicIpv4Pool())
                && Objects.equals(domainAsString(), other.domainAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AllocateAddressResponse").add("PublicIp", publicIp()).add("AllocationId", allocationId())
                .add("PublicIpv4Pool", publicIpv4Pool()).add("Domain", domainAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "PublicIpv4Pool":
            return Optional.ofNullable(clazz.cast(publicIpv4Pool()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateAddressResponse, T> g) {
        return obj -> g.apply((AllocateAddressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AllocateAddressResponse> {
        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with
         * instances in a VPC.
         * </p>
         * 
         * @param allocationId
         *        [EC2-VPC] The ID that AWS assigns to represent the allocation of the Elastic IP address for use with
         *        instances in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID of an address pool.
         * </p>
         * 
         * @param publicIpv4Pool
         *        The ID of an address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pool(String publicIpv4Pool);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String publicIp;

        private String allocationId;

        private String publicIpv4Pool;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressResponse model) {
            super(model);
            publicIp(model.publicIp);
            allocationId(model.allocationId);
            publicIpv4Pool(model.publicIpv4Pool);
            domain(model.domain);
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getPublicIpv4Pool() {
            return publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        public final String getDomainAsString() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public AllocateAddressResponse build() {
            return new AllocateAddressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
