/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrafficIpAddressType {
    IPV4("ipv4"),
    IPV6("ipv6"),
    DUAL_STACK("dual-stack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrafficIpAddressType> VALUE_MAP;
    private final String value;

    private TrafficIpAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrafficIpAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrafficIpAddressType> knownValues() {
        EnumSet<TrafficIpAddressType> knownValues = EnumSet.allOf(TrafficIpAddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrafficIpAddressType.class, TrafficIpAddressType::toString);
    }
}

