/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ImageUsageResourceTypeOption;
import software.amazon.awssdk.services.ec2.model.ImageUsageResourceTypeOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageUsageResourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageUsageResourceType> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ImageUsageResourceType.getter(ImageUsageResourceType::resourceType)).setter(ImageUsageResourceType.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<List<ImageUsageResourceTypeOption>> RESOURCE_TYPE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypeOptions").getter(ImageUsageResourceType.getter(ImageUsageResourceType::resourceTypeOptions)).setter(ImageUsageResourceType.setter(Builder::resourceTypeOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeOptionSet").unmarshallLocationName("resourceTypeOptionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageUsageResourceTypeOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, RESOURCE_TYPE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageUsageResourceType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final List<ImageUsageResourceTypeOption> resourceTypeOptions;

    private ImageUsageResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceTypeOptions = builder.resourceTypeOptions;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final boolean hasResourceTypeOptions() {
        return this.resourceTypeOptions != null && !(this.resourceTypeOptions instanceof SdkAutoConstructList);
    }

    public final List<ImageUsageResourceTypeOption> resourceTypeOptions() {
        return this.resourceTypeOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeOptions() ? this.resourceTypeOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageUsageResourceType)) {
            return false;
        }
        ImageUsageResourceType other = (ImageUsageResourceType)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && this.hasResourceTypeOptions() == other.hasResourceTypeOptions() && Objects.equals(this.resourceTypeOptions(), other.resourceTypeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ImageUsageResourceType").add("ResourceType", (Object)this.resourceType()).add("ResourceTypeOptions", this.hasResourceTypeOptions() ? this.resourceTypeOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceTypeOptions": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceTypeOptionSet", RESOURCE_TYPE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageUsageResourceType, T> g) {
        return obj -> g.apply((ImageUsageResourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private List<ImageUsageResourceTypeOption> resourceTypeOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageUsageResourceType model) {
            this.resourceType(model.resourceType);
            this.resourceTypeOptions(model.resourceTypeOptions);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final List<ImageUsageResourceTypeOption.Builder> getResourceTypeOptions() {
            List<ImageUsageResourceTypeOption.Builder> result = ImageUsageResourceTypeOptionListCopier.copyToBuilder(this.resourceTypeOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypeOptions(Collection<ImageUsageResourceTypeOption.BuilderImpl> resourceTypeOptions) {
            this.resourceTypeOptions = ImageUsageResourceTypeOptionListCopier.copyFromBuilder(resourceTypeOptions);
        }

        @Override
        public final Builder resourceTypeOptions(Collection<ImageUsageResourceTypeOption> resourceTypeOptions) {
            this.resourceTypeOptions = ImageUsageResourceTypeOptionListCopier.copy(resourceTypeOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeOptions(ImageUsageResourceTypeOption ... resourceTypeOptions) {
            this.resourceTypeOptions(Arrays.asList(resourceTypeOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeOptions(Consumer<ImageUsageResourceTypeOption.Builder> ... resourceTypeOptions) {
            this.resourceTypeOptions(Stream.of(resourceTypeOptions).map(c -> (ImageUsageResourceTypeOption)((ImageUsageResourceTypeOption.Builder)ImageUsageResourceTypeOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ImageUsageResourceType build() {
            return new ImageUsageResourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageUsageResourceType> {
        public Builder resourceType(String var1);

        public Builder resourceTypeOptions(Collection<ImageUsageResourceTypeOption> var1);

        public Builder resourceTypeOptions(ImageUsageResourceTypeOption ... var1);

        public Builder resourceTypeOptions(Consumer<ImageUsageResourceTypeOption.Builder> ... var1);
    }
}

