/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportsResponse;
import software.amazon.awssdk.services.ec2.model.ImageUsageReport;

public class DescribeImageUsageReportsIterable
implements SdkIterable<DescribeImageUsageReportsResponse> {
    private final Ec2Client client;
    private final DescribeImageUsageReportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImageUsageReportsIterable(Ec2Client client, DescribeImageUsageReportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImageUsageReportsResponseFetcher();
    }

    public Iterator<DescribeImageUsageReportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageUsageReport> imageUsageReports() {
        Function<DescribeImageUsageReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageUsageReports() != null) {
                return response.imageUsageReports().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImageUsageReportsResponseFetcher
    implements SyncPageFetcher<DescribeImageUsageReportsResponse> {
        private DescribeImageUsageReportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageUsageReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImageUsageReportsResponse nextPage(DescribeImageUsageReportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageUsageReportsIterable.this.client.describeImageUsageReports(DescribeImageUsageReportsIterable.this.firstRequest);
            }
            return DescribeImageUsageReportsIterable.this.client.describeImageUsageReports((DescribeImageUsageReportsRequest)((Object)DescribeImageUsageReportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

