/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RequestHostIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHostReservationPurchasePreviewRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
    private static final SdkField<List<String>> HOST_ID_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostIdSet").getter(GetHostReservationPurchasePreviewRequest.getter(GetHostReservationPurchasePreviewRequest::hostIdSet)).setter(GetHostReservationPurchasePreviewRequest.setter(Builder::hostIdSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIdSet").unmarshallLocationName("HostIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingId").getter(GetHostReservationPurchasePreviewRequest.getter(GetHostReservationPurchasePreviewRequest::offeringId)).setter(GetHostReservationPurchasePreviewRequest.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").unmarshallLocationName("OfferingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_ID_SET_FIELD, OFFERING_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetHostReservationPurchasePreviewRequest.memberNameToFieldInitializer();
    private final List<String> hostIdSet;
    private final String offeringId;

    private GetHostReservationPurchasePreviewRequest(BuilderImpl builder) {
        super(builder);
        this.hostIdSet = builder.hostIdSet;
        this.offeringId = builder.offeringId;
    }

    public final boolean hasHostIdSet() {
        return this.hostIdSet != null && !(this.hostIdSet instanceof SdkAutoConstructList);
    }

    public final List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostIdSet() ? this.hostIdSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewRequest)) {
            return false;
        }
        GetHostReservationPurchasePreviewRequest other = (GetHostReservationPurchasePreviewRequest)((Object)obj);
        return this.hasHostIdSet() == other.hasHostIdSet() && Objects.equals(this.hostIdSet(), other.hostIdSet()) && Objects.equals(this.offeringId(), other.offeringId());
    }

    public final String toString() {
        return ToString.builder((String)"GetHostReservationPurchasePreviewRequest").add("HostIdSet", this.hasHostIdSet() ? this.hostIdSet() : null).add("OfferingId", (Object)this.offeringId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostIdSet": {
                return Optional.ofNullable(clazz.cast(this.hostIdSet()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostIdSet", HOST_ID_SET_FIELD);
        map.put("OfferingId", OFFERING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHostReservationPurchasePreviewRequest, T> g) {
        return obj -> g.apply((GetHostReservationPurchasePreviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> hostIdSet = DefaultSdkAutoConstructList.getInstance();
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewRequest model) {
            super(model);
            this.hostIdSet(model.hostIdSet);
            this.offeringId(model.offeringId);
        }

        public final Collection<String> getHostIdSet() {
            if (this.hostIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hostIdSet;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHostReservationPurchasePreviewRequest build() {
            return new GetHostReservationPurchasePreviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder offeringId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

