/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartNetworkInsightsAnalysisRequest extends Ec2Request implements
        ToCopyableBuilder<StartNetworkInsightsAnalysisRequest.Builder, StartNetworkInsightsAnalysisRequest> {
    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsPathId")
            .getter(getter(StartNetworkInsightsAnalysisRequest::networkInsightsPathId))
            .setter(setter(Builder::networkInsightsPathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId")
                    .unmarshallLocationName("NetworkInsightsPathId").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalAccounts")
            .getter(getter(StartNetworkInsightsAnalysisRequest::additionalAccounts))
            .setter(setter(Builder::additionalAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAccount")
                    .unmarshallLocationName("AdditionalAccount").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> FILTER_IN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterInArns")
            .getter(getter(StartNetworkInsightsAnalysisRequest::filterInArns))
            .setter(setter(Builder::filterInArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterInArn")
                    .unmarshallLocationName("FilterInArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> FILTER_OUT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterOutArns")
            .getter(getter(StartNetworkInsightsAnalysisRequest::filterOutArns))
            .setter(setter(Builder::filterOutArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOutArn")
                    .unmarshallLocationName("FilterOutArn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(StartNetworkInsightsAnalysisRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(StartNetworkInsightsAnalysisRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartNetworkInsightsAnalysisRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_PATH_ID_FIELD, ADDITIONAL_ACCOUNTS_FIELD, FILTER_IN_ARNS_FIELD, FILTER_OUT_ARNS_FIELD,
            DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String networkInsightsPathId;

    private final List<String> additionalAccounts;

    private final List<String> filterInArns;

    private final List<String> filterOutArns;

    private final Boolean dryRun;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private StartNetworkInsightsAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.additionalAccounts = builder.additionalAccounts;
        this.filterInArns = builder.filterInArns;
        this.filterOutArns = builder.filterOutArns;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the path.
     * </p>
     * 
     * @return The ID of the path.
     */
    public final String networkInsightsPathId() {
        return networkInsightsPathId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalAccounts() {
        return additionalAccounts != null && !(additionalAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The member accounts that contain resources that the path can traverse.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAccounts} method.
     * </p>
     * 
     * @return The member accounts that contain resources that the path can traverse.
     */
    public final List<String> additionalAccounts() {
        return additionalAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterInArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterInArns() {
        return filterInArns != null && !(filterInArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resources that the path must traverse.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterInArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resources that the path must traverse.
     */
    public final List<String> filterInArns() {
        return filterInArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterOutArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterOutArns() {
        return filterOutArns != null && !(filterOutArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the resources that the path will ignore.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterOutArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the resources that the path will ignore.
     */
    public final List<String> filterOutArns() {
        return filterOutArns;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How
     *         to ensure idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAccounts() ? additionalAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterInArns() ? filterInArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterOutArns() ? filterOutArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNetworkInsightsAnalysisRequest)) {
            return false;
        }
        StartNetworkInsightsAnalysisRequest other = (StartNetworkInsightsAnalysisRequest) obj;
        return Objects.equals(networkInsightsPathId(), other.networkInsightsPathId())
                && hasAdditionalAccounts() == other.hasAdditionalAccounts()
                && Objects.equals(additionalAccounts(), other.additionalAccounts())
                && hasFilterInArns() == other.hasFilterInArns() && Objects.equals(filterInArns(), other.filterInArns())
                && hasFilterOutArns() == other.hasFilterOutArns() && Objects.equals(filterOutArns(), other.filterOutArns())
                && Objects.equals(dryRun(), other.dryRun()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartNetworkInsightsAnalysisRequest").add("NetworkInsightsPathId", networkInsightsPathId())
                .add("AdditionalAccounts", hasAdditionalAccounts() ? additionalAccounts() : null)
                .add("FilterInArns", hasFilterInArns() ? filterInArns() : null)
                .add("FilterOutArns", hasFilterOutArns() ? filterOutArns() : null).add("DryRun", dryRun())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsPathId":
            return Optional.ofNullable(clazz.cast(networkInsightsPathId()));
        case "AdditionalAccounts":
            return Optional.ofNullable(clazz.cast(additionalAccounts()));
        case "FilterInArns":
            return Optional.ofNullable(clazz.cast(filterInArns()));
        case "FilterOutArns":
            return Optional.ofNullable(clazz.cast(filterOutArns()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetworkInsightsPathId", NETWORK_INSIGHTS_PATH_ID_FIELD);
        map.put("AdditionalAccount", ADDITIONAL_ACCOUNTS_FIELD);
        map.put("FilterInArn", FILTER_IN_ARNS_FIELD);
        map.put("FilterOutArn", FILTER_OUT_ARNS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartNetworkInsightsAnalysisRequest, T> g) {
        return obj -> g.apply((StartNetworkInsightsAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, StartNetworkInsightsAnalysisRequest> {
        /**
         * <p>
         * The ID of the path.
         * </p>
         * 
         * @param networkInsightsPathId
         *        The ID of the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsPathId(String networkInsightsPathId);

        /**
         * <p>
         * The member accounts that contain resources that the path can traverse.
         * </p>
         * 
         * @param additionalAccounts
         *        The member accounts that contain resources that the path can traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAccounts(Collection<String> additionalAccounts);

        /**
         * <p>
         * The member accounts that contain resources that the path can traverse.
         * </p>
         * 
         * @param additionalAccounts
         *        The member accounts that contain resources that the path can traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAccounts(String... additionalAccounts);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * </p>
         * 
         * @param filterInArns
         *        The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterInArns(Collection<String> filterInArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * </p>
         * 
         * @param filterInArns
         *        The Amazon Resource Names (ARN) of the resources that the path must traverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterInArns(String... filterInArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources that the path will ignore.
         * </p>
         * 
         * @param filterOutArns
         *        The Amazon Resource Names (ARN) of the resources that the path will ignore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOutArns(Collection<String> filterOutArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the resources that the path will ignore.
         * </p>
         * 
         * @param filterOutArns
         *        The Amazon Resource Names (ARN) of the resources that the path will ignore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOutArns(String... filterOutArns);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The tags to apply.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to
         * ensure idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String networkInsightsPathId;

        private List<String> additionalAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<String> filterInArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> filterOutArns = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartNetworkInsightsAnalysisRequest model) {
            super(model);
            networkInsightsPathId(model.networkInsightsPathId);
            additionalAccounts(model.additionalAccounts);
            filterInArns(model.filterInArns);
            filterOutArns(model.filterOutArns);
            dryRun(model.dryRun);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
        }

        public final String getNetworkInsightsPathId() {
            return networkInsightsPathId;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        @Override
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final Collection<String> getAdditionalAccounts() {
            if (additionalAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalAccounts;
        }

        public final void setAdditionalAccounts(Collection<String> additionalAccounts) {
            this.additionalAccounts = ValueStringListCopier.copy(additionalAccounts);
        }

        @Override
        public final Builder additionalAccounts(Collection<String> additionalAccounts) {
            this.additionalAccounts = ValueStringListCopier.copy(additionalAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAccounts(String... additionalAccounts) {
            additionalAccounts(Arrays.asList(additionalAccounts));
            return this;
        }

        public final Collection<String> getFilterInArns() {
            if (filterInArns instanceof SdkAutoConstructList) {
                return null;
            }
            return filterInArns;
        }

        public final void setFilterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
        }

        @Override
        public final Builder filterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterInArns(String... filterInArns) {
            filterInArns(Arrays.asList(filterInArns));
            return this;
        }

        public final Collection<String> getFilterOutArns() {
            if (filterOutArns instanceof SdkAutoConstructList) {
                return null;
            }
            return filterOutArns;
        }

        public final void setFilterOutArns(Collection<String> filterOutArns) {
            this.filterOutArns = ArnListCopier.copy(filterOutArns);
        }

        @Override
        public final Builder filterOutArns(Collection<String> filterOutArns) {
            this.filterOutArns = ArnListCopier.copy(filterOutArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOutArns(String... filterOutArns) {
            filterOutArns(Arrays.asList(filterOutArns));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNetworkInsightsAnalysisRequest build() {
            return new StartNetworkInsightsAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
