/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCapacityReservationResponse extends Ec2Response implements
        ToCopyableBuilder<CreateCapacityReservationResponse.Builder, CreateCapacityReservationResponse> {
    private static final SdkField<CapacityReservation> CAPACITY_RESERVATION_FIELD = SdkField
            .<CapacityReservation> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservation")
            .getter(getter(CreateCapacityReservationResponse::capacityReservation))
            .setter(setter(Builder::capacityReservation))
            .constructor(CapacityReservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservation")
                    .unmarshallLocationName("capacityReservation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CapacityReservation capacityReservation;

    private CreateCapacityReservationResponse(BuilderImpl builder) {
        super(builder);
        this.capacityReservation = builder.capacityReservation;
    }

    /**
     * <p>
     * Information about the Capacity Reservation.
     * </p>
     * 
     * @return Information about the Capacity Reservation.
     */
    public final CapacityReservation capacityReservation() {
        return capacityReservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationResponse)) {
            return false;
        }
        CreateCapacityReservationResponse other = (CreateCapacityReservationResponse) obj;
        return Objects.equals(capacityReservation(), other.capacityReservation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCapacityReservationResponse").add("CapacityReservation", capacityReservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservation":
            return Optional.ofNullable(clazz.cast(capacityReservation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservation", CAPACITY_RESERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityReservationResponse, T> g) {
        return obj -> g.apply((CreateCapacityReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateCapacityReservationResponse> {
        /**
         * <p>
         * Information about the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservation
         *        Information about the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservation(CapacityReservation capacityReservation);

        /**
         * <p>
         * Information about the Capacity Reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservation.Builder} avoiding the
         * need to create one manually via {@link CapacityReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservation.Builder#build()} is called immediately and
         * its result is passed to {@link #capacityReservation(CapacityReservation)}.
         * 
         * @param capacityReservation
         *        a consumer that will call methods on {@link CapacityReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservation(CapacityReservation)
         */
        default Builder capacityReservation(Consumer<CapacityReservation.Builder> capacityReservation) {
            return capacityReservation(CapacityReservation.builder().applyMutation(capacityReservation).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private CapacityReservation capacityReservation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityReservationResponse model) {
            super(model);
            capacityReservation(model.capacityReservation);
        }

        public final CapacityReservation.Builder getCapacityReservation() {
            return capacityReservation != null ? capacityReservation.toBuilder() : null;
        }

        public final void setCapacityReservation(CapacityReservation.BuilderImpl capacityReservation) {
            this.capacityReservation = capacityReservation != null ? capacityReservation.build() : null;
        }

        @Override
        public final Builder capacityReservation(CapacityReservation capacityReservation) {
            this.capacityReservation = capacityReservation;
            return this;
        }

        @Override
        public CreateCapacityReservationResponse build() {
            return new CreateCapacityReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
