/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes fast snapshot restores that were successfully disabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisableFastSnapshotRestoreSuccessItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DisableFastSnapshotRestoreSuccessItem.Builder, DisableFastSnapshotRestoreSuccessItem> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StateTransitionReason")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::stateTransitionReason))
            .setter(setter(Builder::stateTransitionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason")
                    .unmarshallLocationName("stateTransitionReason").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerAlias")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::ownerAlias))
            .setter(setter(Builder::ownerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias")
                    .unmarshallLocationName("ownerAlias").build()).build();

    private static final SdkField<Instant> ENABLING_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EnablingTime")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::enablingTime))
            .setter(setter(Builder::enablingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablingTime")
                    .unmarshallLocationName("enablingTime").build()).build();

    private static final SdkField<Instant> OPTIMIZING_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("OptimizingTime")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::optimizingTime))
            .setter(setter(Builder::optimizingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizingTime")
                    .unmarshallLocationName("optimizingTime").build()).build();

    private static final SdkField<Instant> ENABLED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EnabledTime")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::enabledTime))
            .setter(setter(Builder::enabledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledTime")
                    .unmarshallLocationName("enabledTime").build()).build();

    private static final SdkField<Instant> DISABLING_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisablingTime")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::disablingTime))
            .setter(setter(Builder::disablingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisablingTime")
                    .unmarshallLocationName("disablingTime").build()).build();

    private static final SdkField<Instant> DISABLED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisabledTime")
            .getter(getter(DisableFastSnapshotRestoreSuccessItem::disabledTime))
            .setter(setter(Builder::disabledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledTime")
                    .unmarshallLocationName("disabledTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            AVAILABILITY_ZONE_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, OWNER_ID_FIELD, OWNER_ALIAS_FIELD,
            ENABLING_TIME_FIELD, OPTIMIZING_TIME_FIELD, ENABLED_TIME_FIELD, DISABLING_TIME_FIELD, DISABLED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final String availabilityZone;

    private final String state;

    private final String stateTransitionReason;

    private final String ownerId;

    private final String ownerAlias;

    private final Instant enablingTime;

    private final Instant optimizingTime;

    private final Instant enabledTime;

    private final Instant disablingTime;

    private final Instant disabledTime;

    private DisableFastSnapshotRestoreSuccessItem(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.ownerId = builder.ownerId;
        this.ownerAlias = builder.ownerAlias;
        this.enablingTime = builder.enablingTime;
        this.optimizingTime = builder.optimizingTime;
        this.enabledTime = builder.enabledTime;
        this.disablingTime = builder.disablingTime;
        this.disabledTime = builder.disabledTime;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The state of fast snapshot restores for the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FastSnapshotRestoreStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of fast snapshot restores for the snapshot.
     * @see FastSnapshotRestoreStateCode
     */
    public final FastSnapshotRestoreStateCode state() {
        return FastSnapshotRestoreStateCode.fromValue(state);
    }

    /**
     * <p>
     * The state of fast snapshot restores for the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FastSnapshotRestoreStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of fast snapshot restores for the snapshot.
     * @see FastSnapshotRestoreStateCode
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the state transition. The possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or
     * <code>disabling</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned to
     * <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The reason for the state transition. The possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or
     *         <code>disabling</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned to
     *         <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.
     *         </p>
     *         </li>
     */
    public final String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for
     * future use.
     * </p>
     * 
     * @return The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended
     *         for future use.
     */
    public final String ownerAlias() {
        return ownerAlias;
    }

    /**
     * <p>
     * The time at which fast snapshot restores entered the <code>enabling</code> state.
     * </p>
     * 
     * @return The time at which fast snapshot restores entered the <code>enabling</code> state.
     */
    public final Instant enablingTime() {
        return enablingTime;
    }

    /**
     * <p>
     * The time at which fast snapshot restores entered the <code>optimizing</code> state.
     * </p>
     * 
     * @return The time at which fast snapshot restores entered the <code>optimizing</code> state.
     */
    public final Instant optimizingTime() {
        return optimizingTime;
    }

    /**
     * <p>
     * The time at which fast snapshot restores entered the <code>enabled</code> state.
     * </p>
     * 
     * @return The time at which fast snapshot restores entered the <code>enabled</code> state.
     */
    public final Instant enabledTime() {
        return enabledTime;
    }

    /**
     * <p>
     * The time at which fast snapshot restores entered the <code>disabling</code> state.
     * </p>
     * 
     * @return The time at which fast snapshot restores entered the <code>disabling</code> state.
     */
    public final Instant disablingTime() {
        return disablingTime;
    }

    /**
     * <p>
     * The time at which fast snapshot restores entered the <code>disabled</code> state.
     * </p>
     * 
     * @return The time at which fast snapshot restores entered the <code>disabled</code> state.
     */
    public final Instant disabledTime() {
        return disabledTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(enablingTime());
        hashCode = 31 * hashCode + Objects.hashCode(optimizingTime());
        hashCode = 31 * hashCode + Objects.hashCode(enabledTime());
        hashCode = 31 * hashCode + Objects.hashCode(disablingTime());
        hashCode = 31 * hashCode + Objects.hashCode(disabledTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFastSnapshotRestoreSuccessItem)) {
            return false;
        }
        DisableFastSnapshotRestoreSuccessItem other = (DisableFastSnapshotRestoreSuccessItem) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(ownerAlias(), other.ownerAlias())
                && Objects.equals(enablingTime(), other.enablingTime())
                && Objects.equals(optimizingTime(), other.optimizingTime()) && Objects.equals(enabledTime(), other.enabledTime())
                && Objects.equals(disablingTime(), other.disablingTime()) && Objects.equals(disabledTime(), other.disabledTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisableFastSnapshotRestoreSuccessItem").add("SnapshotId", snapshotId())
                .add("AvailabilityZone", availabilityZone()).add("State", stateAsString())
                .add("StateTransitionReason", stateTransitionReason()).add("OwnerId", ownerId()).add("OwnerAlias", ownerAlias())
                .add("EnablingTime", enablingTime()).add("OptimizingTime", optimizingTime()).add("EnabledTime", enabledTime())
                .add("DisablingTime", disablingTime()).add("DisabledTime", disabledTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateTransitionReason":
            return Optional.ofNullable(clazz.cast(stateTransitionReason()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "OwnerAlias":
            return Optional.ofNullable(clazz.cast(ownerAlias()));
        case "EnablingTime":
            return Optional.ofNullable(clazz.cast(enablingTime()));
        case "OptimizingTime":
            return Optional.ofNullable(clazz.cast(optimizingTime()));
        case "EnabledTime":
            return Optional.ofNullable(clazz.cast(enabledTime()));
        case "DisablingTime":
            return Optional.ofNullable(clazz.cast(disablingTime()));
        case "DisabledTime":
            return Optional.ofNullable(clazz.cast(disabledTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateTransitionReason", STATE_TRANSITION_REASON_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("OwnerAlias", OWNER_ALIAS_FIELD);
        map.put("EnablingTime", ENABLING_TIME_FIELD);
        map.put("OptimizingTime", OPTIMIZING_TIME_FIELD);
        map.put("EnabledTime", ENABLED_TIME_FIELD);
        map.put("DisablingTime", DISABLING_TIME_FIELD);
        map.put("DisabledTime", DISABLED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisableFastSnapshotRestoreSuccessItem, T> g) {
        return obj -> g.apply((DisableFastSnapshotRestoreSuccessItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisableFastSnapshotRestoreSuccessItem> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The state of fast snapshot restores for the snapshot.
         * </p>
         * 
         * @param state
         *        The state of fast snapshot restores for the snapshot.
         * @see FastSnapshotRestoreStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FastSnapshotRestoreStateCode
         */
        Builder state(String state);

        /**
         * <p>
         * The state of fast snapshot restores for the snapshot.
         * </p>
         * 
         * @param state
         *        The state of fast snapshot restores for the snapshot.
         * @see FastSnapshotRestoreStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FastSnapshotRestoreStateCode
         */
        Builder state(FastSnapshotRestoreStateCode state);

        /**
         * <p>
         * The reason for the state transition. The possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or
         * <code>disabling</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned to
         * <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stateTransitionReason
         *        The reason for the state transition. The possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Client.UserInitiated</code> - The state successfully transitioned to <code>enabling</code> or
         *        <code>disabling</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.UserInitiated - Lifecycle state transition</code> - The state successfully transitioned
         *        to <code>optimizing</code>, <code>enabled</code>, or <code>disabled</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that enabled fast snapshot restores on the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is intended for
         * future use.
         * </p>
         * 
         * @param ownerAlias
         *        The Amazon Web Services owner alias that enabled fast snapshot restores on the snapshot. This is
         *        intended for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);

        /**
         * <p>
         * The time at which fast snapshot restores entered the <code>enabling</code> state.
         * </p>
         * 
         * @param enablingTime
         *        The time at which fast snapshot restores entered the <code>enabling</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablingTime(Instant enablingTime);

        /**
         * <p>
         * The time at which fast snapshot restores entered the <code>optimizing</code> state.
         * </p>
         * 
         * @param optimizingTime
         *        The time at which fast snapshot restores entered the <code>optimizing</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizingTime(Instant optimizingTime);

        /**
         * <p>
         * The time at which fast snapshot restores entered the <code>enabled</code> state.
         * </p>
         * 
         * @param enabledTime
         *        The time at which fast snapshot restores entered the <code>enabled</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledTime(Instant enabledTime);

        /**
         * <p>
         * The time at which fast snapshot restores entered the <code>disabling</code> state.
         * </p>
         * 
         * @param disablingTime
         *        The time at which fast snapshot restores entered the <code>disabling</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disablingTime(Instant disablingTime);

        /**
         * <p>
         * The time at which fast snapshot restores entered the <code>disabled</code> state.
         * </p>
         * 
         * @param disabledTime
         *        The time at which fast snapshot restores entered the <code>disabled</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledTime(Instant disabledTime);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private String availabilityZone;

        private String state;

        private String stateTransitionReason;

        private String ownerId;

        private String ownerAlias;

        private Instant enablingTime;

        private Instant optimizingTime;

        private Instant enabledTime;

        private Instant disablingTime;

        private Instant disabledTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFastSnapshotRestoreSuccessItem model) {
            snapshotId(model.snapshotId);
            availabilityZone(model.availabilityZone);
            state(model.state);
            stateTransitionReason(model.stateTransitionReason);
            ownerId(model.ownerId);
            ownerAlias(model.ownerAlias);
            enablingTime(model.enablingTime);
            optimizingTime(model.optimizingTime);
            enabledTime(model.enabledTime);
            disablingTime(model.disablingTime);
            disabledTime(model.disabledTime);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FastSnapshotRestoreStateCode state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final Instant getEnablingTime() {
            return enablingTime;
        }

        public final void setEnablingTime(Instant enablingTime) {
            this.enablingTime = enablingTime;
        }

        @Override
        public final Builder enablingTime(Instant enablingTime) {
            this.enablingTime = enablingTime;
            return this;
        }

        public final Instant getOptimizingTime() {
            return optimizingTime;
        }

        public final void setOptimizingTime(Instant optimizingTime) {
            this.optimizingTime = optimizingTime;
        }

        @Override
        public final Builder optimizingTime(Instant optimizingTime) {
            this.optimizingTime = optimizingTime;
            return this;
        }

        public final Instant getEnabledTime() {
            return enabledTime;
        }

        public final void setEnabledTime(Instant enabledTime) {
            this.enabledTime = enabledTime;
        }

        @Override
        public final Builder enabledTime(Instant enabledTime) {
            this.enabledTime = enabledTime;
            return this;
        }

        public final Instant getDisablingTime() {
            return disablingTime;
        }

        public final void setDisablingTime(Instant disablingTime) {
            this.disablingTime = disablingTime;
        }

        @Override
        public final Builder disablingTime(Instant disablingTime) {
            this.disablingTime = disablingTime;
            return this;
        }

        public final Instant getDisabledTime() {
            return disabledTime;
        }

        public final void setDisabledTime(Instant disabledTime) {
            this.disabledTime = disabledTime;
        }

        @Override
        public final Builder disabledTime(Instant disabledTime) {
            this.disabledTime = disabledTime;
            return this;
        }

        @Override
        public DisableFastSnapshotRestoreSuccessItem build() {
            return new DisableFastSnapshotRestoreSuccessItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
