/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.waiters;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
@ThreadSafe
final class DefaultEc2Waiter implements Ec2Waiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute<>(SdkAutoCloseable.class);

    private final Ec2Client client;

    private final AttributeMap managedResources;

    private final Waiter<DescribeInstancesResponse> instanceExistsWaiter;

    private final Waiter<DescribeBundleTasksResponse> bundleTaskCompleteWaiter;

    private final Waiter<DescribeConversionTasksResponse> conversionTaskCancelledWaiter;

    private final Waiter<DescribeConversionTasksResponse> conversionTaskCompletedWaiter;

    private final Waiter<DescribeConversionTasksResponse> conversionTaskDeletedWaiter;

    private final Waiter<DescribeCustomerGatewaysResponse> customerGatewayAvailableWaiter;

    private final Waiter<DescribeExportTasksResponse> exportTaskCancelledWaiter;

    private final Waiter<DescribeExportTasksResponse> exportTaskCompletedWaiter;

    private final Waiter<DescribeImagesResponse> imageExistsWaiter;

    private final Waiter<DescribeImagesResponse> imageAvailableWaiter;

    private final Waiter<DescribeInstancesResponse> instanceRunningWaiter;

    private final Waiter<DescribeInstanceStatusResponse> instanceStatusOkWaiter;

    private final Waiter<DescribeInstancesResponse> instanceStoppedWaiter;

    private final Waiter<DescribeInstancesResponse> instanceTerminatedWaiter;

    private final Waiter<DescribeInternetGatewaysResponse> internetGatewayExistsWaiter;

    private final Waiter<DescribeKeyPairsResponse> keyPairExistsWaiter;

    private final Waiter<DescribeNatGatewaysResponse> natGatewayAvailableWaiter;

    private final Waiter<DescribeNatGatewaysResponse> natGatewayDeletedWaiter;

    private final Waiter<DescribeNetworkInterfacesResponse> networkInterfaceAvailableWaiter;

    private final Waiter<GetPasswordDataResponse> passwordDataAvailableWaiter;

    private final Waiter<DescribeSnapshotsResponse> snapshotCompletedWaiter;

    private final Waiter<DescribeImportSnapshotTasksResponse> snapshotImportedWaiter;

    private final Waiter<DescribeSecurityGroupsResponse> securityGroupExistsWaiter;

    private final Waiter<DescribeSpotInstanceRequestsResponse> spotInstanceRequestFulfilledWaiter;

    private final Waiter<DescribeStoreImageTasksResponse> storeImageTaskCompleteWaiter;

    private final Waiter<DescribeSubnetsResponse> subnetAvailableWaiter;

    private final Waiter<DescribeInstanceStatusResponse> systemStatusOkWaiter;

    private final Waiter<DescribeVolumesResponse> volumeAvailableWaiter;

    private final Waiter<DescribeVolumesResponse> volumeDeletedWaiter;

    private final Waiter<DescribeVolumesResponse> volumeInUseWaiter;

    private final Waiter<DescribeVpcsResponse> vpcAvailableWaiter;

    private final Waiter<DescribeVpcsResponse> vpcExistsWaiter;

    private final Waiter<DescribeVpnConnectionsResponse> vpnConnectionAvailableWaiter;

    private final Waiter<DescribeVpnConnectionsResponse> vpnConnectionDeletedWaiter;

    private final Waiter<DescribeVpcPeeringConnectionsResponse> vpcPeeringConnectionExistsWaiter;

    private final Waiter<DescribeVpcPeeringConnectionsResponse> vpcPeeringConnectionDeletedWaiter;

    private DefaultEc2Waiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = Ec2Client.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, this.client);
        } else {
            this.client = builder.client;
        }
        managedResources = attributeMapBuilder.build();
        this.instanceExistsWaiter = Waiter.builder(DescribeInstancesResponse.class).acceptors(instanceExistsWaiterAcceptors())
                .overrideConfiguration(instanceExistsWaiterConfig(builder.overrideConfiguration)).build();
        this.bundleTaskCompleteWaiter = Waiter.builder(DescribeBundleTasksResponse.class)
                .acceptors(bundleTaskCompleteWaiterAcceptors())
                .overrideConfiguration(bundleTaskCompleteWaiterConfig(builder.overrideConfiguration)).build();
        this.conversionTaskCancelledWaiter = Waiter.builder(DescribeConversionTasksResponse.class)
                .acceptors(conversionTaskCancelledWaiterAcceptors())
                .overrideConfiguration(conversionTaskCancelledWaiterConfig(builder.overrideConfiguration)).build();
        this.conversionTaskCompletedWaiter = Waiter.builder(DescribeConversionTasksResponse.class)
                .acceptors(conversionTaskCompletedWaiterAcceptors())
                .overrideConfiguration(conversionTaskCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.conversionTaskDeletedWaiter = Waiter.builder(DescribeConversionTasksResponse.class)
                .acceptors(conversionTaskDeletedWaiterAcceptors())
                .overrideConfiguration(conversionTaskDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.customerGatewayAvailableWaiter = Waiter.builder(DescribeCustomerGatewaysResponse.class)
                .acceptors(customerGatewayAvailableWaiterAcceptors())
                .overrideConfiguration(customerGatewayAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.exportTaskCancelledWaiter = Waiter.builder(DescribeExportTasksResponse.class)
                .acceptors(exportTaskCancelledWaiterAcceptors())
                .overrideConfiguration(exportTaskCancelledWaiterConfig(builder.overrideConfiguration)).build();
        this.exportTaskCompletedWaiter = Waiter.builder(DescribeExportTasksResponse.class)
                .acceptors(exportTaskCompletedWaiterAcceptors())
                .overrideConfiguration(exportTaskCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.imageExistsWaiter = Waiter.builder(DescribeImagesResponse.class).acceptors(imageExistsWaiterAcceptors())
                .overrideConfiguration(imageExistsWaiterConfig(builder.overrideConfiguration)).build();
        this.imageAvailableWaiter = Waiter.builder(DescribeImagesResponse.class).acceptors(imageAvailableWaiterAcceptors())
                .overrideConfiguration(imageAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.instanceRunningWaiter = Waiter.builder(DescribeInstancesResponse.class).acceptors(instanceRunningWaiterAcceptors())
                .overrideConfiguration(instanceRunningWaiterConfig(builder.overrideConfiguration)).build();
        this.instanceStatusOkWaiter = Waiter.builder(DescribeInstanceStatusResponse.class)
                .acceptors(instanceStatusOkWaiterAcceptors())
                .overrideConfiguration(instanceStatusOkWaiterConfig(builder.overrideConfiguration)).build();
        this.instanceStoppedWaiter = Waiter.builder(DescribeInstancesResponse.class).acceptors(instanceStoppedWaiterAcceptors())
                .overrideConfiguration(instanceStoppedWaiterConfig(builder.overrideConfiguration)).build();
        this.instanceTerminatedWaiter = Waiter.builder(DescribeInstancesResponse.class)
                .acceptors(instanceTerminatedWaiterAcceptors())
                .overrideConfiguration(instanceTerminatedWaiterConfig(builder.overrideConfiguration)).build();
        this.internetGatewayExistsWaiter = Waiter.builder(DescribeInternetGatewaysResponse.class)
                .acceptors(internetGatewayExistsWaiterAcceptors())
                .overrideConfiguration(internetGatewayExistsWaiterConfig(builder.overrideConfiguration)).build();
        this.keyPairExistsWaiter = Waiter.builder(DescribeKeyPairsResponse.class).acceptors(keyPairExistsWaiterAcceptors())
                .overrideConfiguration(keyPairExistsWaiterConfig(builder.overrideConfiguration)).build();
        this.natGatewayAvailableWaiter = Waiter.builder(DescribeNatGatewaysResponse.class)
                .acceptors(natGatewayAvailableWaiterAcceptors())
                .overrideConfiguration(natGatewayAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.natGatewayDeletedWaiter = Waiter.builder(DescribeNatGatewaysResponse.class)
                .acceptors(natGatewayDeletedWaiterAcceptors())
                .overrideConfiguration(natGatewayDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.networkInterfaceAvailableWaiter = Waiter.builder(DescribeNetworkInterfacesResponse.class)
                .acceptors(networkInterfaceAvailableWaiterAcceptors())
                .overrideConfiguration(networkInterfaceAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.passwordDataAvailableWaiter = Waiter.builder(GetPasswordDataResponse.class)
                .acceptors(passwordDataAvailableWaiterAcceptors())
                .overrideConfiguration(passwordDataAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.snapshotCompletedWaiter = Waiter.builder(DescribeSnapshotsResponse.class)
                .acceptors(snapshotCompletedWaiterAcceptors())
                .overrideConfiguration(snapshotCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.snapshotImportedWaiter = Waiter.builder(DescribeImportSnapshotTasksResponse.class)
                .acceptors(snapshotImportedWaiterAcceptors())
                .overrideConfiguration(snapshotImportedWaiterConfig(builder.overrideConfiguration)).build();
        this.securityGroupExistsWaiter = Waiter.builder(DescribeSecurityGroupsResponse.class)
                .acceptors(securityGroupExistsWaiterAcceptors())
                .overrideConfiguration(securityGroupExistsWaiterConfig(builder.overrideConfiguration)).build();
        this.spotInstanceRequestFulfilledWaiter = Waiter.builder(DescribeSpotInstanceRequestsResponse.class)
                .acceptors(spotInstanceRequestFulfilledWaiterAcceptors())
                .overrideConfiguration(spotInstanceRequestFulfilledWaiterConfig(builder.overrideConfiguration)).build();
        this.storeImageTaskCompleteWaiter = Waiter.builder(DescribeStoreImageTasksResponse.class)
                .acceptors(storeImageTaskCompleteWaiterAcceptors())
                .overrideConfiguration(storeImageTaskCompleteWaiterConfig(builder.overrideConfiguration)).build();
        this.subnetAvailableWaiter = Waiter.builder(DescribeSubnetsResponse.class).acceptors(subnetAvailableWaiterAcceptors())
                .overrideConfiguration(subnetAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.systemStatusOkWaiter = Waiter.builder(DescribeInstanceStatusResponse.class)
                .acceptors(systemStatusOkWaiterAcceptors())
                .overrideConfiguration(systemStatusOkWaiterConfig(builder.overrideConfiguration)).build();
        this.volumeAvailableWaiter = Waiter.builder(DescribeVolumesResponse.class).acceptors(volumeAvailableWaiterAcceptors())
                .overrideConfiguration(volumeAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.volumeDeletedWaiter = Waiter.builder(DescribeVolumesResponse.class).acceptors(volumeDeletedWaiterAcceptors())
                .overrideConfiguration(volumeDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.volumeInUseWaiter = Waiter.builder(DescribeVolumesResponse.class).acceptors(volumeInUseWaiterAcceptors())
                .overrideConfiguration(volumeInUseWaiterConfig(builder.overrideConfiguration)).build();
        this.vpcAvailableWaiter = Waiter.builder(DescribeVpcsResponse.class).acceptors(vpcAvailableWaiterAcceptors())
                .overrideConfiguration(vpcAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.vpcExistsWaiter = Waiter.builder(DescribeVpcsResponse.class).acceptors(vpcExistsWaiterAcceptors())
                .overrideConfiguration(vpcExistsWaiterConfig(builder.overrideConfiguration)).build();
        this.vpnConnectionAvailableWaiter = Waiter.builder(DescribeVpnConnectionsResponse.class)
                .acceptors(vpnConnectionAvailableWaiterAcceptors())
                .overrideConfiguration(vpnConnectionAvailableWaiterConfig(builder.overrideConfiguration)).build();
        this.vpnConnectionDeletedWaiter = Waiter.builder(DescribeVpnConnectionsResponse.class)
                .acceptors(vpnConnectionDeletedWaiterAcceptors())
                .overrideConfiguration(vpnConnectionDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.vpcPeeringConnectionExistsWaiter = Waiter.builder(DescribeVpcPeeringConnectionsResponse.class)
                .acceptors(vpcPeeringConnectionExistsWaiterAcceptors())
                .overrideConfiguration(vpcPeeringConnectionExistsWaiterConfig(builder.overrideConfiguration)).build();
        this.vpcPeeringConnectionDeletedWaiter = Waiter.builder(DescribeVpcPeeringConnectionsResponse.class)
                .acceptors(vpcPeeringConnectionDeletedWaiterAcceptors())
                .overrideConfiguration(vpcPeeringConnectionDeletedWaiterConfig(builder.overrideConfiguration)).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException) error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeBundleTasksResponse> waitUntilBundleTaskComplete(
            DescribeBundleTasksRequest describeBundleTasksRequest) {
        return bundleTaskCompleteWaiter.run(() -> client.describeBundleTasks(applyWaitersUserAgent(describeBundleTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeBundleTasksResponse> waitUntilBundleTaskComplete(
            DescribeBundleTasksRequest describeBundleTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return bundleTaskCompleteWaiter.run(() -> client.describeBundleTasks(applyWaitersUserAgent(describeBundleTasksRequest)),
                bundleTaskCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCancelled(
            DescribeConversionTasksRequest describeConversionTasksRequest) {
        return conversionTaskCancelledWaiter.run(() -> client
                .describeConversionTasks(applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCancelled(
            DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return conversionTaskCancelledWaiter.run(
                () -> client.describeConversionTasks(applyWaitersUserAgent(describeConversionTasksRequest)),
                conversionTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCompleted(
            DescribeConversionTasksRequest describeConversionTasksRequest) {
        return conversionTaskCompletedWaiter.run(() -> client
                .describeConversionTasks(applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCompleted(
            DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return conversionTaskCompletedWaiter.run(
                () -> client.describeConversionTasks(applyWaitersUserAgent(describeConversionTasksRequest)),
                conversionTaskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskDeleted(
            DescribeConversionTasksRequest describeConversionTasksRequest) {
        return conversionTaskDeletedWaiter.run(() -> client
                .describeConversionTasks(applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskDeleted(
            DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return conversionTaskDeletedWaiter.run(
                () -> client.describeConversionTasks(applyWaitersUserAgent(describeConversionTasksRequest)),
                conversionTaskDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeCustomerGatewaysResponse> waitUntilCustomerGatewayAvailable(
            DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        return customerGatewayAvailableWaiter.run(() -> client
                .describeCustomerGateways(applyWaitersUserAgent(describeCustomerGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeCustomerGatewaysResponse> waitUntilCustomerGatewayAvailable(
            DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return customerGatewayAvailableWaiter.run(
                () -> client.describeCustomerGateways(applyWaitersUserAgent(describeCustomerGatewaysRequest)),
                customerGatewayAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCancelled(
            DescribeExportTasksRequest describeExportTasksRequest) {
        return exportTaskCancelledWaiter.run(() -> client.describeExportTasks(applyWaitersUserAgent(describeExportTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCancelled(
            DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return exportTaskCancelledWaiter.run(() -> client.describeExportTasks(applyWaitersUserAgent(describeExportTasksRequest)),
                exportTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCompleted(
            DescribeExportTasksRequest describeExportTasksRequest) {
        return exportTaskCompletedWaiter.run(() -> client.describeExportTasks(applyWaitersUserAgent(describeExportTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCompleted(
            DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return exportTaskCompletedWaiter.run(() -> client.describeExportTasks(applyWaitersUserAgent(describeExportTasksRequest)),
                exportTaskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageAvailable(DescribeImagesRequest describeImagesRequest) {
        return imageAvailableWaiter.run(() -> client.describeImages(applyWaitersUserAgent(describeImagesRequest)));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageAvailable(DescribeImagesRequest describeImagesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return imageAvailableWaiter.run(() -> client.describeImages(applyWaitersUserAgent(describeImagesRequest)),
                imageAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageExists(DescribeImagesRequest describeImagesRequest) {
        return imageExistsWaiter.run(() -> client.describeImages(applyWaitersUserAgent(describeImagesRequest)));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageExists(DescribeImagesRequest describeImagesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return imageExistsWaiter.run(() -> client.describeImages(applyWaitersUserAgent(describeImagesRequest)),
                imageExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceExists(DescribeInstancesRequest describeInstancesRequest) {
        return instanceExistsWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceExists(DescribeInstancesRequest describeInstancesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return instanceExistsWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)),
                instanceExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceRunning(DescribeInstancesRequest describeInstancesRequest) {
        return instanceRunningWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceRunning(DescribeInstancesRequest describeInstancesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return instanceRunningWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)),
                instanceRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilInstanceStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        return instanceStatusOkWaiter.run(() -> client
                .describeInstanceStatus(applyWaitersUserAgent(describeInstanceStatusRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilInstanceStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return instanceStatusOkWaiter.run(
                () -> client.describeInstanceStatus(applyWaitersUserAgent(describeInstanceStatusRequest)),
                instanceStatusOkWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceStopped(DescribeInstancesRequest describeInstancesRequest) {
        return instanceStoppedWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceStopped(DescribeInstancesRequest describeInstancesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return instanceStoppedWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)),
                instanceStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceTerminated(DescribeInstancesRequest describeInstancesRequest) {
        return instanceTerminatedWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceTerminated(
            DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return instanceTerminatedWaiter.run(() -> client.describeInstances(applyWaitersUserAgent(describeInstancesRequest)),
                instanceTerminatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInternetGatewaysResponse> waitUntilInternetGatewayExists(
            DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        return internetGatewayExistsWaiter.run(() -> client
                .describeInternetGateways(applyWaitersUserAgent(describeInternetGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeInternetGatewaysResponse> waitUntilInternetGatewayExists(
            DescribeInternetGatewaysRequest describeInternetGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return internetGatewayExistsWaiter.run(
                () -> client.describeInternetGateways(applyWaitersUserAgent(describeInternetGatewaysRequest)),
                internetGatewayExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeKeyPairsResponse> waitUntilKeyPairExists(DescribeKeyPairsRequest describeKeyPairsRequest) {
        return keyPairExistsWaiter.run(() -> client.describeKeyPairs(applyWaitersUserAgent(describeKeyPairsRequest)));
    }

    @Override
    public WaiterResponse<DescribeKeyPairsResponse> waitUntilKeyPairExists(DescribeKeyPairsRequest describeKeyPairsRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return keyPairExistsWaiter.run(() -> client.describeKeyPairs(applyWaitersUserAgent(describeKeyPairsRequest)),
                keyPairExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayAvailable(
            DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        return natGatewayAvailableWaiter.run(() -> client.describeNatGateways(applyWaitersUserAgent(describeNatGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayAvailable(
            DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return natGatewayAvailableWaiter.run(() -> client.describeNatGateways(applyWaitersUserAgent(describeNatGatewaysRequest)),
                natGatewayAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayDeleted(
            DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        return natGatewayDeletedWaiter.run(() -> client.describeNatGateways(applyWaitersUserAgent(describeNatGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayDeleted(
            DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return natGatewayDeletedWaiter.run(() -> client.describeNatGateways(applyWaitersUserAgent(describeNatGatewaysRequest)),
                natGatewayDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNetworkInterfacesResponse> waitUntilNetworkInterfaceAvailable(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        return networkInterfaceAvailableWaiter.run(() -> client
                .describeNetworkInterfaces(applyWaitersUserAgent(describeNetworkInterfacesRequest)));
    }

    @Override
    public WaiterResponse<DescribeNetworkInterfacesResponse> waitUntilNetworkInterfaceAvailable(
            DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest, WaiterOverrideConfiguration overrideConfig) {
        return networkInterfaceAvailableWaiter.run(
                () -> client.describeNetworkInterfaces(applyWaitersUserAgent(describeNetworkInterfacesRequest)),
                networkInterfaceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPasswordDataResponse> waitUntilPasswordDataAvailable(GetPasswordDataRequest getPasswordDataRequest) {
        return passwordDataAvailableWaiter.run(() -> client.getPasswordData(applyWaitersUserAgent(getPasswordDataRequest)));
    }

    @Override
    public WaiterResponse<GetPasswordDataResponse> waitUntilPasswordDataAvailable(GetPasswordDataRequest getPasswordDataRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return passwordDataAvailableWaiter.run(() -> client.getPasswordData(applyWaitersUserAgent(getPasswordDataRequest)),
                passwordDataAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSecurityGroupsResponse> waitUntilSecurityGroupExists(
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        return securityGroupExistsWaiter.run(() -> client
                .describeSecurityGroups(applyWaitersUserAgent(describeSecurityGroupsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSecurityGroupsResponse> waitUntilSecurityGroupExists(
            DescribeSecurityGroupsRequest describeSecurityGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return securityGroupExistsWaiter.run(
                () -> client.describeSecurityGroups(applyWaitersUserAgent(describeSecurityGroupsRequest)),
                securityGroupExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSnapshotsResponse> waitUntilSnapshotCompleted(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return snapshotCompletedWaiter.run(() -> client.describeSnapshots(applyWaitersUserAgent(describeSnapshotsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSnapshotsResponse> waitUntilSnapshotCompleted(
            DescribeSnapshotsRequest describeSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return snapshotCompletedWaiter.run(() -> client.describeSnapshots(applyWaitersUserAgent(describeSnapshotsRequest)),
                snapshotCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImportSnapshotTasksResponse> waitUntilSnapshotImported(
            DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        return snapshotImportedWaiter.run(() -> client
                .describeImportSnapshotTasks(applyWaitersUserAgent(describeImportSnapshotTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeImportSnapshotTasksResponse> waitUntilSnapshotImported(
            DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return snapshotImportedWaiter.run(
                () -> client.describeImportSnapshotTasks(applyWaitersUserAgent(describeImportSnapshotTasksRequest)),
                snapshotImportedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSpotInstanceRequestsResponse> waitUntilSpotInstanceRequestFulfilled(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {
        return spotInstanceRequestFulfilledWaiter.run(() -> client
                .describeSpotInstanceRequests(applyWaitersUserAgent(describeSpotInstanceRequestsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSpotInstanceRequestsResponse> waitUntilSpotInstanceRequestFulfilled(
            DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest, WaiterOverrideConfiguration overrideConfig) {
        return spotInstanceRequestFulfilledWaiter.run(
                () -> client.describeSpotInstanceRequests(applyWaitersUserAgent(describeSpotInstanceRequestsRequest)),
                spotInstanceRequestFulfilledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStoreImageTasksResponse> waitUntilStoreImageTaskComplete(
            DescribeStoreImageTasksRequest describeStoreImageTasksRequest) {
        return storeImageTaskCompleteWaiter.run(() -> client
                .describeStoreImageTasks(applyWaitersUserAgent(describeStoreImageTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStoreImageTasksResponse> waitUntilStoreImageTaskComplete(
            DescribeStoreImageTasksRequest describeStoreImageTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return storeImageTaskCompleteWaiter.run(
                () -> client.describeStoreImageTasks(applyWaitersUserAgent(describeStoreImageTasksRequest)),
                storeImageTaskCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSubnetsResponse> waitUntilSubnetAvailable(DescribeSubnetsRequest describeSubnetsRequest) {
        return subnetAvailableWaiter.run(() -> client.describeSubnets(applyWaitersUserAgent(describeSubnetsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSubnetsResponse> waitUntilSubnetAvailable(DescribeSubnetsRequest describeSubnetsRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return subnetAvailableWaiter.run(() -> client.describeSubnets(applyWaitersUserAgent(describeSubnetsRequest)),
                subnetAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilSystemStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        return systemStatusOkWaiter
                .run(() -> client.describeInstanceStatus(applyWaitersUserAgent(describeInstanceStatusRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilSystemStatusOk(
            DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return systemStatusOkWaiter.run(
                () -> client.describeInstanceStatus(applyWaitersUserAgent(describeInstanceStatusRequest)),
                systemStatusOkWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeAvailable(DescribeVolumesRequest describeVolumesRequest) {
        return volumeAvailableWaiter.run(() -> client.describeVolumes(applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeAvailable(DescribeVolumesRequest describeVolumesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return volumeAvailableWaiter.run(() -> client.describeVolumes(applyWaitersUserAgent(describeVolumesRequest)),
                volumeAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeDeleted(DescribeVolumesRequest describeVolumesRequest) {
        return volumeDeletedWaiter.run(() -> client.describeVolumes(applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeDeleted(DescribeVolumesRequest describeVolumesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return volumeDeletedWaiter.run(() -> client.describeVolumes(applyWaitersUserAgent(describeVolumesRequest)),
                volumeDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeInUse(DescribeVolumesRequest describeVolumesRequest) {
        return volumeInUseWaiter.run(() -> client.describeVolumes(applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeInUse(DescribeVolumesRequest describeVolumesRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return volumeInUseWaiter.run(() -> client.describeVolumes(applyWaitersUserAgent(describeVolumesRequest)),
                volumeInUseWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcAvailable(DescribeVpcsRequest describeVpcsRequest) {
        return vpcAvailableWaiter.run(() -> client.describeVpcs(applyWaitersUserAgent(describeVpcsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcAvailable(DescribeVpcsRequest describeVpcsRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return vpcAvailableWaiter.run(() -> client.describeVpcs(applyWaitersUserAgent(describeVpcsRequest)),
                vpcAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest) {
        return vpcExistsWaiter.run(() -> client.describeVpcs(applyWaitersUserAgent(describeVpcsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return vpcExistsWaiter.run(() -> client.describeVpcs(applyWaitersUserAgent(describeVpcsRequest)),
                vpcExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionDeleted(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        return vpcPeeringConnectionDeletedWaiter.run(() -> client
                .describeVpcPeeringConnections(applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionDeleted(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return vpcPeeringConnectionDeletedWaiter.run(
                () -> client.describeVpcPeeringConnections(applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)),
                vpcPeeringConnectionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionExists(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        return vpcPeeringConnectionExistsWaiter.run(() -> client
                .describeVpcPeeringConnections(applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionExists(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return vpcPeeringConnectionExistsWaiter.run(
                () -> client.describeVpcPeeringConnections(applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)),
                vpcPeeringConnectionExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionAvailable(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        return vpnConnectionAvailableWaiter.run(() -> client
                .describeVpnConnections(applyWaitersUserAgent(describeVpnConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionAvailable(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return vpnConnectionAvailableWaiter.run(
                () -> client.describeVpnConnections(applyWaitersUserAgent(describeVpnConnectionsRequest)),
                vpnConnectionAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionDeleted(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        return vpnConnectionDeletedWaiter.run(() -> client
                .describeVpnConnections(applyWaitersUserAgent(describeVpnConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionDeleted(
            DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return vpnConnectionDeletedWaiter.run(
                () -> client.describeVpnConnections(applyWaitersUserAgent(describeVpnConnectionsRequest)),
                vpnConnectionDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceExistsWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Reservations").flatten().length()
                    .compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects
                .equals(errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBundleTasksResponse>> bundleTaskCompleteWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeBundleTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("BundleTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "complete"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("BundleTasks").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (BundleTasks[].State=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskCancelledWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "cancelled"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "cancelled"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (ConversionTasks[].State=cancelled) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "cancelling"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (ConversionTasks[].State=cancelling) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>> customerGatewayAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (CustomerGateways[].State=deleted) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (CustomerGateways[].State=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportTasksResponse>> exportTaskCancelledWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeExportTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ExportTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "cancelled"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportTasksResponse>> exportTaskCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeExportTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ExportTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImagesResponse>> imageExistsWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeImagesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Images").flatten().length().compare(">", input.constant(new BigDecimal("0")))
                    .value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error), "InvalidAMIID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImagesResponse>> imageAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeImagesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Images").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Images").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Images[].State=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceRunningWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                    .field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                            .field("Name").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "shutting-down"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=shutting-down) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                            .field("Name").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "terminated"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=terminated) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                            .field("Name").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=stopping) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects
                .equals(errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> instanceStatusOkWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStatuses").flatten().field("InstanceStatus").field("Status")
                    .values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ok"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects
                .equals(errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceStoppedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                    .field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "stopped"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                            .field("Name").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=pending) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                            .field("Name").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "terminated"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=terminated) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceTerminatedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                    .field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "terminated"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                            .field("Name").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=pending) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State")
                            .field("Name").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=stopping) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInternetGatewaysResponse>> internetGatewayExistsWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeInternetGatewaysResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(
                    input.field("InternetGateways").flatten().field("InternetGatewayId").length()
                            .compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "InvalidInternetGateway.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeKeyPairsResponse>> keyPairExistsWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeKeyPairsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(
                    input.field("KeyPairs").flatten().field("KeyName").length().compare(">", input.constant(new BigDecimal("0")))
                            .value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error), "InvalidKeyPair.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> natGatewayAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=deleted) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error), "NatGatewayNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> natGatewayDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error), "NatGatewayNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>> networkInterfaceAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NetworkInterfaces").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(
                error -> Objects.equals(errorCode(error), "InvalidNetworkInterfaceID.NotFound"),
                "A waiter acceptor was matched on error condition (InvalidNetworkInterfaceID.NotFound) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPasswordDataResponse>> passwordDataAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super GetPasswordDataResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("PasswordData").length().compare(">", input.constant(new BigDecimal("0"))).value(),
                    true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSnapshotsResponse>> snapshotCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeSnapshotsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Snapshots").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "error"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Snapshots[].State=error) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>> snapshotImportedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ImportSnapshotTasks").flatten().field("SnapshotTaskDetail").field("Status")
                    .values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("ImportSnapshotTasks").flatten().field("SnapshotTaskDetail")
                            .field("Status").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "error"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (ImportSnapshotTasks[].SnapshotTaskDetail.Status=error) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSecurityGroupsResponse>> securityGroupExistsWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeSecurityGroupsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(
                    input.field("SecurityGroups").flatten().field("GroupId").length()
                            .compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error), "InvalidGroup.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>> spotInstanceRequestFulfilledWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "fulfilled"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty()
                    && resultValues.stream().allMatch(v -> Objects.equals(v, "request-canceled-and-instance-running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code")
                            .values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "schedule-expired"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=schedule-expired) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code")
                            .values();
                    return !resultValues.isEmpty()
                            && resultValues.stream().anyMatch(v -> Objects.equals(v, "canceled-before-fulfillment"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=canceled-before-fulfillment) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code")
                            .values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "bad-parameters"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=bad-parameters) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code")
                            .values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "system-error"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=system-error) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "InvalidSpotInstanceRequestID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStoreImageTasksResponse>> storeImageTaskCompleteWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeStoreImageTasksResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "Failed"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (StoreImageTaskResults[].StoreTaskState=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "InProgress"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSubnetsResponse>> subnetAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeSubnetsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Subnets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> systemStatusOkWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStatuses").flatten().field("SystemStatus").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ok"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Volumes[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error), "InvalidVolume.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeInUseWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "in-use"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (Volumes[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcsResponse>> vpcAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVpcsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Vpcs").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcsResponse>> vpcExistsWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVpcsResponse>> result = new ArrayList<>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error), "InvalidVpcID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> vpnConnectionAvailableWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> vpnConnectionDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
                    return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
                },
                "A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=pending) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> vpcPeeringConnectionExistsWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> result = new ArrayList<>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "InvalidVpcPeeringConnectionID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> vpcPeeringConnectionDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpcPeeringConnections").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "InvalidVpcPeeringConnectionID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration instanceExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(5)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration bundleTaskCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration customerGatewayAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration exportTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration exportTaskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceStatusOkWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceTerminatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration internetGatewayExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(5)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration keyPairExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(5)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration natGatewayAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration natGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration networkInterfaceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(20)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration passwordDataAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotImportedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration securityGroupExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(5)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration spotInstanceRequestFulfilledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration storeImageTaskCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(5)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration subnetAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration systemStatusOkWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeInUseWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(1)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpnConnectionAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpnConnectionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcPeeringConnectionExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcPeeringConnectionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(15)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    @Override
    public void close() {
        managedResources.close();
    }

    public static Ec2Waiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends Ec2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    public static final class DefaultBuilder implements Ec2Waiter.Builder {
        private Ec2Client client;

        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public Ec2Waiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Ec2Waiter.Builder client(Ec2Client client) {
            this.client = client;
            return this;
        }

        public Ec2Waiter build() {
            return new DefaultEc2Waiter(this);
        }
    }
}
