/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Verified Access instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessInstance.Builder, VerifiedAccessInstance> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessInstanceId")
            .getter(getter(VerifiedAccessInstance::verifiedAccessInstanceId))
            .setter(setter(Builder::verifiedAccessInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId")
                    .unmarshallLocationName("verifiedAccessInstanceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(VerifiedAccessInstance::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<VerifiedAccessTrustProviderCondensed>> VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD = SdkField
            .<List<VerifiedAccessTrustProviderCondensed>> builder(MarshallingType.LIST)
            .memberName("VerifiedAccessTrustProviders")
            .getter(getter(VerifiedAccessInstance::verifiedAccessTrustProviders))
            .setter(setter(Builder::verifiedAccessTrustProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderSet")
                    .unmarshallLocationName("verifiedAccessTrustProviderSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<VerifiedAccessTrustProviderCondensed> builder(MarshallingType.SDK_POJO)
                                            .constructor(VerifiedAccessTrustProviderCondensed::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreationTime")
            .getter(getter(VerifiedAccessInstance::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedTime")
            .getter(getter(VerifiedAccessInstance::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime")
                    .unmarshallLocationName("lastUpdatedTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(VerifiedAccessInstance::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> FIPS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FipsEnabled")
            .getter(getter(VerifiedAccessInstance::fipsEnabled))
            .setter(setter(Builder::fipsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FipsEnabled")
                    .unmarshallLocationName("fipsEnabled").build()).build();

    private static final SdkField<VerifiedAccessInstanceCustomSubDomain> CIDR_ENDPOINTS_CUSTOM_SUB_DOMAIN_FIELD = SdkField
            .<VerifiedAccessInstanceCustomSubDomain> builder(MarshallingType.SDK_POJO)
            .memberName("CidrEndpointsCustomSubDomain")
            .getter(getter(VerifiedAccessInstance::cidrEndpointsCustomSubDomain))
            .setter(setter(Builder::cidrEndpointsCustomSubDomain))
            .constructor(VerifiedAccessInstanceCustomSubDomain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrEndpointsCustomSubDomain")
                    .unmarshallLocationName("cidrEndpointsCustomSubDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_INSTANCE_ID_FIELD, DESCRIPTION_FIELD, VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, TAGS_FIELD, FIPS_ENABLED_FIELD, CIDR_ENDPOINTS_CUSTOM_SUB_DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String verifiedAccessInstanceId;

    private final String description;

    private final List<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders;

    private final String creationTime;

    private final String lastUpdatedTime;

    private final List<Tag> tags;

    private final Boolean fipsEnabled;

    private final VerifiedAccessInstanceCustomSubDomain cidrEndpointsCustomSubDomain;

    private VerifiedAccessInstance(BuilderImpl builder) {
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.description = builder.description;
        this.verifiedAccessTrustProviders = builder.verifiedAccessTrustProviders;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.tags = builder.tags;
        this.fipsEnabled = builder.fipsEnabled;
        this.cidrEndpointsCustomSubDomain = builder.cidrEndpointsCustomSubDomain;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Verified Access instance.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Verified Access instance.
     */
    public final String verifiedAccessInstanceId() {
        return verifiedAccessInstanceId;
    }

    /**
     * <p>
     * A description for the Amazon Web Services Verified Access instance.
     * </p>
     * 
     * @return A description for the Amazon Web Services Verified Access instance.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the VerifiedAccessTrustProviders property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVerifiedAccessTrustProviders() {
        return verifiedAccessTrustProviders != null && !(verifiedAccessTrustProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Amazon Web Services Verified Access trust providers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVerifiedAccessTrustProviders} method.
     * </p>
     * 
     * @return The IDs of the Amazon Web Services Verified Access trust providers.
     */
    public final List<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders() {
        return verifiedAccessTrustProviders;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last updated time.
     * </p>
     * 
     * @return The last updated time.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the instance.
     * </p>
     * 
     * @return Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the instance.
     */
    public final Boolean fipsEnabled() {
        return fipsEnabled;
    }

    /**
     * <p>
     * The custom subdomain.
     * </p>
     * 
     * @return The custom subdomain.
     */
    public final VerifiedAccessInstanceCustomSubDomain cidrEndpointsCustomSubDomain() {
        return cidrEndpointsCustomSubDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasVerifiedAccessTrustProviders() ? verifiedAccessTrustProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fipsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cidrEndpointsCustomSubDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstance)) {
            return false;
        }
        VerifiedAccessInstance other = (VerifiedAccessInstance) obj;
        return Objects.equals(verifiedAccessInstanceId(), other.verifiedAccessInstanceId())
                && Objects.equals(description(), other.description())
                && hasVerifiedAccessTrustProviders() == other.hasVerifiedAccessTrustProviders()
                && Objects.equals(verifiedAccessTrustProviders(), other.verifiedAccessTrustProviders())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(fipsEnabled(), other.fipsEnabled())
                && Objects.equals(cidrEndpointsCustomSubDomain(), other.cidrEndpointsCustomSubDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessInstance").add("VerifiedAccessInstanceId", verifiedAccessInstanceId())
                .add("Description", description())
                .add("VerifiedAccessTrustProviders", hasVerifiedAccessTrustProviders() ? verifiedAccessTrustProviders() : null)
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("Tags", hasTags() ? tags() : null).add("FipsEnabled", fipsEnabled())
                .add("CidrEndpointsCustomSubDomain", cidrEndpointsCustomSubDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessInstanceId":
            return Optional.ofNullable(clazz.cast(verifiedAccessInstanceId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VerifiedAccessTrustProviders":
            return Optional.ofNullable(clazz.cast(verifiedAccessTrustProviders()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FipsEnabled":
            return Optional.ofNullable(clazz.cast(fipsEnabled()));
        case "CidrEndpointsCustomSubDomain":
            return Optional.ofNullable(clazz.cast(cidrEndpointsCustomSubDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerifiedAccessInstanceId", VERIFIED_ACCESS_INSTANCE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VerifiedAccessTrustProviderSet", VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("FipsEnabled", FIPS_ENABLED_FIELD);
        map.put("CidrEndpointsCustomSubDomain", CIDR_ENDPOINTS_CUSTOM_SUB_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstance, T> g) {
        return obj -> g.apply((VerifiedAccessInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessInstance> {
        /**
         * <p>
         * The ID of the Amazon Web Services Verified Access instance.
         * </p>
         * 
         * @param verifiedAccessInstanceId
         *        The ID of the Amazon Web Services Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessInstanceId(String verifiedAccessInstanceId);

        /**
         * <p>
         * A description for the Amazon Web Services Verified Access instance.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Web Services Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IDs of the Amazon Web Services Verified Access trust providers.
         * </p>
         * 
         * @param verifiedAccessTrustProviders
         *        The IDs of the Amazon Web Services Verified Access trust providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProviders(Collection<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders);

        /**
         * <p>
         * The IDs of the Amazon Web Services Verified Access trust providers.
         * </p>
         * 
         * @param verifiedAccessTrustProviders
         *        The IDs of the Amazon Web Services Verified Access trust providers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProviders(VerifiedAccessTrustProviderCondensed... verifiedAccessTrustProviders);

        /**
         * <p>
         * The IDs of the Amazon Web Services Verified Access trust providers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #verifiedAccessTrustProviders(List<VerifiedAccessTrustProviderCondensed>)}.
         * 
         * @param verifiedAccessTrustProviders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderCondensed.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedAccessTrustProviders(java.util.Collection<VerifiedAccessTrustProviderCondensed>)
         */
        Builder verifiedAccessTrustProviders(
                Consumer<VerifiedAccessTrustProviderCondensed.Builder>... verifiedAccessTrustProviders);

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The last updated time.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last updated time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the instance.
         * </p>
         * 
         * @param fipsEnabled
         *        Indicates whether support for Federal Information Processing Standards (FIPS) is enabled on the
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fipsEnabled(Boolean fipsEnabled);

        /**
         * <p>
         * The custom subdomain.
         * </p>
         * 
         * @param cidrEndpointsCustomSubDomain
         *        The custom subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrEndpointsCustomSubDomain(VerifiedAccessInstanceCustomSubDomain cidrEndpointsCustomSubDomain);

        /**
         * <p>
         * The custom subdomain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessInstanceCustomSubDomain.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessInstanceCustomSubDomain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessInstanceCustomSubDomain.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cidrEndpointsCustomSubDomain(VerifiedAccessInstanceCustomSubDomain)}.
         * 
         * @param cidrEndpointsCustomSubDomain
         *        a consumer that will call methods on {@link VerifiedAccessInstanceCustomSubDomain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrEndpointsCustomSubDomain(VerifiedAccessInstanceCustomSubDomain)
         */
        default Builder cidrEndpointsCustomSubDomain(
                Consumer<VerifiedAccessInstanceCustomSubDomain.Builder> cidrEndpointsCustomSubDomain) {
            return cidrEndpointsCustomSubDomain(VerifiedAccessInstanceCustomSubDomain.builder()
                    .applyMutation(cidrEndpointsCustomSubDomain).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String verifiedAccessInstanceId;

        private String description;

        private List<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders = DefaultSdkAutoConstructList
                .getInstance();

        private String creationTime;

        private String lastUpdatedTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean fipsEnabled;

        private VerifiedAccessInstanceCustomSubDomain cidrEndpointsCustomSubDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstance model) {
            verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            description(model.description);
            verifiedAccessTrustProviders(model.verifiedAccessTrustProviders);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            tags(model.tags);
            fipsEnabled(model.fipsEnabled);
            cidrEndpointsCustomSubDomain(model.cidrEndpointsCustomSubDomain);
        }

        public final String getVerifiedAccessInstanceId() {
            return verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<VerifiedAccessTrustProviderCondensed.Builder> getVerifiedAccessTrustProviders() {
            List<VerifiedAccessTrustProviderCondensed.Builder> result = VerifiedAccessTrustProviderCondensedListCopier
                    .copyToBuilder(this.verifiedAccessTrustProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedAccessTrustProviders(
                Collection<VerifiedAccessTrustProviderCondensed.BuilderImpl> verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = VerifiedAccessTrustProviderCondensedListCopier
                    .copyFromBuilder(verifiedAccessTrustProviders);
        }

        @Override
        public final Builder verifiedAccessTrustProviders(
                Collection<VerifiedAccessTrustProviderCondensed> verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = VerifiedAccessTrustProviderCondensedListCopier.copy(verifiedAccessTrustProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessTrustProviders(VerifiedAccessTrustProviderCondensed... verifiedAccessTrustProviders) {
            verifiedAccessTrustProviders(Arrays.asList(verifiedAccessTrustProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessTrustProviders(
                Consumer<VerifiedAccessTrustProviderCondensed.Builder>... verifiedAccessTrustProviders) {
            verifiedAccessTrustProviders(Stream.of(verifiedAccessTrustProviders)
                    .map(c -> VerifiedAccessTrustProviderCondensed.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getFipsEnabled() {
            return fipsEnabled;
        }

        public final void setFipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
        }

        @Override
        public final Builder fipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        public final VerifiedAccessInstanceCustomSubDomain.Builder getCidrEndpointsCustomSubDomain() {
            return cidrEndpointsCustomSubDomain != null ? cidrEndpointsCustomSubDomain.toBuilder() : null;
        }

        public final void setCidrEndpointsCustomSubDomain(
                VerifiedAccessInstanceCustomSubDomain.BuilderImpl cidrEndpointsCustomSubDomain) {
            this.cidrEndpointsCustomSubDomain = cidrEndpointsCustomSubDomain != null ? cidrEndpointsCustomSubDomain.build()
                    : null;
        }

        @Override
        public final Builder cidrEndpointsCustomSubDomain(VerifiedAccessInstanceCustomSubDomain cidrEndpointsCustomSubDomain) {
            this.cidrEndpointsCustomSubDomain = cidrEndpointsCustomSubDomain;
            return this;
        }

        @Override
        public VerifiedAccessInstance build() {
            return new VerifiedAccessInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
