/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyRouteServerResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyRouteServerResponse.Builder, ModifyRouteServerResponse> {
    private static final SdkField<RouteServer> ROUTE_SERVER_FIELD = SdkField
            .<RouteServer> builder(MarshallingType.SDK_POJO)
            .memberName("RouteServer")
            .getter(getter(ModifyRouteServerResponse::routeServer))
            .setter(setter(Builder::routeServer))
            .constructor(RouteServer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServer")
                    .unmarshallLocationName("routeServer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouteServer routeServer;

    private ModifyRouteServerResponse(BuilderImpl builder) {
        super(builder);
        this.routeServer = builder.routeServer;
    }

    /**
     * <p>
     * Information about the modified route server.
     * </p>
     * 
     * @return Information about the modified route server.
     */
    public final RouteServer routeServer() {
        return routeServer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeServer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRouteServerResponse)) {
            return false;
        }
        ModifyRouteServerResponse other = (ModifyRouteServerResponse) obj;
        return Objects.equals(routeServer(), other.routeServer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyRouteServerResponse").add("RouteServer", routeServer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServer":
            return Optional.ofNullable(clazz.cast(routeServer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServer", ROUTE_SERVER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyRouteServerResponse, T> g) {
        return obj -> g.apply((ModifyRouteServerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyRouteServerResponse> {
        /**
         * <p>
         * Information about the modified route server.
         * </p>
         * 
         * @param routeServer
         *        Information about the modified route server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServer(RouteServer routeServer);

        /**
         * <p>
         * Information about the modified route server.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteServer.Builder} avoiding the need to
         * create one manually via {@link RouteServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteServer.Builder#build()} is called immediately and its result
         * is passed to {@link #routeServer(RouteServer)}.
         * 
         * @param routeServer
         *        a consumer that will call methods on {@link RouteServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServer(RouteServer)
         */
        default Builder routeServer(Consumer<RouteServer.Builder> routeServer) {
            return routeServer(RouteServer.builder().applyMutation(routeServer).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private RouteServer routeServer;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRouteServerResponse model) {
            super(model);
            routeServer(model.routeServer);
        }

        public final RouteServer.Builder getRouteServer() {
            return routeServer != null ? routeServer.toBuilder() : null;
        }

        public final void setRouteServer(RouteServer.BuilderImpl routeServer) {
            this.routeServer = routeServer != null ? routeServer.build() : null;
        }

        @Override
        public final Builder routeServer(RouteServer routeServer) {
            this.routeServer = routeServer;
            return this;
        }

        @Override
        public ModifyRouteServerResponse build() {
            return new ModifyRouteServerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
