/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceMetadataOptionsResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyInstanceMetadataOptionsResponse.Builder, ModifyInstanceMetadataOptionsResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstanceMetadataOptionsResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<InstanceMetadataOptionsResponse> INSTANCE_METADATA_OPTIONS_FIELD = SdkField
            .<InstanceMetadataOptionsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMetadataOptions")
            .getter(getter(ModifyInstanceMetadataOptionsResponse::instanceMetadataOptions))
            .setter(setter(Builder::instanceMetadataOptions))
            .constructor(InstanceMetadataOptionsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataOptions")
                    .unmarshallLocationName("instanceMetadataOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INSTANCE_METADATA_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final InstanceMetadataOptionsResponse instanceMetadataOptions;

    private ModifyInstanceMetadataOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.instanceMetadataOptions = builder.instanceMetadataOptions;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The metadata options for the instance.
     * </p>
     * 
     * @return The metadata options for the instance.
     */
    public final InstanceMetadataOptionsResponse instanceMetadataOptions() {
        return instanceMetadataOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMetadataOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceMetadataOptionsResponse)) {
            return false;
        }
        ModifyInstanceMetadataOptionsResponse other = (ModifyInstanceMetadataOptionsResponse) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceMetadataOptions(), other.instanceMetadataOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceMetadataOptionsResponse").add("InstanceId", instanceId())
                .add("InstanceMetadataOptions", instanceMetadataOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceMetadataOptions":
            return Optional.ofNullable(clazz.cast(instanceMetadataOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceMetadataOptions", INSTANCE_METADATA_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceMetadataOptionsResponse, T> g) {
        return obj -> g.apply((ModifyInstanceMetadataOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyInstanceMetadataOptionsResponse> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The metadata options for the instance.
         * </p>
         * 
         * @param instanceMetadataOptions
         *        The metadata options for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMetadataOptions(InstanceMetadataOptionsResponse instanceMetadataOptions);

        /**
         * <p>
         * The metadata options for the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMetadataOptionsResponse.Builder}
         * avoiding the need to create one manually via {@link InstanceMetadataOptionsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataOptionsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceMetadataOptions(InstanceMetadataOptionsResponse)}.
         * 
         * @param instanceMetadataOptions
         *        a consumer that will call methods on {@link InstanceMetadataOptionsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMetadataOptions(InstanceMetadataOptionsResponse)
         */
        default Builder instanceMetadataOptions(Consumer<InstanceMetadataOptionsResponse.Builder> instanceMetadataOptions) {
            return instanceMetadataOptions(InstanceMetadataOptionsResponse.builder().applyMutation(instanceMetadataOptions)
                    .build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String instanceId;

        private InstanceMetadataOptionsResponse instanceMetadataOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceMetadataOptionsResponse model) {
            super(model);
            instanceId(model.instanceId);
            instanceMetadataOptions(model.instanceMetadataOptions);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final InstanceMetadataOptionsResponse.Builder getInstanceMetadataOptions() {
            return instanceMetadataOptions != null ? instanceMetadataOptions.toBuilder() : null;
        }

        public final void setInstanceMetadataOptions(InstanceMetadataOptionsResponse.BuilderImpl instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions != null ? instanceMetadataOptions.build() : null;
        }

        @Override
        public final Builder instanceMetadataOptions(InstanceMetadataOptionsResponse instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions;
            return this;
        }

        @Override
        public ModifyInstanceMetadataOptionsResponse build() {
            return new ModifyInstanceMetadataOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
