/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import image task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportImageTask implements SdkPojo, Serializable, ToCopyableBuilder<ImportImageTask.Builder, ImportImageTask> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Architecture")
            .getter(getter(ImportImageTask::architecture))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture")
                    .unmarshallLocationName("architecture").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ImportImageTask::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted")
            .getter(getter(ImportImageTask::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> HYPERVISOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Hypervisor")
            .getter(getter(ImportImageTask::hypervisor))
            .setter(setter(Builder::hypervisor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor")
                    .unmarshallLocationName("hypervisor").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ImportImageTask::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImportTaskId")
            .getter(getter(ImportImageTask::importTaskId))
            .setter(setter(Builder::importTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId")
                    .unmarshallLocationName("importTaskId").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId")
            .getter(getter(ImportImageTask::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("kmsKeyId").build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LicenseType")
            .getter(getter(ImportImageTask::licenseType))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType")
                    .unmarshallLocationName("licenseType").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Platform")
            .getter(getter(ImportImageTask::platform))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Progress")
            .getter(getter(ImportImageTask::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<List<SnapshotDetail>> SNAPSHOT_DETAILS_FIELD = SdkField
            .<List<SnapshotDetail>> builder(MarshallingType.LIST)
            .memberName("SnapshotDetails")
            .getter(getter(ImportImageTask::snapshotDetails))
            .setter(setter(Builder::snapshotDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotDetailSet")
                    .unmarshallLocationName("snapshotDetailSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SnapshotDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ImportImageTask::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(ImportImageTask::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportImageTask::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ImportImageLicenseConfigurationResponse>> LICENSE_SPECIFICATIONS_FIELD = SdkField
            .<List<ImportImageLicenseConfigurationResponse>> builder(MarshallingType.LIST)
            .memberName("LicenseSpecifications")
            .getter(getter(ImportImageTask::licenseSpecifications))
            .setter(setter(Builder::licenseSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecifications")
                    .unmarshallLocationName("licenseSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImportImageLicenseConfigurationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportImageLicenseConfigurationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UsageOperation")
            .getter(getter(ImportImageTask::usageOperation))
            .setter(setter(Builder::usageOperation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation")
                    .unmarshallLocationName("usageOperation").build()).build();

    private static final SdkField<String> BOOT_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BootMode")
            .getter(getter(ImportImageTask::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootMode")
                    .unmarshallLocationName("bootMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD,
            DESCRIPTION_FIELD, ENCRYPTED_FIELD, HYPERVISOR_FIELD, IMAGE_ID_FIELD, IMPORT_TASK_ID_FIELD, KMS_KEY_ID_FIELD,
            LICENSE_TYPE_FIELD, PLATFORM_FIELD, PROGRESS_FIELD, SNAPSHOT_DETAILS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD,
            TAGS_FIELD, LICENSE_SPECIFICATIONS_FIELD, USAGE_OPERATION_FIELD, BOOT_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String architecture;

    private final String description;

    private final Boolean encrypted;

    private final String hypervisor;

    private final String imageId;

    private final String importTaskId;

    private final String kmsKeyId;

    private final String licenseType;

    private final String platform;

    private final String progress;

    private final List<SnapshotDetail> snapshotDetails;

    private final String status;

    private final String statusMessage;

    private final List<Tag> tags;

    private final List<ImportImageLicenseConfigurationResponse> licenseSpecifications;

    private final String usageOperation;

    private final String bootMode;

    private ImportImageTask(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.hypervisor = builder.hypervisor;
        this.imageId = builder.imageId;
        this.importTaskId = builder.importTaskId;
        this.kmsKeyId = builder.kmsKeyId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.progress = builder.progress;
        this.snapshotDetails = builder.snapshotDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.usageOperation = builder.usageOperation;
        this.bootMode = builder.bootMode;
    }

    /**
     * <p>
     * The architecture of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>i386</code> | <code>x86_64</code> | <code>arm64</code>
     * </p>
     * 
     * @return The architecture of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>i386</code> | <code>x86_64</code> | <code>arm64</code>
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * A description of the import task.
     * </p>
     * 
     * @return A description of the import task.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the image is encrypted.
     * </p>
     * 
     * @return Indicates whether the image is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The target hypervisor for the import task.
     * </p>
     * <p>
     * Valid values: <code>xen</code>
     * </p>
     * 
     * @return The target hypervisor for the import task.</p>
     *         <p>
     *         Valid values: <code>xen</code>
     */
    public final String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the import image task.
     * </p>
     * 
     * @return The ID of the import image task.
     */
    public final String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * The identifier for the KMS key that was used to create the encrypted image.
     * </p>
     * 
     * @return The identifier for the KMS key that was used to create the encrypted image.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The license type of the virtual machine.
     * </p>
     * 
     * @return The license type of the virtual machine.
     */
    public final String licenseType() {
        return licenseType;
    }

    /**
     * <p>
     * The description string for the import image task.
     * </p>
     * 
     * @return The description string for the import image task.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The percentage of progress of the import image task.
     * </p>
     * 
     * @return The percentage of progress of the import image task.
     */
    public final String progress() {
        return progress;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotDetails() {
        return snapshotDetails != null && !(snapshotDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotDetails} method.
     * </p>
     * 
     * @return Information about the snapshots.
     */
    public final List<SnapshotDetail> snapshotDetails() {
        return snapshotDetails;
    }

    /**
     * <p>
     * A brief status for the import image task.
     * </p>
     * 
     * @return A brief status for the import image task.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A descriptive status message for the import image task.
     * </p>
     * 
     * @return A descriptive status message for the import image task.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the import image task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the import image task.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseSpecifications() {
        return licenseSpecifications != null && !(licenseSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the license configurations that are associated with the import image task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseSpecifications} method.
     * </p>
     * 
     * @return The ARNs of the license configurations that are associated with the import image task.
     */
    public final List<ImportImageLicenseConfigurationResponse> licenseSpecifications() {
        return licenseSpecifications;
    }

    /**
     * <p>
     * The usage operation value.
     * </p>
     * 
     * @return The usage operation value.
     */
    public final String usageOperation() {
        return usageOperation;
    }

    /**
     * <p>
     * The boot mode of the virtual machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the virtual machine.
     * @see BootModeValues
     */
    public final BootModeValues bootMode() {
        return BootModeValues.fromValue(bootMode);
    }

    /**
     * <p>
     * The boot mode of the virtual machine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootModeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return The boot mode of the virtual machine.
     * @see BootModeValues
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotDetails() ? snapshotDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSpecifications() ? licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageTask)) {
            return false;
        }
        ImportImageTask other = (ImportImageTask) obj;
        return Objects.equals(architecture(), other.architecture()) && Objects.equals(description(), other.description())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(hypervisor(), other.hypervisor())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(importTaskId(), other.importTaskId())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(licenseType(), other.licenseType())
                && Objects.equals(platform(), other.platform()) && Objects.equals(progress(), other.progress())
                && hasSnapshotDetails() == other.hasSnapshotDetails()
                && Objects.equals(snapshotDetails(), other.snapshotDetails()) && Objects.equals(status(), other.status())
                && Objects.equals(statusMessage(), other.statusMessage()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasLicenseSpecifications() == other.hasLicenseSpecifications()
                && Objects.equals(licenseSpecifications(), other.licenseSpecifications())
                && Objects.equals(usageOperation(), other.usageOperation())
                && Objects.equals(bootModeAsString(), other.bootModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportImageTask").add("Architecture", architecture()).add("Description", description())
                .add("Encrypted", encrypted()).add("Hypervisor", hypervisor()).add("ImageId", imageId())
                .add("ImportTaskId", importTaskId()).add("KmsKeyId", kmsKeyId()).add("LicenseType", licenseType())
                .add("Platform", platform()).add("Progress", progress())
                .add("SnapshotDetails", hasSnapshotDetails() ? snapshotDetails() : null).add("Status", status())
                .add("StatusMessage", statusMessage()).add("Tags", hasTags() ? tags() : null)
                .add("LicenseSpecifications", hasLicenseSpecifications() ? licenseSpecifications() : null)
                .add("UsageOperation", usageOperation()).add("BootMode", bootModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisor()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImportTaskId":
            return Optional.ofNullable(clazz.cast(importTaskId()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "LicenseType":
            return Optional.ofNullable(clazz.cast(licenseType()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "SnapshotDetails":
            return Optional.ofNullable(clazz.cast(snapshotDetails()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LicenseSpecifications":
            return Optional.ofNullable(clazz.cast(licenseSpecifications()));
        case "UsageOperation":
            return Optional.ofNullable(clazz.cast(usageOperation()));
        case "BootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Architecture", ARCHITECTURE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("Hypervisor", HYPERVISOR_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ImportTaskId", IMPORT_TASK_ID_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("LicenseType", LICENSE_TYPE_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        map.put("SnapshotDetailSet", SNAPSHOT_DETAILS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("LicenseSpecifications", LICENSE_SPECIFICATIONS_FIELD);
        map.put("UsageOperation", USAGE_OPERATION_FIELD);
        map.put("BootMode", BOOT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportImageTask, T> g) {
        return obj -> g.apply((ImportImageTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportImageTask> {
        /**
         * <p>
         * The architecture of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>i386</code> | <code>x86_64</code> | <code>arm64</code>
         * </p>
         * 
         * @param architecture
         *        The architecture of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>i386</code> | <code>x86_64</code> | <code>arm64</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * A description of the import task.
         * </p>
         * 
         * @param description
         *        A description of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the image is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the image is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The target hypervisor for the import task.
         * </p>
         * <p>
         * Valid values: <code>xen</code>
         * </p>
         * 
         * @param hypervisor
         *        The target hypervisor for the import task.</p>
         *        <p>
         *        Valid values: <code>xen</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI) of the imported virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the import image task.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * The identifier for the KMS key that was used to create the encrypted image.
         * </p>
         * 
         * @param kmsKeyId
         *        The identifier for the KMS key that was used to create the encrypted image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The license type of the virtual machine.
         * </p>
         * 
         * @param licenseType
         *        The license type of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The description string for the import image task.
         * </p>
         * 
         * @param platform
         *        The description string for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The percentage of progress of the import image task.
         * </p>
         * 
         * @param progress
         *        The percentage of progress of the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshotDetails
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshotDetails
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotDetails(SnapshotDetail... snapshotDetails);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SnapshotDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.SnapshotDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SnapshotDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #snapshotDetails(List<SnapshotDetail>)}.
         * 
         * @param snapshotDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SnapshotDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotDetails(java.util.Collection<SnapshotDetail>)
         */
        Builder snapshotDetails(Consumer<SnapshotDetail.Builder>... snapshotDetails);

        /**
         * <p>
         * A brief status for the import image task.
         * </p>
         * 
         * @param status
         *        A brief status for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A descriptive status message for the import image task.
         * </p>
         * 
         * @param statusMessage
         *        A descriptive status message for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The tags for the import image task.
         * </p>
         * 
         * @param tags
         *        The tags for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the import image task.
         * </p>
         * 
         * @param tags
         *        The tags for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the import image task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ARNs of the license configurations that are associated with the import image task.
         * </p>
         * 
         * @param licenseSpecifications
         *        The ARNs of the license configurations that are associated with the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(Collection<ImportImageLicenseConfigurationResponse> licenseSpecifications);

        /**
         * <p>
         * The ARNs of the license configurations that are associated with the import image task.
         * </p>
         * 
         * @param licenseSpecifications
         *        The ARNs of the license configurations that are associated with the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSpecifications(ImportImageLicenseConfigurationResponse... licenseSpecifications);

        /**
         * <p>
         * The ARNs of the license configurations that are associated with the import image task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #licenseSpecifications(List<ImportImageLicenseConfigurationResponse>)}.
         * 
         * @param licenseSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImportImageLicenseConfigurationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSpecifications(java.util.Collection<ImportImageLicenseConfigurationResponse>)
         */
        Builder licenseSpecifications(Consumer<ImportImageLicenseConfigurationResponse.Builder>... licenseSpecifications);

        /**
         * <p>
         * The usage operation value.
         * </p>
         * 
         * @param usageOperation
         *        The usage operation value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageOperation(String usageOperation);

        /**
         * <p>
         * The boot mode of the virtual machine.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the virtual machine.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * The boot mode of the virtual machine.
         * </p>
         * 
         * @param bootMode
         *        The boot mode of the virtual machine.
         * @see BootModeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootModeValues
         */
        Builder bootMode(BootModeValues bootMode);
    }

    static final class BuilderImpl implements Builder {
        private String architecture;

        private String description;

        private Boolean encrypted;

        private String hypervisor;

        private String imageId;

        private String importTaskId;

        private String kmsKeyId;

        private String licenseType;

        private String platform;

        private String progress;

        private List<SnapshotDetail> snapshotDetails = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusMessage;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<ImportImageLicenseConfigurationResponse> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String usageOperation;

        private String bootMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageTask model) {
            architecture(model.architecture);
            description(model.description);
            encrypted(model.encrypted);
            hypervisor(model.hypervisor);
            imageId(model.imageId);
            importTaskId(model.importTaskId);
            kmsKeyId(model.kmsKeyId);
            licenseType(model.licenseType);
            platform(model.platform);
            progress(model.progress);
            snapshotDetails(model.snapshotDetails);
            status(model.status);
            statusMessage(model.statusMessage);
            tags(model.tags);
            licenseSpecifications(model.licenseSpecifications);
            usageOperation(model.usageOperation);
            bootMode(model.bootMode);
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getProgress() {
            return progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final List<SnapshotDetail.Builder> getSnapshotDetails() {
            List<SnapshotDetail.Builder> result = SnapshotDetailListCopier.copyToBuilder(this.snapshotDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotDetails(Collection<SnapshotDetail.BuilderImpl> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copyFromBuilder(snapshotDetails);
        }

        @Override
        public final Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copy(snapshotDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(SnapshotDetail... snapshotDetails) {
            snapshotDetails(Arrays.asList(snapshotDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(Consumer<SnapshotDetail.Builder>... snapshotDetails) {
            snapshotDetails(Stream.of(snapshotDetails).map(c -> SnapshotDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ImportImageLicenseConfigurationResponse.Builder> getLicenseSpecifications() {
            List<ImportImageLicenseConfigurationResponse.Builder> result = ImportImageLicenseSpecificationListResponseCopier
                    .copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(
                Collection<ImportImageLicenseConfigurationResponse.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = ImportImageLicenseSpecificationListResponseCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<ImportImageLicenseConfigurationResponse> licenseSpecifications) {
            this.licenseSpecifications = ImportImageLicenseSpecificationListResponseCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(ImportImageLicenseConfigurationResponse... licenseSpecifications) {
            licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(
                Consumer<ImportImageLicenseConfigurationResponse.Builder>... licenseSpecifications) {
            licenseSpecifications(Stream.of(licenseSpecifications)
                    .map(c -> ImportImageLicenseConfigurationResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUsageOperation() {
            return usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootModeValues bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        @Override
        public ImportImageTask build() {
            return new ImportImageTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
