/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMacSystemIntegrityProtectionModificationTaskRequest extends Ec2Request
        implements
        ToCopyableBuilder<CreateMacSystemIntegrityProtectionModificationTaskRequest.Builder, CreateMacSystemIntegrityProtectionModificationTaskRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> MAC_CREDENTIALS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MacCredentials")
            .getter(getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::macCredentials))
            .setter(setter(Builder::macCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacCredentials")
                    .unmarshallLocationName("MacCredentials").build()).build();

    private static final SdkField<MacSystemIntegrityProtectionConfigurationRequest> MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIGURATION_FIELD = SdkField
            .<MacSystemIntegrityProtectionConfigurationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("MacSystemIntegrityProtectionConfiguration")
            .getter(getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::macSystemIntegrityProtectionConfiguration))
            .setter(setter(Builder::macSystemIntegrityProtectionConfiguration))
            .constructor(MacSystemIntegrityProtectionConfigurationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MacSystemIntegrityProtectionConfiguration")
                    .unmarshallLocationName("MacSystemIntegrityProtectionConfiguration").build()).build();

    private static final SdkField<String> MAC_SYSTEM_INTEGRITY_PROTECTION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MacSystemIntegrityProtectionStatus")
            .getter(getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::macSystemIntegrityProtectionStatusAsString))
            .setter(setter(Builder::macSystemIntegrityProtectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacSystemIntegrityProtectionStatus")
                    .unmarshallLocationName("MacSystemIntegrityProtectionStatus").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DRY_RUN_FIELD, INSTANCE_ID_FIELD, MAC_CREDENTIALS_FIELD, MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIGURATION_FIELD,
            MAC_SYSTEM_INTEGRITY_PROTECTION_STATUS_FIELD, TAG_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final Boolean dryRun;

    private final String instanceId;

    private final String macCredentials;

    private final MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration;

    private final String macSystemIntegrityProtectionStatus;

    private final List<TagSpecification> tagSpecifications;

    private CreateMacSystemIntegrityProtectionModificationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.instanceId = builder.instanceId;
        this.macCredentials = builder.macCredentials;
        this.macSystemIntegrityProtectionConfiguration = builder.macSystemIntegrityProtectionConfiguration;
        this.macSystemIntegrityProtectionStatus = builder.macSystemIntegrityProtectionStatus;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the Amazon EC2 Mac instance.
     * </p>
     * 
     * @return The ID of the Amazon EC2 Mac instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * <b>[Apple silicon Mac instances only]</b> Specifies the following credentials:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Internal disk administrative user</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Username</b> - Only the default administrative user (<code>aws-managed-user</code>) is supported and it is
     * used by default. You can't specify a different administrative user.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Password</b> - If you did not change the default password for <code>aws-managed-user</code>, specify the
     * default password, which is <i>blank</i>. Otherwise, specify your password.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Amazon EBS root volume administrative user</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Username</b> - If you did not change the default administrative user, specify <code>ec2-user</code>.
     * Otherwise, specify the username for your administrative user.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Password</b> - Specify the password for the administrative user.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * The credentials must be specified in the following JSON format:
     * </p>
     * <p>
     * <code>{ "internalDiskPassword":"<i>internal-disk-admin_password</i>", "rootVolumeUsername":"<i>root-volume-admin_username</i>", "rootVolumepassword":"<i>root-volume-admin_password</i>" }</code>
     * </p>
     * 
     * @return <b>[Apple silicon Mac instances only]</b> Specifies the following credentials:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Internal disk administrative user</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Username</b> - Only the default administrative user (<code>aws-managed-user</code>) is supported and
     *         it is used by default. You can't specify a different administrative user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Password</b> - If you did not change the default password for <code>aws-managed-user</code>, specify
     *         the default password, which is <i>blank</i>. Otherwise, specify your password.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon EBS root volume administrative user</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Username</b> - If you did not change the default administrative user, specify <code>ec2-user</code>.
     *         Otherwise, specify the username for your administrative user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Password</b> - Specify the password for the administrative user.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         The credentials must be specified in the following JSON format:
     *         </p>
     *         <p>
     *         <code>{ "internalDiskPassword":"<i>internal-disk-admin_password</i>", "rootVolumeUsername":"<i>root-volume-admin_username</i>", "rootVolumepassword":"<i>root-volume-admin_password</i>" }</code>
     */
    public final String macCredentials() {
        return macCredentials;
    }

    /**
     * <p>
     * Specifies the overrides to selectively enable or disable individual SIP settings. The individual settings you
     * specify here override the overall SIP status you specify for <b>MacSystemIntegrityProtectionStatus</b>.
     * </p>
     * 
     * @return Specifies the overrides to selectively enable or disable individual SIP settings. The individual settings
     *         you specify here override the overall SIP status you specify for
     *         <b>MacSystemIntegrityProtectionStatus</b>.
     */
    public final MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration() {
        return macSystemIntegrityProtectionConfiguration;
    }

    /**
     * <p>
     * Specifies the overall SIP status for the instance. To enable all SIP settings, specify <code>enabled</code>. To
     * disable all SIP settings, specify <code>disabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #macSystemIntegrityProtectionStatus} will return
     * {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #macSystemIntegrityProtectionStatusAsString}.
     * </p>
     * 
     * @return Specifies the overall SIP status for the instance. To enable all SIP settings, specify
     *         <code>enabled</code>. To disable all SIP settings, specify <code>disabled</code>.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final MacSystemIntegrityProtectionSettingStatus macSystemIntegrityProtectionStatus() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(macSystemIntegrityProtectionStatus);
    }

    /**
     * <p>
     * Specifies the overall SIP status for the instance. To enable all SIP settings, specify <code>enabled</code>. To
     * disable all SIP settings, specify <code>disabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #macSystemIntegrityProtectionStatus} will return
     * {@link MacSystemIntegrityProtectionSettingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #macSystemIntegrityProtectionStatusAsString}.
     * </p>
     * 
     * @return Specifies the overall SIP status for the instance. To enable all SIP settings, specify
     *         <code>enabled</code>. To disable all SIP settings, specify <code>disabled</code>.
     * @see MacSystemIntegrityProtectionSettingStatus
     */
    public final String macSystemIntegrityProtectionStatusAsString() {
        return macSystemIntegrityProtectionStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies tags to apply to the SIP modification task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return Specifies tags to apply to the SIP modification task.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(macCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(macSystemIntegrityProtectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(macSystemIntegrityProtectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMacSystemIntegrityProtectionModificationTaskRequest)) {
            return false;
        }
        CreateMacSystemIntegrityProtectionModificationTaskRequest other = (CreateMacSystemIntegrityProtectionModificationTaskRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(macCredentials(), other.macCredentials())
                && Objects.equals(macSystemIntegrityProtectionConfiguration(), other.macSystemIntegrityProtectionConfiguration())
                && Objects.equals(macSystemIntegrityProtectionStatusAsString(),
                        other.macSystemIntegrityProtectionStatusAsString())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMacSystemIntegrityProtectionModificationTaskRequest").add("ClientToken", clientToken())
                .add("DryRun", dryRun()).add("InstanceId", instanceId())
                .add("MacCredentials", macCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MacSystemIntegrityProtectionConfiguration", macSystemIntegrityProtectionConfiguration())
                .add("MacSystemIntegrityProtectionStatus", macSystemIntegrityProtectionStatusAsString())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "MacCredentials":
            return Optional.ofNullable(clazz.cast(macCredentials()));
        case "MacSystemIntegrityProtectionConfiguration":
            return Optional.ofNullable(clazz.cast(macSystemIntegrityProtectionConfiguration()));
        case "MacSystemIntegrityProtectionStatus":
            return Optional.ofNullable(clazz.cast(macSystemIntegrityProtectionStatusAsString()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("MacCredentials", MAC_CREDENTIALS_FIELD);
        map.put("MacSystemIntegrityProtectionConfiguration", MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIGURATION_FIELD);
        map.put("MacSystemIntegrityProtectionStatus", MAC_SYSTEM_INTEGRITY_PROTECTION_STATUS_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMacSystemIntegrityProtectionModificationTaskRequest, T> g) {
        return obj -> g.apply((CreateMacSystemIntegrityProtectionModificationTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMacSystemIntegrityProtectionModificationTaskRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the Amazon EC2 Mac instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the Amazon EC2 Mac instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * <b>[Apple silicon Mac instances only]</b> Specifies the following credentials:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Internal disk administrative user</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Username</b> - Only the default administrative user (<code>aws-managed-user</code>) is supported and it is
         * used by default. You can't specify a different administrative user.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Password</b> - If you did not change the default password for <code>aws-managed-user</code>, specify the
         * default password, which is <i>blank</i>. Otherwise, specify your password.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Amazon EBS root volume administrative user</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Username</b> - If you did not change the default administrative user, specify <code>ec2-user</code>.
         * Otherwise, specify the username for your administrative user.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Password</b> - Specify the password for the administrative user.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * The credentials must be specified in the following JSON format:
         * </p>
         * <p>
         * <code>{ "internalDiskPassword":"<i>internal-disk-admin_password</i>", "rootVolumeUsername":"<i>root-volume-admin_username</i>", "rootVolumepassword":"<i>root-volume-admin_password</i>" }</code>
         * </p>
         * 
         * @param macCredentials
         *        <b>[Apple silicon Mac instances only]</b> Specifies the following credentials:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Internal disk administrative user</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Username</b> - Only the default administrative user (<code>aws-managed-user</code>) is supported
         *        and it is used by default. You can't specify a different administrative user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Password</b> - If you did not change the default password for <code>aws-managed-user</code>,
         *        specify the default password, which is <i>blank</i>. Otherwise, specify your password.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon EBS root volume administrative user</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Username</b> - If you did not change the default administrative user, specify <code>ec2-user</code>
         *        . Otherwise, specify the username for your administrative user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Password</b> - Specify the password for the administrative user.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        The credentials must be specified in the following JSON format:
         *        </p>
         *        <p>
         *        <code>{ "internalDiskPassword":"<i>internal-disk-admin_password</i>", "rootVolumeUsername":"<i>root-volume-admin_username</i>", "rootVolumepassword":"<i>root-volume-admin_password</i>" }</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macCredentials(String macCredentials);

        /**
         * <p>
         * Specifies the overrides to selectively enable or disable individual SIP settings. The individual settings you
         * specify here override the overall SIP status you specify for <b>MacSystemIntegrityProtectionStatus</b>.
         * </p>
         * 
         * @param macSystemIntegrityProtectionConfiguration
         *        Specifies the overrides to selectively enable or disable individual SIP settings. The individual
         *        settings you specify here override the overall SIP status you specify for
         *        <b>MacSystemIntegrityProtectionStatus</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macSystemIntegrityProtectionConfiguration(
                MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration);

        /**
         * <p>
         * Specifies the overrides to selectively enable or disable individual SIP settings. The individual settings you
         * specify here override the overall SIP status you specify for <b>MacSystemIntegrityProtectionStatus</b>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MacSystemIntegrityProtectionConfigurationRequest.Builder} avoiding the need to create one manually via
         * {@link MacSystemIntegrityProtectionConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MacSystemIntegrityProtectionConfigurationRequest.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #macSystemIntegrityProtectionConfiguration(MacSystemIntegrityProtectionConfigurationRequest)}.
         * 
         * @param macSystemIntegrityProtectionConfiguration
         *        a consumer that will call methods on {@link MacSystemIntegrityProtectionConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #macSystemIntegrityProtectionConfiguration(MacSystemIntegrityProtectionConfigurationRequest)
         */
        default Builder macSystemIntegrityProtectionConfiguration(
                Consumer<MacSystemIntegrityProtectionConfigurationRequest.Builder> macSystemIntegrityProtectionConfiguration) {
            return macSystemIntegrityProtectionConfiguration(MacSystemIntegrityProtectionConfigurationRequest.builder()
                    .applyMutation(macSystemIntegrityProtectionConfiguration).build());
        }

        /**
         * <p>
         * Specifies the overall SIP status for the instance. To enable all SIP settings, specify <code>enabled</code>.
         * To disable all SIP settings, specify <code>disabled</code>.
         * </p>
         * 
         * @param macSystemIntegrityProtectionStatus
         *        Specifies the overall SIP status for the instance. To enable all SIP settings, specify
         *        <code>enabled</code>. To disable all SIP settings, specify <code>disabled</code>.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder macSystemIntegrityProtectionStatus(String macSystemIntegrityProtectionStatus);

        /**
         * <p>
         * Specifies the overall SIP status for the instance. To enable all SIP settings, specify <code>enabled</code>.
         * To disable all SIP settings, specify <code>disabled</code>.
         * </p>
         * 
         * @param macSystemIntegrityProtectionStatus
         *        Specifies the overall SIP status for the instance. To enable all SIP settings, specify
         *        <code>enabled</code>. To disable all SIP settings, specify <code>disabled</code>.
         * @see MacSystemIntegrityProtectionSettingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacSystemIntegrityProtectionSettingStatus
         */
        Builder macSystemIntegrityProtectionStatus(MacSystemIntegrityProtectionSettingStatus macSystemIntegrityProtectionStatus);

        /**
         * <p>
         * Specifies tags to apply to the SIP modification task.
         * </p>
         * 
         * @param tagSpecifications
         *        Specifies tags to apply to the SIP modification task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * Specifies tags to apply to the SIP modification task.
         * </p>
         * 
         * @param tagSpecifications
         *        Specifies tags to apply to the SIP modification task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * Specifies tags to apply to the SIP modification task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private Boolean dryRun;

        private String instanceId;

        private String macCredentials;

        private MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration;

        private String macSystemIntegrityProtectionStatus;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMacSystemIntegrityProtectionModificationTaskRequest model) {
            super(model);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
            instanceId(model.instanceId);
            macCredentials(model.macCredentials);
            macSystemIntegrityProtectionConfiguration(model.macSystemIntegrityProtectionConfiguration);
            macSystemIntegrityProtectionStatus(model.macSystemIntegrityProtectionStatus);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getMacCredentials() {
            return macCredentials;
        }

        public final void setMacCredentials(String macCredentials) {
            this.macCredentials = macCredentials;
        }

        @Override
        public final Builder macCredentials(String macCredentials) {
            this.macCredentials = macCredentials;
            return this;
        }

        public final MacSystemIntegrityProtectionConfigurationRequest.Builder getMacSystemIntegrityProtectionConfiguration() {
            return macSystemIntegrityProtectionConfiguration != null ? macSystemIntegrityProtectionConfiguration.toBuilder()
                    : null;
        }

        public final void setMacSystemIntegrityProtectionConfiguration(
                MacSystemIntegrityProtectionConfigurationRequest.BuilderImpl macSystemIntegrityProtectionConfiguration) {
            this.macSystemIntegrityProtectionConfiguration = macSystemIntegrityProtectionConfiguration != null ? macSystemIntegrityProtectionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder macSystemIntegrityProtectionConfiguration(
                MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration) {
            this.macSystemIntegrityProtectionConfiguration = macSystemIntegrityProtectionConfiguration;
            return this;
        }

        public final String getMacSystemIntegrityProtectionStatus() {
            return macSystemIntegrityProtectionStatus;
        }

        public final void setMacSystemIntegrityProtectionStatus(String macSystemIntegrityProtectionStatus) {
            this.macSystemIntegrityProtectionStatus = macSystemIntegrityProtectionStatus;
        }

        @Override
        public final Builder macSystemIntegrityProtectionStatus(String macSystemIntegrityProtectionStatus) {
            this.macSystemIntegrityProtectionStatus = macSystemIntegrityProtectionStatus;
            return this;
        }

        @Override
        public final Builder macSystemIntegrityProtectionStatus(
                MacSystemIntegrityProtectionSettingStatus macSystemIntegrityProtectionStatus) {
            this.macSystemIntegrityProtectionStatus(macSystemIntegrityProtectionStatus == null ? null
                    : macSystemIntegrityProtectionStatus.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMacSystemIntegrityProtectionModificationTaskRequest build() {
            return new CreateMacSystemIntegrityProtectionModificationTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
