/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayPrefixListReferenceRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTransitGatewayPrefixListReferenceRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayRouteTableId").getter(CreateTransitGatewayPrefixListReferenceRequest.getter(CreateTransitGatewayPrefixListReferenceRequest::transitGatewayRouteTableId)).setter(CreateTransitGatewayPrefixListReferenceRequest.setter(Builder::transitGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId").unmarshallLocationName("TransitGatewayRouteTableId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(CreateTransitGatewayPrefixListReferenceRequest.getter(CreateTransitGatewayPrefixListReferenceRequest::prefixListId)).setter(CreateTransitGatewayPrefixListReferenceRequest.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("PrefixListId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(CreateTransitGatewayPrefixListReferenceRequest.getter(CreateTransitGatewayPrefixListReferenceRequest::transitGatewayAttachmentId)).setter(CreateTransitGatewayPrefixListReferenceRequest.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("TransitGatewayAttachmentId").build()}).build();
    private static final SdkField<Boolean> BLACKHOLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Blackhole").getter(CreateTransitGatewayPrefixListReferenceRequest.getter(CreateTransitGatewayPrefixListReferenceRequest::blackhole)).setter(CreateTransitGatewayPrefixListReferenceRequest.setter(Builder::blackhole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blackhole").unmarshallLocationName("Blackhole").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateTransitGatewayPrefixListReferenceRequest.getter(CreateTransitGatewayPrefixListReferenceRequest::dryRun)).setter(CreateTransitGatewayPrefixListReferenceRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, PREFIX_LIST_ID_FIELD, TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, BLACKHOLE_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTransitGatewayPrefixListReferenceRequest.memberNameToFieldInitializer();
    private final String transitGatewayRouteTableId;
    private final String prefixListId;
    private final String transitGatewayAttachmentId;
    private final Boolean blackhole;
    private final Boolean dryRun;

    private CreateTransitGatewayPrefixListReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.prefixListId = builder.prefixListId;
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.blackhole = builder.blackhole;
        this.dryRun = builder.dryRun;
    }

    public final String transitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final Boolean blackhole() {
        return this.blackhole;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blackhole());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayPrefixListReferenceRequest)) {
            return false;
        }
        CreateTransitGatewayPrefixListReferenceRequest other = (CreateTransitGatewayPrefixListReferenceRequest)((Object)obj);
        return Objects.equals(this.transitGatewayRouteTableId(), other.transitGatewayRouteTableId()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.blackhole(), other.blackhole()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayPrefixListReferenceRequest").add("TransitGatewayRouteTableId", (Object)this.transitGatewayRouteTableId()).add("PrefixListId", (Object)this.prefixListId()).add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("Blackhole", (Object)this.blackhole()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayRouteTableId()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "Blackhole": {
                return Optional.ofNullable(clazz.cast(this.blackhole()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayRouteTableId", TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("TransitGatewayAttachmentId", TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("Blackhole", BLACKHOLE_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayPrefixListReferenceRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayPrefixListReferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayRouteTableId;
        private String prefixListId;
        private String transitGatewayAttachmentId;
        private Boolean blackhole;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayPrefixListReferenceRequest model) {
            super(model);
            this.transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            this.prefixListId(model.prefixListId);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.blackhole(model.blackhole);
            this.dryRun(model.dryRun);
        }

        public final String getTransitGatewayRouteTableId() {
            return this.transitGatewayRouteTableId;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final Boolean getBlackhole() {
            return this.blackhole;
        }

        public final void setBlackhole(Boolean blackhole) {
            this.blackhole = blackhole;
        }

        @Override
        public final Builder blackhole(Boolean blackhole) {
            this.blackhole = blackhole;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayPrefixListReferenceRequest build() {
            return new CreateTransitGatewayPrefixListReferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayPrefixListReferenceRequest> {
        public Builder transitGatewayRouteTableId(String var1);

        public Builder prefixListId(String var1);

        public Builder transitGatewayAttachmentId(String var1);

        public Builder blackhole(Boolean var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

