/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LockSnapshotResponse extends Ec2Response implements
        ToCopyableBuilder<LockSnapshotResponse.Builder, LockSnapshotResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(LockSnapshotResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<String> LOCK_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LockState")
            .getter(getter(LockSnapshotResponse::lockStateAsString))
            .setter(setter(Builder::lockState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState")
                    .unmarshallLocationName("lockState").build()).build();

    private static final SdkField<Integer> LOCK_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LockDuration")
            .getter(getter(LockSnapshotResponse::lockDuration))
            .setter(setter(Builder::lockDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDuration")
                    .unmarshallLocationName("lockDuration").build()).build();

    private static final SdkField<Integer> COOL_OFF_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoolOffPeriod")
            .getter(getter(LockSnapshotResponse::coolOffPeriod))
            .setter(setter(Builder::coolOffPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriod")
                    .unmarshallLocationName("coolOffPeriod").build()).build();

    private static final SdkField<Instant> COOL_OFF_PERIOD_EXPIRES_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CoolOffPeriodExpiresOn")
            .getter(getter(LockSnapshotResponse::coolOffPeriodExpiresOn))
            .setter(setter(Builder::coolOffPeriodExpiresOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoolOffPeriodExpiresOn")
                    .unmarshallLocationName("coolOffPeriodExpiresOn").build()).build();

    private static final SdkField<Instant> LOCK_CREATED_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LockCreatedOn")
            .getter(getter(LockSnapshotResponse::lockCreatedOn))
            .setter(setter(Builder::lockCreatedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockCreatedOn")
                    .unmarshallLocationName("lockCreatedOn").build()).build();

    private static final SdkField<Instant> LOCK_EXPIRES_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LockExpiresOn")
            .getter(getter(LockSnapshotResponse::lockExpiresOn))
            .setter(setter(Builder::lockExpiresOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockExpiresOn")
                    .unmarshallLocationName("lockExpiresOn").build()).build();

    private static final SdkField<Instant> LOCK_DURATION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LockDurationStartTime")
            .getter(getter(LockSnapshotResponse::lockDurationStartTime))
            .setter(setter(Builder::lockDurationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockDurationStartTime")
                    .unmarshallLocationName("lockDurationStartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            LOCK_STATE_FIELD, LOCK_DURATION_FIELD, COOL_OFF_PERIOD_FIELD, COOL_OFF_PERIOD_EXPIRES_ON_FIELD,
            LOCK_CREATED_ON_FIELD, LOCK_EXPIRES_ON_FIELD, LOCK_DURATION_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snapshotId;

    private final String lockState;

    private final Integer lockDuration;

    private final Integer coolOffPeriod;

    private final Instant coolOffPeriodExpiresOn;

    private final Instant lockCreatedOn;

    private final Instant lockExpiresOn;

    private final Instant lockDurationStartTime;

    private LockSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.lockState = builder.lockState;
        this.lockDuration = builder.lockDuration;
        this.coolOffPeriod = builder.coolOffPeriod;
        this.coolOffPeriodExpiresOn = builder.coolOffPeriodExpiresOn;
        this.lockCreatedOn = builder.lockCreatedOn;
        this.lockExpiresOn = builder.lockExpiresOn;
        this.lockDurationStartTime = builder.lockDurationStartTime;
    }

    /**
     * <p>
     * The ID of the snapshot
     * </p>
     * 
     * @return The ID of the snapshot
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The state of the snapshot lock. Valid states include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
     * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be modified
     * by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it can be
     * unlocked and the lock settings can be modified by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired. The
     * snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
     * permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     * expired. The snapshot is not locked and can be deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The state of the snapshot lock. Valid states include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within
     *         the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can
     *         be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but
     *         it can be unlocked and the lock settings can be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
     *         expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with
     *         appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     *         expired. The snapshot is not locked and can be deleted.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final LockState lockState() {
        return LockState.fromValue(lockState);
    }

    /**
     * <p>
     * The state of the snapshot lock. Valid states include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
     * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be modified
     * by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it can be
     * unlocked and the lock settings can be modified by users with appropriate permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired. The
     * snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
     * permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     * expired. The snapshot is not locked and can be deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lockState} will
     * return {@link LockState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lockStateAsString}.
     * </p>
     * 
     * @return The state of the snapshot lock. Valid states include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within
     *         the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can
     *         be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but
     *         it can be unlocked and the lock settings can be modified by users with appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
     *         expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with
     *         appropriate permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
     *         expired. The snapshot is not locked and can be deleted.
     *         </p>
     *         </li>
     * @see LockState
     */
    public final String lockStateAsString() {
        return lockState;
    }

    /**
     * <p>
     * The period of time for which the snapshot is locked, in days.
     * </p>
     * 
     * @return The period of time for which the snapshot is locked, in days.
     */
    public final Integer lockDuration() {
        return lockDuration;
    }

    /**
     * <p>
     * The compliance mode cooling-off period, in hours.
     * </p>
     * 
     * @return The compliance mode cooling-off period, in hours.
     */
    public final Integer coolOffPeriod() {
        return coolOffPeriod;
    }

    /**
     * <p>
     * The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * 
     * @return The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     */
    public final Instant coolOffPeriodExpiresOn() {
        return coolOffPeriodExpiresOn;
    }

    /**
     * <p>
     * The date and time at which the snapshot was locked, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * 
     * @return The date and time at which the snapshot was locked, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     */
    public final Instant lockCreatedOn() {
        return lockCreatedOn;
    }

    /**
     * <p>
     * The date and time at which the lock will expire, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * 
     * @return The date and time at which the lock will expire, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     */
    public final Instant lockExpiresOn() {
        return lockExpiresOn;
    }

    /**
     * <p>
     * The date and time at which the lock duration started, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>
     * ).
     * </p>
     * 
     * @return The date and time at which the lock duration started, in the UTC time zone (
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     */
    public final Instant lockDurationStartTime() {
        return lockDurationStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lockDuration());
        hashCode = 31 * hashCode + Objects.hashCode(coolOffPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(coolOffPeriodExpiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(lockCreatedOn());
        hashCode = 31 * hashCode + Objects.hashCode(lockExpiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(lockDurationStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockSnapshotResponse)) {
            return false;
        }
        LockSnapshotResponse other = (LockSnapshotResponse) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(lockStateAsString(), other.lockStateAsString())
                && Objects.equals(lockDuration(), other.lockDuration()) && Objects.equals(coolOffPeriod(), other.coolOffPeriod())
                && Objects.equals(coolOffPeriodExpiresOn(), other.coolOffPeriodExpiresOn())
                && Objects.equals(lockCreatedOn(), other.lockCreatedOn())
                && Objects.equals(lockExpiresOn(), other.lockExpiresOn())
                && Objects.equals(lockDurationStartTime(), other.lockDurationStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LockSnapshotResponse").add("SnapshotId", snapshotId()).add("LockState", lockStateAsString())
                .add("LockDuration", lockDuration()).add("CoolOffPeriod", coolOffPeriod())
                .add("CoolOffPeriodExpiresOn", coolOffPeriodExpiresOn()).add("LockCreatedOn", lockCreatedOn())
                .add("LockExpiresOn", lockExpiresOn()).add("LockDurationStartTime", lockDurationStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "LockState":
            return Optional.ofNullable(clazz.cast(lockStateAsString()));
        case "LockDuration":
            return Optional.ofNullable(clazz.cast(lockDuration()));
        case "CoolOffPeriod":
            return Optional.ofNullable(clazz.cast(coolOffPeriod()));
        case "CoolOffPeriodExpiresOn":
            return Optional.ofNullable(clazz.cast(coolOffPeriodExpiresOn()));
        case "LockCreatedOn":
            return Optional.ofNullable(clazz.cast(lockCreatedOn()));
        case "LockExpiresOn":
            return Optional.ofNullable(clazz.cast(lockExpiresOn()));
        case "LockDurationStartTime":
            return Optional.ofNullable(clazz.cast(lockDurationStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("LockState", LOCK_STATE_FIELD);
        map.put("LockDuration", LOCK_DURATION_FIELD);
        map.put("CoolOffPeriod", COOL_OFF_PERIOD_FIELD);
        map.put("CoolOffPeriodExpiresOn", COOL_OFF_PERIOD_EXPIRES_ON_FIELD);
        map.put("LockCreatedOn", LOCK_CREATED_ON_FIELD);
        map.put("LockExpiresOn", LOCK_EXPIRES_ON_FIELD);
        map.put("LockDurationStartTime", LOCK_DURATION_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LockSnapshotResponse, T> g) {
        return obj -> g.apply((LockSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, LockSnapshotResponse> {
        /**
         * <p>
         * The ID of the snapshot
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The state of the snapshot lock. Valid states include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
         * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be
         * modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it
         * can be unlocked and the lock settings can be modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired.
         * The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
         * expired. The snapshot is not locked and can be deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        The state of the snapshot lock. Valid states include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still
         *        within the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock
         *        settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted,
         *        but it can be unlocked and the lock settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
         *        expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users
         *        with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration
         *        has expired. The snapshot is not locked and can be deleted.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(String lockState);

        /**
         * <p>
         * The state of the snapshot lock. Valid states include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still within the
         * cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock settings can be
         * modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted, but it
         * can be unlocked and the lock settings can be modified by users with appropriate permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has expired.
         * The snapshot can't be unlocked or deleted. The lock duration can only be increased by users with appropriate
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration has
         * expired. The snapshot is not locked and can be deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lockState
         *        The state of the snapshot lock. Valid states include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>compliance-cooloff</code> - The snapshot has been locked in compliance mode but it is still
         *        within the cooling-off period. The snapshot can't be deleted, but it can be unlocked and the lock
         *        settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>governance</code> - The snapshot is locked in governance mode. The snapshot can't be deleted,
         *        but it can be unlocked and the lock settings can be modified by users with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>compliance</code> - The snapshot is locked in compliance mode and the cooling-off period has
         *        expired. The snapshot can't be unlocked or deleted. The lock duration can only be increased by users
         *        with appropriate permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expired</code> - The snapshot was locked in compliance or governance mode but the lock duration
         *        has expired. The snapshot is not locked and can be deleted.
         *        </p>
         *        </li>
         * @see LockState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LockState
         */
        Builder lockState(LockState lockState);

        /**
         * <p>
         * The period of time for which the snapshot is locked, in days.
         * </p>
         * 
         * @param lockDuration
         *        The period of time for which the snapshot is locked, in days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockDuration(Integer lockDuration);

        /**
         * <p>
         * The compliance mode cooling-off period, in hours.
         * </p>
         * 
         * @param coolOffPeriod
         *        The compliance mode cooling-off period, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coolOffPeriod(Integer coolOffPeriod);

        /**
         * <p>
         * The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * 
         * @param coolOffPeriodExpiresOn
         *        The date and time at which the compliance mode cooling-off period expires, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn);

        /**
         * <p>
         * The date and time at which the snapshot was locked, in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * 
         * @param lockCreatedOn
         *        The date and time at which the snapshot was locked, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockCreatedOn(Instant lockCreatedOn);

        /**
         * <p>
         * The date and time at which the lock will expire, in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>
         * ).
         * </p>
         * 
         * @param lockExpiresOn
         *        The date and time at which the lock will expire, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockExpiresOn(Instant lockExpiresOn);

        /**
         * <p>
         * The date and time at which the lock duration started, in the UTC time zone (
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * 
         * @param lockDurationStartTime
         *        The date and time at which the lock duration started, in the UTC time zone (
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockDurationStartTime(Instant lockDurationStartTime);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String snapshotId;

        private String lockState;

        private Integer lockDuration;

        private Integer coolOffPeriod;

        private Instant coolOffPeriodExpiresOn;

        private Instant lockCreatedOn;

        private Instant lockExpiresOn;

        private Instant lockDurationStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LockSnapshotResponse model) {
            super(model);
            snapshotId(model.snapshotId);
            lockState(model.lockState);
            lockDuration(model.lockDuration);
            coolOffPeriod(model.coolOffPeriod);
            coolOffPeriodExpiresOn(model.coolOffPeriodExpiresOn);
            lockCreatedOn(model.lockCreatedOn);
            lockExpiresOn(model.lockExpiresOn);
            lockDurationStartTime(model.lockDurationStartTime);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getLockState() {
            return lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final Integer getLockDuration() {
            return lockDuration;
        }

        public final void setLockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
        }

        @Override
        public final Builder lockDuration(Integer lockDuration) {
            this.lockDuration = lockDuration;
            return this;
        }

        public final Integer getCoolOffPeriod() {
            return coolOffPeriod;
        }

        public final void setCoolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
        }

        @Override
        public final Builder coolOffPeriod(Integer coolOffPeriod) {
            this.coolOffPeriod = coolOffPeriod;
            return this;
        }

        public final Instant getCoolOffPeriodExpiresOn() {
            return coolOffPeriodExpiresOn;
        }

        public final void setCoolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
        }

        @Override
        public final Builder coolOffPeriodExpiresOn(Instant coolOffPeriodExpiresOn) {
            this.coolOffPeriodExpiresOn = coolOffPeriodExpiresOn;
            return this;
        }

        public final Instant getLockCreatedOn() {
            return lockCreatedOn;
        }

        public final void setLockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
        }

        @Override
        public final Builder lockCreatedOn(Instant lockCreatedOn) {
            this.lockCreatedOn = lockCreatedOn;
            return this;
        }

        public final Instant getLockExpiresOn() {
            return lockExpiresOn;
        }

        public final void setLockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
        }

        @Override
        public final Builder lockExpiresOn(Instant lockExpiresOn) {
            this.lockExpiresOn = lockExpiresOn;
            return this;
        }

        public final Instant getLockDurationStartTime() {
            return lockDurationStartTime;
        }

        public final void setLockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
        }

        @Override
        public final Builder lockDurationStartTime(Instant lockDurationStartTime) {
            this.lockDurationStartTime = lockDurationStartTime;
            return this;
        }

        @Override
        public LockSnapshotResponse build() {
            return new LockSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
