/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.EkPubKeyFormat;
import software.amazon.awssdk.services.ec2.model.EkPubKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstanceTpmEkPubResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetInstanceTpmEkPubResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetInstanceTpmEkPubResponse.getter(GetInstanceTpmEkPubResponse::instanceId)).setter(GetInstanceTpmEkPubResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(GetInstanceTpmEkPubResponse.getter(GetInstanceTpmEkPubResponse::keyTypeAsString)).setter(GetInstanceTpmEkPubResponse.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").unmarshallLocationName("keyType").build()}).build();
    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFormat").getter(GetInstanceTpmEkPubResponse.getter(GetInstanceTpmEkPubResponse::keyFormatAsString)).setter(GetInstanceTpmEkPubResponse.setter(Builder::keyFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFormat").unmarshallLocationName("keyFormat").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyValue").getter(GetInstanceTpmEkPubResponse.getter(GetInstanceTpmEkPubResponse::keyValue)).setter(GetInstanceTpmEkPubResponse.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValue").unmarshallLocationName("keyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, KEY_TYPE_FIELD, KEY_FORMAT_FIELD, KEY_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInstanceTpmEkPubResponse.memberNameToFieldInitializer();
    private final String instanceId;
    private final String keyType;
    private final String keyFormat;
    private final String keyValue;

    private GetInstanceTpmEkPubResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.keyType = builder.keyType;
        this.keyFormat = builder.keyFormat;
        this.keyValue = builder.keyValue;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final EkPubKeyType keyType() {
        return EkPubKeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public final EkPubKeyFormat keyFormat() {
        return EkPubKeyFormat.fromValue(this.keyFormat);
    }

    public final String keyFormatAsString() {
        return this.keyFormat;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceTpmEkPubResponse)) {
            return false;
        }
        GetInstanceTpmEkPubResponse other = (GetInstanceTpmEkPubResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(this.keyFormatAsString(), other.keyFormatAsString()) && Objects.equals(this.keyValue(), other.keyValue());
    }

    public final String toString() {
        return ToString.builder((String)"GetInstanceTpmEkPubResponse").add("InstanceId", (Object)this.instanceId()).add("KeyType", (Object)this.keyTypeAsString()).add("KeyFormat", (Object)this.keyFormatAsString()).add("KeyValue", (Object)(this.keyValue() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "KeyFormat": {
                return Optional.ofNullable(clazz.cast(this.keyFormatAsString()));
            }
            case "KeyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("KeyType", KEY_TYPE_FIELD);
        map.put("KeyFormat", KEY_FORMAT_FIELD);
        map.put("KeyValue", KEY_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceTpmEkPubResponse, T> g) {
        return obj -> g.apply((GetInstanceTpmEkPubResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private String keyType;
        private String keyFormat;
        private String keyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceTpmEkPubResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.keyType(model.keyType);
            this.keyFormat(model.keyFormat);
            this.keyValue(model.keyValue);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(EkPubKeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final String getKeyFormat() {
            return this.keyFormat;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        @Override
        public final Builder keyFormat(EkPubKeyFormat keyFormat) {
            this.keyFormat(keyFormat == null ? null : keyFormat.toString());
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        @Override
        public GetInstanceTpmEkPubResponse build() {
            return new GetInstanceTpmEkPubResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInstanceTpmEkPubResponse> {
        public Builder instanceId(String var1);

        public Builder keyType(String var1);

        public Builder keyType(EkPubKeyType var1);

        public Builder keyFormat(String var1);

        public Builder keyFormat(EkPubKeyFormat var1);

        public Builder keyValue(String var1);
    }
}

