/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionIpamByoasnResponse extends Ec2Response implements
        ToCopyableBuilder<ProvisionIpamByoasnResponse.Builder, ProvisionIpamByoasnResponse> {
    private static final SdkField<Byoasn> BYOASN_FIELD = SdkField
            .<Byoasn> builder(MarshallingType.SDK_POJO)
            .memberName("Byoasn")
            .getter(getter(ProvisionIpamByoasnResponse::byoasn))
            .setter(setter(Builder::byoasn))
            .constructor(Byoasn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Byoasn")
                    .unmarshallLocationName("byoasn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYOASN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Byoasn byoasn;

    private ProvisionIpamByoasnResponse(BuilderImpl builder) {
        super(builder);
        this.byoasn = builder.byoasn;
    }

    /**
     * <p>
     * An ASN and BYOIP CIDR association.
     * </p>
     * 
     * @return An ASN and BYOIP CIDR association.
     */
    public final Byoasn byoasn() {
        return byoasn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byoasn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionIpamByoasnResponse)) {
            return false;
        }
        ProvisionIpamByoasnResponse other = (ProvisionIpamByoasnResponse) obj;
        return Objects.equals(byoasn(), other.byoasn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionIpamByoasnResponse").add("Byoasn", byoasn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Byoasn":
            return Optional.ofNullable(clazz.cast(byoasn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Byoasn", BYOASN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionIpamByoasnResponse, T> g) {
        return obj -> g.apply((ProvisionIpamByoasnResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionIpamByoasnResponse> {
        /**
         * <p>
         * An ASN and BYOIP CIDR association.
         * </p>
         * 
         * @param byoasn
         *        An ASN and BYOIP CIDR association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byoasn(Byoasn byoasn);

        /**
         * <p>
         * An ASN and BYOIP CIDR association.
         * </p>
         * This is a convenience method that creates an instance of the {@link Byoasn.Builder} avoiding the need to
         * create one manually via {@link Byoasn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Byoasn.Builder#build()} is called immediately and its result is
         * passed to {@link #byoasn(Byoasn)}.
         * 
         * @param byoasn
         *        a consumer that will call methods on {@link Byoasn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byoasn(Byoasn)
         */
        default Builder byoasn(Consumer<Byoasn.Builder> byoasn) {
            return byoasn(Byoasn.builder().applyMutation(byoasn).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Byoasn byoasn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionIpamByoasnResponse model) {
            super(model);
            byoasn(model.byoasn);
        }

        public final Byoasn.Builder getByoasn() {
            return byoasn != null ? byoasn.toBuilder() : null;
        }

        public final void setByoasn(Byoasn.BuilderImpl byoasn) {
            this.byoasn = byoasn != null ? byoasn.build() : null;
        }

        @Override
        public final Builder byoasn(Byoasn byoasn) {
            this.byoasn = byoasn;
            return this;
        }

        @Override
        public ProvisionIpamByoasnResponse build() {
            return new ProvisionIpamByoasnResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
