/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelCapacityReservationFleetsResponse extends Ec2Response implements
        ToCopyableBuilder<CancelCapacityReservationFleetsResponse.Builder, CancelCapacityReservationFleetsResponse> {
    private static final SdkField<List<CapacityReservationFleetCancellationState>> SUCCESSFUL_FLEET_CANCELLATIONS_FIELD = SdkField
            .<List<CapacityReservationFleetCancellationState>> builder(MarshallingType.LIST)
            .memberName("SuccessfulFleetCancellations")
            .getter(getter(CancelCapacityReservationFleetsResponse::successfulFleetCancellations))
            .setter(setter(Builder::successfulFleetCancellations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulFleetCancellationSet")
                    .unmarshallLocationName("successfulFleetCancellationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityReservationFleetCancellationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityReservationFleetCancellationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<FailedCapacityReservationFleetCancellationResult>> FAILED_FLEET_CANCELLATIONS_FIELD = SdkField
            .<List<FailedCapacityReservationFleetCancellationResult>> builder(MarshallingType.LIST)
            .memberName("FailedFleetCancellations")
            .getter(getter(CancelCapacityReservationFleetsResponse::failedFleetCancellations))
            .setter(setter(Builder::failedFleetCancellations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedFleetCancellationSet")
                    .unmarshallLocationName("failedFleetCancellationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FailedCapacityReservationFleetCancellationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedCapacityReservationFleetCancellationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFUL_FLEET_CANCELLATIONS_FIELD, FAILED_FLEET_CANCELLATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CapacityReservationFleetCancellationState> successfulFleetCancellations;

    private final List<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations;

    private CancelCapacityReservationFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulFleetCancellations = builder.successfulFleetCancellations;
        this.failedFleetCancellations = builder.failedFleetCancellations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulFleetCancellations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSuccessfulFleetCancellations() {
        return successfulFleetCancellations != null && !(successfulFleetCancellations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Capacity Reservation Fleets that were successfully cancelled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulFleetCancellations} method.
     * </p>
     * 
     * @return Information about the Capacity Reservation Fleets that were successfully cancelled.
     */
    public final List<CapacityReservationFleetCancellationState> successfulFleetCancellations() {
        return successfulFleetCancellations;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedFleetCancellations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedFleetCancellations() {
        return failedFleetCancellations != null && !(failedFleetCancellations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Capacity Reservation Fleets that could not be cancelled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedFleetCancellations} method.
     * </p>
     * 
     * @return Information about the Capacity Reservation Fleets that could not be cancelled.
     */
    public final List<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations() {
        return failedFleetCancellations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulFleetCancellations() ? successfulFleetCancellations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedFleetCancellations() ? failedFleetCancellations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelCapacityReservationFleetsResponse)) {
            return false;
        }
        CancelCapacityReservationFleetsResponse other = (CancelCapacityReservationFleetsResponse) obj;
        return hasSuccessfulFleetCancellations() == other.hasSuccessfulFleetCancellations()
                && Objects.equals(successfulFleetCancellations(), other.successfulFleetCancellations())
                && hasFailedFleetCancellations() == other.hasFailedFleetCancellations()
                && Objects.equals(failedFleetCancellations(), other.failedFleetCancellations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelCapacityReservationFleetsResponse")
                .add("SuccessfulFleetCancellations", hasSuccessfulFleetCancellations() ? successfulFleetCancellations() : null)
                .add("FailedFleetCancellations", hasFailedFleetCancellations() ? failedFleetCancellations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulFleetCancellations":
            return Optional.ofNullable(clazz.cast(successfulFleetCancellations()));
        case "FailedFleetCancellations":
            return Optional.ofNullable(clazz.cast(failedFleetCancellations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuccessfulFleetCancellationSet", SUCCESSFUL_FLEET_CANCELLATIONS_FIELD);
        map.put("FailedFleetCancellationSet", FAILED_FLEET_CANCELLATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelCapacityReservationFleetsResponse, T> g) {
        return obj -> g.apply((CancelCapacityReservationFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelCapacityReservationFleetsResponse> {
        /**
         * <p>
         * Information about the Capacity Reservation Fleets that were successfully cancelled.
         * </p>
         * 
         * @param successfulFleetCancellations
         *        Information about the Capacity Reservation Fleets that were successfully cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetCancellations(Collection<CapacityReservationFleetCancellationState> successfulFleetCancellations);

        /**
         * <p>
         * Information about the Capacity Reservation Fleets that were successfully cancelled.
         * </p>
         * 
         * @param successfulFleetCancellations
         *        Information about the Capacity Reservation Fleets that were successfully cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetCancellations(CapacityReservationFleetCancellationState... successfulFleetCancellations);

        /**
         * <p>
         * Information about the Capacity Reservation Fleets that were successfully cancelled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successfulFleetCancellations(List<CapacityReservationFleetCancellationState>)}.
         * 
         * @param successfulFleetCancellations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityReservationFleetCancellationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulFleetCancellations(java.util.Collection<CapacityReservationFleetCancellationState>)
         */
        Builder successfulFleetCancellations(
                Consumer<CapacityReservationFleetCancellationState.Builder>... successfulFleetCancellations);

        /**
         * <p>
         * Information about the Capacity Reservation Fleets that could not be cancelled.
         * </p>
         * 
         * @param failedFleetCancellations
         *        Information about the Capacity Reservation Fleets that could not be cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFleetCancellations(Collection<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations);

        /**
         * <p>
         * Information about the Capacity Reservation Fleets that could not be cancelled.
         * </p>
         * 
         * @param failedFleetCancellations
         *        Information about the Capacity Reservation Fleets that could not be cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFleetCancellations(FailedCapacityReservationFleetCancellationResult... failedFleetCancellations);

        /**
         * <p>
         * Information about the Capacity Reservation Fleets that could not be cancelled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedFleetCancellations(List<FailedCapacityReservationFleetCancellationResult>)}.
         * 
         * @param failedFleetCancellations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.FailedCapacityReservationFleetCancellationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedFleetCancellations(java.util.Collection<FailedCapacityReservationFleetCancellationResult>)
         */
        Builder failedFleetCancellations(
                Consumer<FailedCapacityReservationFleetCancellationResult.Builder>... failedFleetCancellations);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CapacityReservationFleetCancellationState> successfulFleetCancellations = DefaultSdkAutoConstructList
                .getInstance();

        private List<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelCapacityReservationFleetsResponse model) {
            super(model);
            successfulFleetCancellations(model.successfulFleetCancellations);
            failedFleetCancellations(model.failedFleetCancellations);
        }

        public final List<CapacityReservationFleetCancellationState.Builder> getSuccessfulFleetCancellations() {
            List<CapacityReservationFleetCancellationState.Builder> result = CapacityReservationFleetCancellationStateSetCopier
                    .copyToBuilder(this.successfulFleetCancellations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulFleetCancellations(
                Collection<CapacityReservationFleetCancellationState.BuilderImpl> successfulFleetCancellations) {
            this.successfulFleetCancellations = CapacityReservationFleetCancellationStateSetCopier
                    .copyFromBuilder(successfulFleetCancellations);
        }

        @Override
        public final Builder successfulFleetCancellations(
                Collection<CapacityReservationFleetCancellationState> successfulFleetCancellations) {
            this.successfulFleetCancellations = CapacityReservationFleetCancellationStateSetCopier
                    .copy(successfulFleetCancellations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetCancellations(
                CapacityReservationFleetCancellationState... successfulFleetCancellations) {
            successfulFleetCancellations(Arrays.asList(successfulFleetCancellations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetCancellations(
                Consumer<CapacityReservationFleetCancellationState.Builder>... successfulFleetCancellations) {
            successfulFleetCancellations(Stream.of(successfulFleetCancellations)
                    .map(c -> CapacityReservationFleetCancellationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FailedCapacityReservationFleetCancellationResult.Builder> getFailedFleetCancellations() {
            List<FailedCapacityReservationFleetCancellationResult.Builder> result = FailedCapacityReservationFleetCancellationResultSetCopier
                    .copyToBuilder(this.failedFleetCancellations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedFleetCancellations(
                Collection<FailedCapacityReservationFleetCancellationResult.BuilderImpl> failedFleetCancellations) {
            this.failedFleetCancellations = FailedCapacityReservationFleetCancellationResultSetCopier
                    .copyFromBuilder(failedFleetCancellations);
        }

        @Override
        public final Builder failedFleetCancellations(
                Collection<FailedCapacityReservationFleetCancellationResult> failedFleetCancellations) {
            this.failedFleetCancellations = FailedCapacityReservationFleetCancellationResultSetCopier
                    .copy(failedFleetCancellations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFleetCancellations(
                FailedCapacityReservationFleetCancellationResult... failedFleetCancellations) {
            failedFleetCancellations(Arrays.asList(failedFleetCancellations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedFleetCancellations(
                Consumer<FailedCapacityReservationFleetCancellationResult.Builder>... failedFleetCancellations) {
            failedFleetCancellations(Stream.of(failedFleetCancellations)
                    .map(c -> FailedCapacityReservationFleetCancellationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CancelCapacityReservationFleetsResponse build() {
            return new CancelCapacityReservationFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
