/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class PrivateIpAddressConfigSetCopier {
    static List<ScheduledInstancesPrivateIpAddressConfig> copy(
            Collection<? extends ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigSetParam) {
        List<ScheduledInstancesPrivateIpAddressConfig> list;
        if (privateIpAddressConfigSetParam == null || privateIpAddressConfigSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScheduledInstancesPrivateIpAddressConfig> modifiableList = new ArrayList<>(privateIpAddressConfigSetParam.size());
            privateIpAddressConfigSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ScheduledInstancesPrivateIpAddressConfig> copyFromBuilder(
            Collection<? extends ScheduledInstancesPrivateIpAddressConfig.Builder> privateIpAddressConfigSetParam) {
        List<ScheduledInstancesPrivateIpAddressConfig> list;
        if (privateIpAddressConfigSetParam == null || privateIpAddressConfigSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScheduledInstancesPrivateIpAddressConfig> modifiableList = new ArrayList<>(privateIpAddressConfigSetParam.size());
            privateIpAddressConfigSetParam.forEach(entry -> {
                ScheduledInstancesPrivateIpAddressConfig member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ScheduledInstancesPrivateIpAddressConfig.Builder> copyToBuilder(
            Collection<? extends ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigSetParam) {
        List<ScheduledInstancesPrivateIpAddressConfig.Builder> list;
        if (privateIpAddressConfigSetParam == null || privateIpAddressConfigSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ScheduledInstancesPrivateIpAddressConfig.Builder> modifiableList = new ArrayList<>(
                    privateIpAddressConfigSetParam.size());
            privateIpAddressConfigSetParam.forEach(entry -> {
                ScheduledInstancesPrivateIpAddressConfig.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
