/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of units to request. You can choose to set the target capacity as the number of instances. Or you can set
 * the target capacity to a performance characteristic that is important to your application workload, such as vCPUs,
 * memory, or I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity
 * later.
 * </p>
 * <p>
 * You can use the On-Demand Instance <code>MaxTotalPrice</code> parameter, the Spot Instance <code>MaxTotalPrice</code>
 * parameter, or both parameters to ensure that your fleet cost does not exceed your budget. If you set a maximum price
 * per hour for the On-Demand Instances and Spot Instances in your request, EC2 Fleet will launch instances until it
 * reaches the maximum amount that you're willing to pay. When the maximum amount you're willing to pay is reached, the
 * fleet stops launching instances even if it hasn't met the target capacity. The <code>MaxTotalPrice</code> parameters
 * are located in <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_OnDemandOptionsRequest">OnDemandOptionsRequest</a>
 * and <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotOptionsRequest">SpotOptionsRequest</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetCapacitySpecificationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetCapacitySpecificationRequest.Builder, TargetCapacitySpecificationRequest> {
    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalTargetCapacity")
            .getter(getter(TargetCapacitySpecificationRequest::totalTargetCapacity))
            .setter(setter(Builder::totalTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity")
                    .unmarshallLocationName("TotalTargetCapacity").build()).build();

    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandTargetCapacity")
            .getter(getter(TargetCapacitySpecificationRequest::onDemandTargetCapacity))
            .setter(setter(Builder::onDemandTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity")
                    .unmarshallLocationName("OnDemandTargetCapacity").build()).build();

    private static final SdkField<Integer> SPOT_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpotTargetCapacity")
            .getter(getter(TargetCapacitySpecificationRequest::spotTargetCapacity))
            .setter(setter(Builder::spotTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotTargetCapacity")
                    .unmarshallLocationName("SpotTargetCapacity").build()).build();

    private static final SdkField<String> DEFAULT_TARGET_CAPACITY_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultTargetCapacityType")
            .getter(getter(TargetCapacitySpecificationRequest::defaultTargetCapacityTypeAsString))
            .setter(setter(Builder::defaultTargetCapacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTargetCapacityType")
                    .unmarshallLocationName("DefaultTargetCapacityType").build()).build();

    private static final SdkField<String> TARGET_CAPACITY_UNIT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetCapacityUnitType")
            .getter(getter(TargetCapacitySpecificationRequest::targetCapacityUnitTypeAsString))
            .setter(setter(Builder::targetCapacityUnitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacityUnitType")
                    .unmarshallLocationName("TargetCapacityUnitType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_TARGET_CAPACITY_FIELD,
            ON_DEMAND_TARGET_CAPACITY_FIELD, SPOT_TARGET_CAPACITY_FIELD, DEFAULT_TARGET_CAPACITY_TYPE_FIELD,
            TARGET_CAPACITY_UNIT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer totalTargetCapacity;

    private final Integer onDemandTargetCapacity;

    private final Integer spotTargetCapacity;

    private final String defaultTargetCapacityType;

    private final String targetCapacityUnitType;

    private TargetCapacitySpecificationRequest(BuilderImpl builder) {
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.spotTargetCapacity = builder.spotTargetCapacity;
        this.defaultTargetCapacityType = builder.defaultTargetCapacityType;
        this.targetCapacityUnitType = builder.targetCapacityUnitType;
    }

    /**
     * <p>
     * The number of units to request, filled using the default target capacity type.
     * </p>
     * 
     * @return The number of units to request, filled using the default target capacity type.
     */
    public final Integer totalTargetCapacity() {
        return totalTargetCapacity;
    }

    /**
     * <p>
     * The number of On-Demand units to request.
     * </p>
     * 
     * @return The number of On-Demand units to request.
     */
    public final Integer onDemandTargetCapacity() {
        return onDemandTargetCapacity;
    }

    /**
     * <p>
     * The number of Spot units to request.
     * </p>
     * 
     * @return The number of Spot units to request.
     */
    public final Integer spotTargetCapacity() {
        return spotTargetCapacity;
    }

    /**
     * <p>
     * The default target capacity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultTargetCapacityType} will return {@link DefaultTargetCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultTargetCapacityTypeAsString}.
     * </p>
     * 
     * @return The default target capacity type.
     * @see DefaultTargetCapacityType
     */
    public final DefaultTargetCapacityType defaultTargetCapacityType() {
        return DefaultTargetCapacityType.fromValue(defaultTargetCapacityType);
    }

    /**
     * <p>
     * The default target capacity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultTargetCapacityType} will return {@link DefaultTargetCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #defaultTargetCapacityTypeAsString}.
     * </p>
     * 
     * @return The default target capacity type.
     * @see DefaultTargetCapacityType
     */
    public final String defaultTargetCapacityTypeAsString() {
        return defaultTargetCapacityType;
    }

    /**
     * <p>
     * The unit for the target capacity. You can specify this parameter only when using attributed-based instance type
     * selection.
     * </p>
     * <p>
     * Default: <code>units</code> (the number of instances)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCapacityUnitType} will return {@link TargetCapacityUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCapacityUnitTypeAsString}.
     * </p>
     * 
     * @return The unit for the target capacity. You can specify this parameter only when using attributed-based
     *         instance type selection.</p>
     *         <p>
     *         Default: <code>units</code> (the number of instances)
     * @see TargetCapacityUnitType
     */
    public final TargetCapacityUnitType targetCapacityUnitType() {
        return TargetCapacityUnitType.fromValue(targetCapacityUnitType);
    }

    /**
     * <p>
     * The unit for the target capacity. You can specify this parameter only when using attributed-based instance type
     * selection.
     * </p>
     * <p>
     * Default: <code>units</code> (the number of instances)
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetCapacityUnitType} will return {@link TargetCapacityUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetCapacityUnitTypeAsString}.
     * </p>
     * 
     * @return The unit for the target capacity. You can specify this parameter only when using attributed-based
     *         instance type selection.</p>
     *         <p>
     *         Default: <code>units</code> (the number of instances)
     * @see TargetCapacityUnitType
     */
    public final String targetCapacityUnitTypeAsString() {
        return targetCapacityUnitType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(spotTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTargetCapacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacityUnitTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetCapacitySpecificationRequest)) {
            return false;
        }
        TargetCapacitySpecificationRequest other = (TargetCapacitySpecificationRequest) obj;
        return Objects.equals(totalTargetCapacity(), other.totalTargetCapacity())
                && Objects.equals(onDemandTargetCapacity(), other.onDemandTargetCapacity())
                && Objects.equals(spotTargetCapacity(), other.spotTargetCapacity())
                && Objects.equals(defaultTargetCapacityTypeAsString(), other.defaultTargetCapacityTypeAsString())
                && Objects.equals(targetCapacityUnitTypeAsString(), other.targetCapacityUnitTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetCapacitySpecificationRequest").add("TotalTargetCapacity", totalTargetCapacity())
                .add("OnDemandTargetCapacity", onDemandTargetCapacity()).add("SpotTargetCapacity", spotTargetCapacity())
                .add("DefaultTargetCapacityType", defaultTargetCapacityTypeAsString())
                .add("TargetCapacityUnitType", targetCapacityUnitTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalTargetCapacity":
            return Optional.ofNullable(clazz.cast(totalTargetCapacity()));
        case "OnDemandTargetCapacity":
            return Optional.ofNullable(clazz.cast(onDemandTargetCapacity()));
        case "SpotTargetCapacity":
            return Optional.ofNullable(clazz.cast(spotTargetCapacity()));
        case "DefaultTargetCapacityType":
            return Optional.ofNullable(clazz.cast(defaultTargetCapacityTypeAsString()));
        case "TargetCapacityUnitType":
            return Optional.ofNullable(clazz.cast(targetCapacityUnitTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalTargetCapacity", TOTAL_TARGET_CAPACITY_FIELD);
        map.put("OnDemandTargetCapacity", ON_DEMAND_TARGET_CAPACITY_FIELD);
        map.put("SpotTargetCapacity", SPOT_TARGET_CAPACITY_FIELD);
        map.put("DefaultTargetCapacityType", DEFAULT_TARGET_CAPACITY_TYPE_FIELD);
        map.put("TargetCapacityUnitType", TARGET_CAPACITY_UNIT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetCapacitySpecificationRequest, T> g) {
        return obj -> g.apply((TargetCapacitySpecificationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetCapacitySpecificationRequest> {
        /**
         * <p>
         * The number of units to request, filled using the default target capacity type.
         * </p>
         * 
         * @param totalTargetCapacity
         *        The number of units to request, filled using the default target capacity type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalTargetCapacity(Integer totalTargetCapacity);

        /**
         * <p>
         * The number of On-Demand units to request.
         * </p>
         * 
         * @param onDemandTargetCapacity
         *        The number of On-Demand units to request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandTargetCapacity(Integer onDemandTargetCapacity);

        /**
         * <p>
         * The number of Spot units to request.
         * </p>
         * 
         * @param spotTargetCapacity
         *        The number of Spot units to request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotTargetCapacity(Integer spotTargetCapacity);

        /**
         * <p>
         * The default target capacity type.
         * </p>
         * 
         * @param defaultTargetCapacityType
         *        The default target capacity type.
         * @see DefaultTargetCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultTargetCapacityType
         */
        Builder defaultTargetCapacityType(String defaultTargetCapacityType);

        /**
         * <p>
         * The default target capacity type.
         * </p>
         * 
         * @param defaultTargetCapacityType
         *        The default target capacity type.
         * @see DefaultTargetCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultTargetCapacityType
         */
        Builder defaultTargetCapacityType(DefaultTargetCapacityType defaultTargetCapacityType);

        /**
         * <p>
         * The unit for the target capacity. You can specify this parameter only when using attributed-based instance
         * type selection.
         * </p>
         * <p>
         * Default: <code>units</code> (the number of instances)
         * </p>
         * 
         * @param targetCapacityUnitType
         *        The unit for the target capacity. You can specify this parameter only when using attributed-based
         *        instance type selection.</p>
         *        <p>
         *        Default: <code>units</code> (the number of instances)
         * @see TargetCapacityUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCapacityUnitType
         */
        Builder targetCapacityUnitType(String targetCapacityUnitType);

        /**
         * <p>
         * The unit for the target capacity. You can specify this parameter only when using attributed-based instance
         * type selection.
         * </p>
         * <p>
         * Default: <code>units</code> (the number of instances)
         * </p>
         * 
         * @param targetCapacityUnitType
         *        The unit for the target capacity. You can specify this parameter only when using attributed-based
         *        instance type selection.</p>
         *        <p>
         *        Default: <code>units</code> (the number of instances)
         * @see TargetCapacityUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetCapacityUnitType
         */
        Builder targetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalTargetCapacity;

        private Integer onDemandTargetCapacity;

        private Integer spotTargetCapacity;

        private String defaultTargetCapacityType;

        private String targetCapacityUnitType;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetCapacitySpecificationRequest model) {
            totalTargetCapacity(model.totalTargetCapacity);
            onDemandTargetCapacity(model.onDemandTargetCapacity);
            spotTargetCapacity(model.spotTargetCapacity);
            defaultTargetCapacityType(model.defaultTargetCapacityType);
            targetCapacityUnitType(model.targetCapacityUnitType);
        }

        public final Integer getTotalTargetCapacity() {
            return totalTargetCapacity;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        @Override
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final Integer getOnDemandTargetCapacity() {
            return onDemandTargetCapacity;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final Integer getSpotTargetCapacity() {
            return spotTargetCapacity;
        }

        public final void setSpotTargetCapacity(Integer spotTargetCapacity) {
            this.spotTargetCapacity = spotTargetCapacity;
        }

        @Override
        public final Builder spotTargetCapacity(Integer spotTargetCapacity) {
            this.spotTargetCapacity = spotTargetCapacity;
            return this;
        }

        public final String getDefaultTargetCapacityType() {
            return defaultTargetCapacityType;
        }

        public final void setDefaultTargetCapacityType(String defaultTargetCapacityType) {
            this.defaultTargetCapacityType = defaultTargetCapacityType;
        }

        @Override
        public final Builder defaultTargetCapacityType(String defaultTargetCapacityType) {
            this.defaultTargetCapacityType = defaultTargetCapacityType;
            return this;
        }

        @Override
        public final Builder defaultTargetCapacityType(DefaultTargetCapacityType defaultTargetCapacityType) {
            this.defaultTargetCapacityType(defaultTargetCapacityType == null ? null : defaultTargetCapacityType.toString());
            return this;
        }

        public final String getTargetCapacityUnitType() {
            return targetCapacityUnitType;
        }

        public final void setTargetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
        }

        @Override
        public final Builder targetCapacityUnitType(String targetCapacityUnitType) {
            this.targetCapacityUnitType = targetCapacityUnitType;
            return this;
        }

        @Override
        public final Builder targetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType) {
            this.targetCapacityUnitType(targetCapacityUnitType == null ? null : targetCapacityUnitType.toString());
            return this;
        }

        @Override
        public TargetCapacitySpecificationRequest build() {
            return new TargetCapacitySpecificationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
