/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the GPU accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GpuInfo implements SdkPojo, Serializable, ToCopyableBuilder<GpuInfo.Builder, GpuInfo> {
    private static final SdkField<List<GpuDeviceInfo>> GPUS_FIELD = SdkField
            .<List<GpuDeviceInfo>> builder(MarshallingType.LIST)
            .memberName("Gpus")
            .getter(getter(GpuInfo::gpus))
            .setter(setter(Builder::gpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gpus")
                    .unmarshallLocationName("gpus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<GpuDeviceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(GpuDeviceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TOTAL_GPU_MEMORY_IN_MIB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalGpuMemoryInMiB")
            .getter(getter(GpuInfo::totalGpuMemoryInMiB))
            .setter(setter(Builder::totalGpuMemoryInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalGpuMemoryInMiB")
                    .unmarshallLocationName("totalGpuMemoryInMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GPUS_FIELD,
            TOTAL_GPU_MEMORY_IN_MIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GpuDeviceInfo> gpus;

    private final Integer totalGpuMemoryInMiB;

    private GpuInfo(BuilderImpl builder) {
        this.gpus = builder.gpus;
        this.totalGpuMemoryInMiB = builder.totalGpuMemoryInMiB;
    }

    /**
     * For responses, this returns true if the service returned a value for the Gpus property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasGpus() {
        return gpus != null && !(gpus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the GPU accelerators for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGpus} method.
     * </p>
     * 
     * @return Describes the GPU accelerators for the instance type.
     */
    public final List<GpuDeviceInfo> gpus() {
        return gpus;
    }

    /**
     * <p>
     * The total size of the memory for the GPU accelerators for the instance type, in MiB.
     * </p>
     * 
     * @return The total size of the memory for the GPU accelerators for the instance type, in MiB.
     */
    public final Integer totalGpuMemoryInMiB() {
        return totalGpuMemoryInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGpus() ? gpus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalGpuMemoryInMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuInfo)) {
            return false;
        }
        GpuInfo other = (GpuInfo) obj;
        return hasGpus() == other.hasGpus() && Objects.equals(gpus(), other.gpus())
                && Objects.equals(totalGpuMemoryInMiB(), other.totalGpuMemoryInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GpuInfo").add("Gpus", hasGpus() ? gpus() : null)
                .add("TotalGpuMemoryInMiB", totalGpuMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gpus":
            return Optional.ofNullable(clazz.cast(gpus()));
        case "TotalGpuMemoryInMiB":
            return Optional.ofNullable(clazz.cast(totalGpuMemoryInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Gpus", GPUS_FIELD);
        map.put("TotalGpuMemoryInMiB", TOTAL_GPU_MEMORY_IN_MIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GpuInfo, T> g) {
        return obj -> g.apply((GpuInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GpuInfo> {
        /**
         * <p>
         * Describes the GPU accelerators for the instance type.
         * </p>
         * 
         * @param gpus
         *        Describes the GPU accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpus(Collection<GpuDeviceInfo> gpus);

        /**
         * <p>
         * Describes the GPU accelerators for the instance type.
         * </p>
         * 
         * @param gpus
         *        Describes the GPU accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpus(GpuDeviceInfo... gpus);

        /**
         * <p>
         * Describes the GPU accelerators for the instance type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.GpuDeviceInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.GpuDeviceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.GpuDeviceInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #gpus(List<GpuDeviceInfo>)}.
         * 
         * @param gpus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.GpuDeviceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gpus(java.util.Collection<GpuDeviceInfo>)
         */
        Builder gpus(Consumer<GpuDeviceInfo.Builder>... gpus);

        /**
         * <p>
         * The total size of the memory for the GPU accelerators for the instance type, in MiB.
         * </p>
         * 
         * @param totalGpuMemoryInMiB
         *        The total size of the memory for the GPU accelerators for the instance type, in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalGpuMemoryInMiB(Integer totalGpuMemoryInMiB);
    }

    static final class BuilderImpl implements Builder {
        private List<GpuDeviceInfo> gpus = DefaultSdkAutoConstructList.getInstance();

        private Integer totalGpuMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(GpuInfo model) {
            gpus(model.gpus);
            totalGpuMemoryInMiB(model.totalGpuMemoryInMiB);
        }

        public final List<GpuDeviceInfo.Builder> getGpus() {
            List<GpuDeviceInfo.Builder> result = GpuDeviceInfoListCopier.copyToBuilder(this.gpus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGpus(Collection<GpuDeviceInfo.BuilderImpl> gpus) {
            this.gpus = GpuDeviceInfoListCopier.copyFromBuilder(gpus);
        }

        @Override
        public final Builder gpus(Collection<GpuDeviceInfo> gpus) {
            this.gpus = GpuDeviceInfoListCopier.copy(gpus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gpus(GpuDeviceInfo... gpus) {
            gpus(Arrays.asList(gpus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gpus(Consumer<GpuDeviceInfo.Builder>... gpus) {
            gpus(Stream.of(gpus).map(c -> GpuDeviceInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalGpuMemoryInMiB() {
            return totalGpuMemoryInMiB;
        }

        public final void setTotalGpuMemoryInMiB(Integer totalGpuMemoryInMiB) {
            this.totalGpuMemoryInMiB = totalGpuMemoryInMiB;
        }

        @Override
        public final Builder totalGpuMemoryInMiB(Integer totalGpuMemoryInMiB) {
            this.totalGpuMemoryInMiB = totalGpuMemoryInMiB;
            return this;
        }

        @Override
        public GpuInfo build() {
            return new GpuInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
