/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRouteServerAssociationsResponse extends Ec2Response implements
        ToCopyableBuilder<GetRouteServerAssociationsResponse.Builder, GetRouteServerAssociationsResponse> {
    private static final SdkField<List<RouteServerAssociation>> ROUTE_SERVER_ASSOCIATIONS_FIELD = SdkField
            .<List<RouteServerAssociation>> builder(MarshallingType.LIST)
            .memberName("RouteServerAssociations")
            .getter(getter(GetRouteServerAssociationsResponse::routeServerAssociations))
            .setter(setter(Builder::routeServerAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerAssociationSet")
                    .unmarshallLocationName("routeServerAssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RouteServerAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteServerAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROUTE_SERVER_ASSOCIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RouteServerAssociation> routeServerAssociations;

    private GetRouteServerAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerAssociations = builder.routeServerAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteServerAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRouteServerAssociations() {
        return routeServerAssociations != null && !(routeServerAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the associations for the specified route server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteServerAssociations} method.
     * </p>
     * 
     * @return Information about the associations for the specified route server.
     */
    public final List<RouteServerAssociation> routeServerAssociations() {
        return routeServerAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteServerAssociations() ? routeServerAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteServerAssociationsResponse)) {
            return false;
        }
        GetRouteServerAssociationsResponse other = (GetRouteServerAssociationsResponse) obj;
        return hasRouteServerAssociations() == other.hasRouteServerAssociations()
                && Objects.equals(routeServerAssociations(), other.routeServerAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRouteServerAssociationsResponse")
                .add("RouteServerAssociations", hasRouteServerAssociations() ? routeServerAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerAssociations":
            return Optional.ofNullable(clazz.cast(routeServerAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerAssociationSet", ROUTE_SERVER_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRouteServerAssociationsResponse, T> g) {
        return obj -> g.apply((GetRouteServerAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetRouteServerAssociationsResponse> {
        /**
         * <p>
         * Information about the associations for the specified route server.
         * </p>
         * 
         * @param routeServerAssociations
         *        Information about the associations for the specified route server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerAssociations(Collection<RouteServerAssociation> routeServerAssociations);

        /**
         * <p>
         * Information about the associations for the specified route server.
         * </p>
         * 
         * @param routeServerAssociations
         *        Information about the associations for the specified route server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerAssociations(RouteServerAssociation... routeServerAssociations);

        /**
         * <p>
         * Information about the associations for the specified route server.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerAssociation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.RouteServerAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #routeServerAssociations(List<RouteServerAssociation>)}.
         * 
         * @param routeServerAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RouteServerAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServerAssociations(java.util.Collection<RouteServerAssociation>)
         */
        Builder routeServerAssociations(Consumer<RouteServerAssociation.Builder>... routeServerAssociations);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<RouteServerAssociation> routeServerAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteServerAssociationsResponse model) {
            super(model);
            routeServerAssociations(model.routeServerAssociations);
        }

        public final List<RouteServerAssociation.Builder> getRouteServerAssociations() {
            List<RouteServerAssociation.Builder> result = RouteServerAssociationsListCopier
                    .copyToBuilder(this.routeServerAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteServerAssociations(Collection<RouteServerAssociation.BuilderImpl> routeServerAssociations) {
            this.routeServerAssociations = RouteServerAssociationsListCopier.copyFromBuilder(routeServerAssociations);
        }

        @Override
        public final Builder routeServerAssociations(Collection<RouteServerAssociation> routeServerAssociations) {
            this.routeServerAssociations = RouteServerAssociationsListCopier.copy(routeServerAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerAssociations(RouteServerAssociation... routeServerAssociations) {
            routeServerAssociations(Arrays.asList(routeServerAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerAssociations(Consumer<RouteServerAssociation.Builder>... routeServerAssociations) {
            routeServerAssociations(Stream.of(routeServerAssociations)
                    .map(c -> RouteServerAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRouteServerAssociationsResponse build() {
            return new GetRouteServerAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
