/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableFastSnapshotRestoresRequest extends Ec2Request implements
        ToCopyableBuilder<EnableFastSnapshotRestoresRequest.Builder, EnableFastSnapshotRestoresRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(EnableFastSnapshotRestoresRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("AvailabilityZone").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone")
                                                    .build()).build()).build()).build();

    private static final SdkField<List<String>> SOURCE_SNAPSHOT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceSnapshotIds")
            .getter(getter(EnableFastSnapshotRestoresRequest::sourceSnapshotIds))
            .setter(setter(Builder::sourceSnapshotIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSnapshotId")
                    .unmarshallLocationName("SourceSnapshotId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotId").unmarshallLocationName("SnapshotId").build())
                                            .build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(EnableFastSnapshotRestoresRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            SOURCE_SNAPSHOT_IDS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> availabilityZones;

    private final List<String> sourceSnapshotIds;

    private final Boolean dryRun;

    private EnableFastSnapshotRestoresRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.sourceSnapshotIds = builder.sourceSnapshotIds;
        this.dryRun = builder.dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more Availability Zones. For example, <code>us-east-2a</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return One or more Availability Zones. For example, <code>us-east-2a</code>.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceSnapshotIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceSnapshotIds() {
        return sourceSnapshotIds != null && !(sourceSnapshotIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a snapshot
     * that was shared with you from another Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceSnapshotIds} method.
     * </p>
     * 
     * @return The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
     *         snapshot that was shared with you from another Amazon Web Services account.
     */
    public final List<String> sourceSnapshotIds() {
        return sourceSnapshotIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceSnapshotIds() ? sourceSnapshotIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoresRequest)) {
            return false;
        }
        EnableFastSnapshotRestoresRequest other = (EnableFastSnapshotRestoresRequest) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && hasSourceSnapshotIds() == other.hasSourceSnapshotIds()
                && Objects.equals(sourceSnapshotIds(), other.sourceSnapshotIds()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableFastSnapshotRestoresRequest")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("SourceSnapshotIds", hasSourceSnapshotIds() ? sourceSnapshotIds() : null).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "SourceSnapshotIds":
            return Optional.ofNullable(clazz.cast(sourceSnapshotIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZone", AVAILABILITY_ZONES_FIELD);
        map.put("SourceSnapshotId", SOURCE_SNAPSHOT_IDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableFastSnapshotRestoresRequest, T> g) {
        return obj -> g.apply((EnableFastSnapshotRestoresRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableFastSnapshotRestoresRequest> {
        /**
         * <p>
         * One or more Availability Zones. For example, <code>us-east-2a</code>.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones. For example, <code>us-east-2a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones. For example, <code>us-east-2a</code>.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones. For example, <code>us-east-2a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         * snapshot that was shared with you from another Amazon Web Services account.
         * </p>
         * 
         * @param sourceSnapshotIds
         *        The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         *        snapshot that was shared with you from another Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotIds(Collection<String> sourceSnapshotIds);

        /**
         * <p>
         * The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         * snapshot that was shared with you from another Amazon Web Services account.
         * </p>
         * 
         * @param sourceSnapshotIds
         *        The IDs of one or more snapshots. For example, <code>snap-1234567890abcdef0</code>. You can specify a
         *        snapshot that was shared with you from another Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotIds(String... sourceSnapshotIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourceSnapshotIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastSnapshotRestoresRequest model) {
            super(model);
            availabilityZones(model.availabilityZones);
            sourceSnapshotIds(model.sourceSnapshotIds);
            dryRun(model.dryRun);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneStringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getSourceSnapshotIds() {
            if (sourceSnapshotIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceSnapshotIds;
        }

        public final void setSourceSnapshotIds(Collection<String> sourceSnapshotIds) {
            this.sourceSnapshotIds = SnapshotIdStringListCopier.copy(sourceSnapshotIds);
        }

        @Override
        public final Builder sourceSnapshotIds(Collection<String> sourceSnapshotIds) {
            this.sourceSnapshotIds = SnapshotIdStringListCopier.copy(sourceSnapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSnapshotIds(String... sourceSnapshotIds) {
            sourceSnapshotIds(Arrays.asList(sourceSnapshotIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableFastSnapshotRestoresRequest build() {
            return new EnableFastSnapshotRestoresRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
