/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotAttributeResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSnapshotAttributeResponse.Builder, DescribeSnapshotAttributeResponse> {
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .memberName("ProductCodes")
            .getter(getter(DescribeSnapshotAttributeResponse::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(DescribeSnapshotAttributeResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<List<CreateVolumePermission>> CREATE_VOLUME_PERMISSIONS_FIELD = SdkField
            .<List<CreateVolumePermission>> builder(MarshallingType.LIST)
            .memberName("CreateVolumePermissions")
            .getter(getter(DescribeSnapshotAttributeResponse::createVolumePermissions))
            .setter(setter(Builder::createVolumePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateVolumePermission")
                    .unmarshallLocationName("createVolumePermission").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CreateVolumePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateVolumePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODES_FIELD,
            SNAPSHOT_ID_FIELD, CREATE_VOLUME_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ProductCode> productCodes;

    private final String snapshotId;

    private final List<CreateVolumePermission> createVolumePermissions;

    private DescribeSnapshotAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.productCodes = builder.productCodes;
        this.snapshotId = builder.snapshotId;
        this.createVolumePermissions = builder.createVolumePermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductCodes() {
        return productCodes != null && !(productCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductCodes} method.
     * </p>
     * 
     * @return The product codes.
     */
    public final List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The ID of the EBS snapshot.
     * </p>
     * 
     * @return The ID of the EBS snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreateVolumePermissions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreateVolumePermissions() {
        return createVolumePermissions != null && !(createVolumePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The users and groups that have the permissions for creating volumes from the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreateVolumePermissions} method.
     * </p>
     * 
     * @return The users and groups that have the permissions for creating volumes from the snapshot.
     */
    public final List<CreateVolumePermission> createVolumePermissions() {
        return createVolumePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProductCodes() ? productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCreateVolumePermissions() ? createVolumePermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotAttributeResponse)) {
            return false;
        }
        DescribeSnapshotAttributeResponse other = (DescribeSnapshotAttributeResponse) obj;
        return hasProductCodes() == other.hasProductCodes() && Objects.equals(productCodes(), other.productCodes())
                && Objects.equals(snapshotId(), other.snapshotId())
                && hasCreateVolumePermissions() == other.hasCreateVolumePermissions()
                && Objects.equals(createVolumePermissions(), other.createVolumePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotAttributeResponse")
                .add("ProductCodes", hasProductCodes() ? productCodes() : null).add("SnapshotId", snapshotId())
                .add("CreateVolumePermissions", hasCreateVolumePermissions() ? createVolumePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "CreateVolumePermissions":
            return Optional.ofNullable(clazz.cast(createVolumePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProductCodes", PRODUCT_CODES_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("CreateVolumePermission", CREATE_VOLUME_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotAttributeResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ProductCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ProductCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(java.util.Collection<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The ID of the EBS snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The users and groups that have the permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        The users and groups that have the permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions);

        /**
         * <p>
         * The users and groups that have the permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        The users and groups that have the permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions);

        /**
         * <p>
         * The users and groups that have the permissions for creating volumes from the snapshot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CreateVolumePermission.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.CreateVolumePermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CreateVolumePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #createVolumePermissions(List<CreateVolumePermission>)}.
         * 
         * @param createVolumePermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CreateVolumePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createVolumePermissions(java.util.Collection<CreateVolumePermission>)
         */
        Builder createVolumePermissions(Consumer<CreateVolumePermission.Builder>... createVolumePermissions);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private String snapshotId;

        private List<CreateVolumePermission> createVolumePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotAttributeResponse model) {
            super(model);
            productCodes(model.productCodes);
            snapshotId(model.snapshotId);
            createVolumePermissions(model.createVolumePermissions);
        }

        public final List<ProductCode.Builder> getProductCodes() {
            List<ProductCode.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final List<CreateVolumePermission.Builder> getCreateVolumePermissions() {
            List<CreateVolumePermission.Builder> result = CreateVolumePermissionListCopier
                    .copyToBuilder(this.createVolumePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreateVolumePermissions(Collection<CreateVolumePermission.BuilderImpl> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copyFromBuilder(createVolumePermissions);
        }

        @Override
        public final Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions) {
            createVolumePermissions(Arrays.asList(createVolumePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(Consumer<CreateVolumePermission.Builder>... createVolumePermissions) {
            createVolumePermissions(Stream.of(createVolumePermissions)
                    .map(c -> CreateVolumePermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSnapshotAttributeResponse build() {
            return new DescribeSnapshotAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
