/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a supported Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedRegionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedRegionDetail.Builder, SupportedRegionDetail> {
    private static final SdkField<String> REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Region")
            .getter(getter(SupportedRegionDetail::region))
            .setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region")
                    .unmarshallLocationName("region").build()).build();

    private static final SdkField<String> SERVICE_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceState")
            .getter(getter(SupportedRegionDetail::serviceState))
            .setter(setter(Builder::serviceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceState")
                    .unmarshallLocationName("serviceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            SERVICE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String serviceState;

    private SupportedRegionDetail(BuilderImpl builder) {
        this.region = builder.region;
        this.serviceState = builder.serviceState;
    }

    /**
     * <p>
     * The Region code.
     * </p>
     * 
     * @return The Region code.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The service state. The possible values are <code>Pending</code>, <code>Available</code>, <code>Deleting</code>,
     * <code>Deleted</code>, <code>Failed</code>, and <code>Closed</code>.
     * </p>
     * 
     * @return The service state. The possible values are <code>Pending</code>, <code>Available</code>,
     *         <code>Deleting</code>, <code>Deleted</code>, <code>Failed</code>, and <code>Closed</code>.
     */
    public final String serviceState() {
        return serviceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(serviceState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedRegionDetail)) {
            return false;
        }
        SupportedRegionDetail other = (SupportedRegionDetail) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(serviceState(), other.serviceState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedRegionDetail").add("Region", region()).add("ServiceState", serviceState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ServiceState":
            return Optional.ofNullable(clazz.cast(serviceState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Region", REGION_FIELD);
        map.put("ServiceState", SERVICE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedRegionDetail, T> g) {
        return obj -> g.apply((SupportedRegionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedRegionDetail> {
        /**
         * <p>
         * The Region code.
         * </p>
         * 
         * @param region
         *        The Region code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The service state. The possible values are <code>Pending</code>, <code>Available</code>,
         * <code>Deleting</code>, <code>Deleted</code>, <code>Failed</code>, and <code>Closed</code>.
         * </p>
         * 
         * @param serviceState
         *        The service state. The possible values are <code>Pending</code>, <code>Available</code>,
         *        <code>Deleting</code>, <code>Deleted</code>, <code>Failed</code>, and <code>Closed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceState(String serviceState);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String serviceState;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedRegionDetail model) {
            region(model.region);
            serviceState(model.serviceState);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getServiceState() {
            return serviceState;
        }

        public final void setServiceState(String serviceState) {
            this.serviceState = serviceState;
        }

        @Override
        public final Builder serviceState(String serviceState) {
            this.serviceState = serviceState;
            return this;
        }

        @Override
        public SupportedRegionDetail build() {
            return new SupportedRegionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
