/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network access control (ACL) rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisAclRule implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisAclRule.Builder, AnalysisAclRule> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(AnalysisAclRule::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("cidr").build()).build();

    private static final SdkField<Boolean> EGRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Egress")
            .getter(getter(AnalysisAclRule::egress))
            .setter(setter(Builder::egress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress")
                    .unmarshallLocationName("egress").build()).build();

    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField
            .<PortRange> builder(MarshallingType.SDK_POJO)
            .memberName("PortRange")
            .getter(getter(AnalysisAclRule::portRange))
            .setter(setter(Builder::portRange))
            .constructor(PortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange")
                    .unmarshallLocationName("portRange").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(AnalysisAclRule::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleAction")
            .getter(getter(AnalysisAclRule::ruleAction))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("ruleAction").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleNumber")
            .getter(getter(AnalysisAclRule::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("ruleNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, EGRESS_FIELD,
            PORT_RANGE_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD, RULE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final Boolean egress;

    private final PortRange portRange;

    private final String protocol;

    private final String ruleAction;

    private final Integer ruleNumber;

    private AnalysisAclRule(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.egress = builder.egress;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * Indicates whether the rule is an outbound rule.
     * </p>
     * 
     * @return Indicates whether the rule is an outbound rule.
     */
    public final Boolean egress() {
        return egress;
    }

    /**
     * <p>
     * The range of ports.
     * </p>
     * 
     * @return The range of ports.
     */
    public final PortRange portRange() {
        return portRange;
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * 
     * @return The protocol.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * Indicates whether to allow or deny traffic that matches the rule.
     * </p>
     * 
     * @return Indicates whether to allow or deny traffic that matches the rule.
     */
    public final String ruleAction() {
        return ruleAction;
    }

    /**
     * <p>
     * The rule number.
     * </p>
     * 
     * @return The rule number.
     */
    public final Integer ruleNumber() {
        return ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(egress());
        hashCode = 31 * hashCode + Objects.hashCode(portRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(ruleAction());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisAclRule)) {
            return false;
        }
        AnalysisAclRule other = (AnalysisAclRule) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(egress(), other.egress())
                && Objects.equals(portRange(), other.portRange()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(ruleAction(), other.ruleAction()) && Objects.equals(ruleNumber(), other.ruleNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisAclRule").add("Cidr", cidr()).add("Egress", egress()).add("PortRange", portRange())
                .add("Protocol", protocol()).add("RuleAction", ruleAction()).add("RuleNumber", ruleNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "Egress":
            return Optional.ofNullable(clazz.cast(egress()));
        case "PortRange":
            return Optional.ofNullable(clazz.cast(portRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleAction()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cidr", CIDR_FIELD);
        map.put("Egress", EGRESS_FIELD);
        map.put("PortRange", PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("RuleAction", RULE_ACTION_FIELD);
        map.put("RuleNumber", RULE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisAclRule, T> g) {
        return obj -> g.apply((AnalysisAclRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisAclRule> {
        /**
         * <p>
         * The IPv4 address range, in CIDR notation.
         * </p>
         * 
         * @param cidr
         *        The IPv4 address range, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * Indicates whether the rule is an outbound rule.
         * </p>
         * 
         * @param egress
         *        Indicates whether the rule is an outbound rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        /**
         * <p>
         * The range of ports.
         * </p>
         * 
         * @param portRange
         *        The range of ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRange(PortRange portRange);

        /**
         * <p>
         * The range of ports.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortRange.Builder} avoiding the need to
         * create one manually via {@link PortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortRange.Builder#build()} is called immediately and its result
         * is passed to {@link #portRange(PortRange)}.
         * 
         * @param portRange
         *        a consumer that will call methods on {@link PortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRange(PortRange)
         */
        default Builder portRange(Consumer<PortRange.Builder> portRange) {
            return portRange(PortRange.builder().applyMutation(portRange).build());
        }

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * Indicates whether to allow or deny traffic that matches the rule.
         * </p>
         * 
         * @param ruleAction
         *        Indicates whether to allow or deny traffic that matches the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * The rule number.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private Boolean egress;

        private PortRange portRange;

        private String protocol;

        private String ruleAction;

        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisAclRule model) {
            cidr(model.cidr);
            egress(model.egress);
            portRange(model.portRange);
            protocol(model.protocol);
            ruleAction(model.ruleAction);
            ruleNumber(model.ruleNumber);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final Boolean getEgress() {
            return egress;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final PortRange.Builder getPortRange() {
            return portRange != null ? portRange.toBuilder() : null;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        @Override
        public AnalysisAclRule build() {
            return new AnalysisAclRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
