/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTrafficMirrorFilterNetworkServicesRequest extends Ec2Request
        implements
        ToCopyableBuilder<ModifyTrafficMirrorFilterNetworkServicesRequest.Builder, ModifyTrafficMirrorFilterNetworkServicesRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterId")
            .getter(getter(ModifyTrafficMirrorFilterNetworkServicesRequest::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("TrafficMirrorFilterId").build()).build();

    private static final SdkField<List<String>> ADD_NETWORK_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddNetworkServices")
            .getter(getter(ModifyTrafficMirrorFilterNetworkServicesRequest::addNetworkServicesAsStrings))
            .setter(setter(Builder::addNetworkServicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddNetworkService")
                    .unmarshallLocationName("AddNetworkService").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> REMOVE_NETWORK_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveNetworkServices")
            .getter(getter(ModifyTrafficMirrorFilterNetworkServicesRequest::removeNetworkServicesAsStrings))
            .setter(setter(Builder::removeNetworkServicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveNetworkService")
                    .unmarshallLocationName("RemoveNetworkService").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyTrafficMirrorFilterNetworkServicesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_ID_FIELD, ADD_NETWORK_SERVICES_FIELD, REMOVE_NETWORK_SERVICES_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trafficMirrorFilterId;

    private final List<String> addNetworkServices;

    private final List<String> removeNetworkServices;

    private final Boolean dryRun;

    private ModifyTrafficMirrorFilterNetworkServicesRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.addNetworkServices = builder.addNetworkServices;
        this.removeNetworkServices = builder.removeNetworkServices;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter.
     */
    public final String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddNetworkServices} method.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you want to mirror.
     */
    public final List<TrafficMirrorNetworkService> addNetworkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(addNetworkServices);
    }

    /**
     * For responses, this returns true if the service returned a value for the AddNetworkServices property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddNetworkServices() {
        return addNetworkServices != null && !(addNetworkServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddNetworkServices} method.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you want to mirror.
     */
    public final List<String> addNetworkServicesAsStrings() {
        return addNetworkServices;
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you no longer want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveNetworkServices} method.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you no longer want to mirror.
     */
    public final List<TrafficMirrorNetworkService> removeNetworkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(removeNetworkServices);
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveNetworkServices property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRemoveNetworkServices() {
        return removeNetworkServices != null && !(removeNetworkServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network service, for example Amazon DNS, that you no longer want to mirror.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveNetworkServices} method.
     * </p>
     * 
     * @return The network service, for example Amazon DNS, that you no longer want to mirror.
     */
    public final List<String> removeNetworkServicesAsStrings() {
        return removeNetworkServices;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddNetworkServices() ? addNetworkServicesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveNetworkServices() ? removeNetworkServicesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorFilterNetworkServicesRequest)) {
            return false;
        }
        ModifyTrafficMirrorFilterNetworkServicesRequest other = (ModifyTrafficMirrorFilterNetworkServicesRequest) obj;
        return Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && hasAddNetworkServices() == other.hasAddNetworkServices()
                && Objects.equals(addNetworkServicesAsStrings(), other.addNetworkServicesAsStrings())
                && hasRemoveNetworkServices() == other.hasRemoveNetworkServices()
                && Objects.equals(removeNetworkServicesAsStrings(), other.removeNetworkServicesAsStrings())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTrafficMirrorFilterNetworkServicesRequest")
                .add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("AddNetworkServices", hasAddNetworkServices() ? addNetworkServicesAsStrings() : null)
                .add("RemoveNetworkServices", hasRemoveNetworkServices() ? removeNetworkServicesAsStrings() : null)
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "AddNetworkServices":
            return Optional.ofNullable(clazz.cast(addNetworkServicesAsStrings()));
        case "RemoveNetworkServices":
            return Optional.ofNullable(clazz.cast(removeNetworkServicesAsStrings()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficMirrorFilterId", TRAFFIC_MIRROR_FILTER_ID_FIELD);
        map.put("AddNetworkService", ADD_NETWORK_SERVICES_FIELD);
        map.put("RemoveNetworkService", REMOVE_NETWORK_SERVICES_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorFilterNetworkServicesRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorFilterNetworkServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyTrafficMirrorFilterNetworkServicesRequest> {
        /**
         * <p>
         * The ID of the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServicesWithStrings(Collection<String> addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServicesWithStrings(String... addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServices(Collection<TrafficMirrorNetworkService> addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you want to mirror.
         * </p>
         * 
         * @param addNetworkServices
         *        The network service, for example Amazon DNS, that you want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addNetworkServices(TrafficMirrorNetworkService... addNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServicesWithStrings(Collection<String> removeNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServicesWithStrings(String... removeNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServices(Collection<TrafficMirrorNetworkService> removeNetworkServices);

        /**
         * <p>
         * The network service, for example Amazon DNS, that you no longer want to mirror.
         * </p>
         * 
         * @param removeNetworkServices
         *        The network service, for example Amazon DNS, that you no longer want to mirror.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeNetworkServices(TrafficMirrorNetworkService... removeNetworkServices);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trafficMirrorFilterId;

        private List<String> addNetworkServices = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeNetworkServices = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorFilterNetworkServicesRequest model) {
            super(model);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            addNetworkServicesWithStrings(model.addNetworkServices);
            removeNetworkServicesWithStrings(model.removeNetworkServices);
            dryRun(model.dryRun);
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final Collection<String> getAddNetworkServices() {
            if (addNetworkServices instanceof SdkAutoConstructList) {
                return null;
            }
            return addNetworkServices;
        }

        public final void setAddNetworkServices(Collection<String> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(addNetworkServices);
        }

        @Override
        public final Builder addNetworkServicesWithStrings(Collection<String> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(addNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkServicesWithStrings(String... addNetworkServices) {
            addNetworkServicesWithStrings(Arrays.asList(addNetworkServices));
            return this;
        }

        @Override
        public final Builder addNetworkServices(Collection<TrafficMirrorNetworkService> addNetworkServices) {
            this.addNetworkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(addNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addNetworkServices(TrafficMirrorNetworkService... addNetworkServices) {
            addNetworkServices(Arrays.asList(addNetworkServices));
            return this;
        }

        public final Collection<String> getRemoveNetworkServices() {
            if (removeNetworkServices instanceof SdkAutoConstructList) {
                return null;
            }
            return removeNetworkServices;
        }

        public final void setRemoveNetworkServices(Collection<String> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(removeNetworkServices);
        }

        @Override
        public final Builder removeNetworkServicesWithStrings(Collection<String> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copy(removeNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkServicesWithStrings(String... removeNetworkServices) {
            removeNetworkServicesWithStrings(Arrays.asList(removeNetworkServices));
            return this;
        }

        @Override
        public final Builder removeNetworkServices(Collection<TrafficMirrorNetworkService> removeNetworkServices) {
            this.removeNetworkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(removeNetworkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeNetworkServices(TrafficMirrorNetworkService... removeNetworkServices) {
            removeNetworkServices(Arrays.asList(removeNetworkServices));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorFilterNetworkServicesRequest build() {
            return new ModifyTrafficMirrorFilterNetworkServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
