/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class InstanceIpv6AddressListCopier {
    static List<InstanceIpv6Address> copy(Collection<? extends InstanceIpv6Address> instanceIpv6AddressListParam) {
        List<InstanceIpv6Address> list;
        if (instanceIpv6AddressListParam == null || instanceIpv6AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InstanceIpv6Address> modifiableList = new ArrayList<>(instanceIpv6AddressListParam.size());
            instanceIpv6AddressListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InstanceIpv6Address> copyFromBuilder(
            Collection<? extends InstanceIpv6Address.Builder> instanceIpv6AddressListParam) {
        List<InstanceIpv6Address> list;
        if (instanceIpv6AddressListParam == null || instanceIpv6AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InstanceIpv6Address> modifiableList = new ArrayList<>(instanceIpv6AddressListParam.size());
            instanceIpv6AddressListParam.forEach(entry -> {
                InstanceIpv6Address member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InstanceIpv6Address.Builder> copyToBuilder(Collection<? extends InstanceIpv6Address> instanceIpv6AddressListParam) {
        List<InstanceIpv6Address.Builder> list;
        if (instanceIpv6AddressListParam == null || instanceIpv6AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InstanceIpv6Address.Builder> modifiableList = new ArrayList<>(instanceIpv6AddressListParam.size());
            instanceIpv6AddressListParam.forEach(entry -> {
                InstanceIpv6Address.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
