/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceMetadataDefaultsResponse extends Ec2Response implements
        ToCopyableBuilder<GetInstanceMetadataDefaultsResponse.Builder, GetInstanceMetadataDefaultsResponse> {
    private static final SdkField<InstanceMetadataDefaultsResponse> ACCOUNT_LEVEL_FIELD = SdkField
            .<InstanceMetadataDefaultsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("AccountLevel")
            .getter(getter(GetInstanceMetadataDefaultsResponse::accountLevel))
            .setter(setter(Builder::accountLevel))
            .constructor(InstanceMetadataDefaultsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLevel")
                    .unmarshallLocationName("accountLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InstanceMetadataDefaultsResponse accountLevel;

    private GetInstanceMetadataDefaultsResponse(BuilderImpl builder) {
        super(builder);
        this.accountLevel = builder.accountLevel;
    }

    /**
     * <p>
     * The account-level default IMDS settings.
     * </p>
     * 
     * @return The account-level default IMDS settings.
     */
    public final InstanceMetadataDefaultsResponse accountLevel() {
        return accountLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetadataDefaultsResponse)) {
            return false;
        }
        GetInstanceMetadataDefaultsResponse other = (GetInstanceMetadataDefaultsResponse) obj;
        return Objects.equals(accountLevel(), other.accountLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceMetadataDefaultsResponse").add("AccountLevel", accountLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountLevel":
            return Optional.ofNullable(clazz.cast(accountLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountLevel", ACCOUNT_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceMetadataDefaultsResponse, T> g) {
        return obj -> g.apply((GetInstanceMetadataDefaultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceMetadataDefaultsResponse> {
        /**
         * <p>
         * The account-level default IMDS settings.
         * </p>
         * 
         * @param accountLevel
         *        The account-level default IMDS settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountLevel(InstanceMetadataDefaultsResponse accountLevel);

        /**
         * <p>
         * The account-level default IMDS settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMetadataDefaultsResponse.Builder}
         * avoiding the need to create one manually via {@link InstanceMetadataDefaultsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataDefaultsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #accountLevel(InstanceMetadataDefaultsResponse)}.
         * 
         * @param accountLevel
         *        a consumer that will call methods on {@link InstanceMetadataDefaultsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountLevel(InstanceMetadataDefaultsResponse)
         */
        default Builder accountLevel(Consumer<InstanceMetadataDefaultsResponse.Builder> accountLevel) {
            return accountLevel(InstanceMetadataDefaultsResponse.builder().applyMutation(accountLevel).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private InstanceMetadataDefaultsResponse accountLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetadataDefaultsResponse model) {
            super(model);
            accountLevel(model.accountLevel);
        }

        public final InstanceMetadataDefaultsResponse.Builder getAccountLevel() {
            return accountLevel != null ? accountLevel.toBuilder() : null;
        }

        public final void setAccountLevel(InstanceMetadataDefaultsResponse.BuilderImpl accountLevel) {
            this.accountLevel = accountLevel != null ? accountLevel.build() : null;
        }

        @Override
        public final Builder accountLevel(InstanceMetadataDefaultsResponse accountLevel) {
            this.accountLevel = accountLevel;
            return this;
        }

        @Override
        public GetInstanceMetadataDefaultsResponse build() {
            return new GetInstanceMetadataDefaultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
