/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes overrides for a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetLaunchTemplateOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetLaunchTemplateOverrides.Builder, FleetLaunchTemplateOverrides> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(FleetLaunchTemplateOverrides::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> MAX_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxPrice")
            .getter(getter(FleetLaunchTemplateOverrides::maxPrice))
            .setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice")
                    .unmarshallLocationName("maxPrice").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubnetId")
            .getter(getter(FleetLaunchTemplateOverrides::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId")
                    .unmarshallLocationName("subnetId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(FleetLaunchTemplateOverrides::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Double> WEIGHTED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("WeightedCapacity")
            .getter(getter(FleetLaunchTemplateOverrides::weightedCapacity))
            .setter(setter(Builder::weightedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity")
                    .unmarshallLocationName("weightedCapacity").build()).build();

    private static final SdkField<Double> PRIORITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("Priority")
            .getter(getter(FleetLaunchTemplateOverrides::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority")
                    .unmarshallLocationName("priority").build()).build();

    private static final SdkField<PlacementResponse> PLACEMENT_FIELD = SdkField
            .<PlacementResponse> builder(MarshallingType.SDK_POJO)
            .memberName("Placement")
            .getter(getter(FleetLaunchTemplateOverrides::placement))
            .setter(setter(Builder::placement))
            .constructor(PlacementResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement")
                    .unmarshallLocationName("placement").build()).build();

    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceRequirements")
            .getter(getter(FleetLaunchTemplateOverrides::instanceRequirements))
            .setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements")
                    .unmarshallLocationName("instanceRequirements").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(FleetLaunchTemplateOverrides::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            MAX_PRICE_FIELD, SUBNET_ID_FIELD, AVAILABILITY_ZONE_FIELD, WEIGHTED_CAPACITY_FIELD, PRIORITY_FIELD, PLACEMENT_FIELD,
            INSTANCE_REQUIREMENTS_FIELD, IMAGE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String maxPrice;

    private final String subnetId;

    private final String availabilityZone;

    private final Double weightedCapacity;

    private final Double priority;

    private final PlacementResponse placement;

    private final InstanceRequirements instanceRequirements;

    private final String imageId;

    private FleetLaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.maxPrice = builder.maxPrice;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.weightedCapacity = builder.weightedCapacity;
        this.priority = builder.priority;
        this.placement = builder.placement;
        this.instanceRequirements = builder.instanceRequirements;
        this.imageId = builder.imageId;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * <code>mac1.metal</code> is not supported as a launch template override.
     * </p>
     * <note>
     * <p>
     * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.</p>
     *         <p>
     *         <code>mac1.metal</code> is not supported as a launch template override.
     *         </p>
     *         <note>
     *         <p>
     *         If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     *         </p>
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * <code>mac1.metal</code> is not supported as a launch template override.
     * </p>
     * <note>
     * <p>
     * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.</p>
     *         <p>
     *         <code>mac1.metal</code> is not supported as a launch template override.
     *         </p>
     *         <note>
     *         <p>
     *         If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
     *         </p>
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend using this
     * parameter because it can lead to increased interruptions. If you do not specify this parameter, you will pay the
     * current Spot price.
     * </p>
     * <important>
     * <p>
     * If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify
     * this parameter.
     * </p>
     * </important>
     * 
     * @return The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend
     *         using this parameter because it can lead to increased interruptions. If you do not specify this
     *         parameter, you will pay the current Spot price. </p> <important>
     *         <p>
     *         If you specify a maximum price, your instances will be interrupted more frequently than if you do not
     *         specify this parameter.
     *         </p>
     */
    public final String maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * The ID of the subnet in which to launch the instances.
     * </p>
     * 
     * @return The ID of the subnet in which to launch the instances.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The Availability Zone in which to launch the instances.
     * </p>
     * 
     * @return The Availability Zone in which to launch the instances.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of units provided by the specified instance type. These are the same units that you chose to set the
     * target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
     * </p>
     * <p>
     * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to
     * the next whole number. If this value is not specified, the default is 1.
     * </p>
     * <note>
     * <p>
     * When specifying weights, the price used in the <code>lowest-price</code> and
     * <code>price-capacity-optimized</code> allocation strategies is per <i>unit</i> hour (where the instance price is
     * divided by the specified weight). However, if all the specified weights are above the requested
     * <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used is per <i>instance</i>
     * hour.
     * </p>
     * </note>
     * 
     * @return The number of units provided by the specified instance type. These are the same units that you chose to
     *         set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or
     *         I/O.</p>
     *         <p>
     *         If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of
     *         instances to the next whole number. If this value is not specified, the default is 1.
     *         </p>
     *         <note>
     *         <p>
     *         When specifying weights, the price used in the <code>lowest-price</code> and
     *         <code>price-capacity-optimized</code> allocation strategies is per <i>unit</i> hour (where the instance
     *         price is divided by the specified weight). However, if all the specified weights are above the requested
     *         <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used is per
     *         <i>instance</i> hour.
     *         </p>
     */
    public final Double weightedCapacity() {
        return weightedCapacity;
    }

    /**
     * <p>
     * The priority for the launch template override. The highest priority is launched first.
     * </p>
     * <p>
     * If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code>, EC2 Fleet uses priority to
     * determine which launch template override to use first in fulfilling On-Demand capacity.
     * </p>
     * <p>
     * If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code>, EC2 Fleet uses
     * priority on a best-effort basis to determine which launch template override to use in fulfilling Spot capacity,
     * but optimizes for capacity first.
     * </p>
     * <p>
     * Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If no
     * number is set, the override has the lowest priority. You can set the same priority for different launch template
     * overrides.
     * </p>
     * 
     * @return The priority for the launch template override. The highest priority is launched first.</p>
     *         <p>
     *         If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code>, EC2 Fleet uses
     *         priority to determine which launch template override to use first in fulfilling On-Demand capacity.
     *         </p>
     *         <p>
     *         If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code>, EC2
     *         Fleet uses priority on a best-effort basis to determine which launch template override to use in
     *         fulfilling Spot capacity, but optimizes for capacity first.
     *         </p>
     *         <p>
     *         Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority.
     *         If no number is set, the override has the lowest priority. You can set the same priority for different
     *         launch template overrides.
     */
    public final Double priority() {
        return priority;
    }

    /**
     * <p>
     * The location where the instance launched, if applicable.
     * </p>
     * 
     * @return The location where the instance launched, if applicable.
     */
    public final PlacementResponse placement() {
        return placement;
    }

    /**
     * <p>
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance
     * types with those attributes.
     * </p>
     * <note>
     * <p>
     * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
     * </p>
     * </note>
     * 
     * @return The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
     *         instance types with those attributes.</p> <note>
     *         <p>
     *         If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
     *         </p>
     */
    public final InstanceRequirements instanceRequirements() {
        return instanceRequirements;
    }

    /**
     * <p>
     * The ID of the AMI in the format <code>ami-17characters00000</code>.
     * </p>
     * <p>
     * Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The Systems
     * Manager parameter will resolve to an AMI ID on launch.
     * </p>
     * <p>
     * To reference a public parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>public-parameter</i> </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To reference a parameter stored in the same account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-name</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-name:label</i> </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To reference a parameter shared from another Amazon Web Services account:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-ARN</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
     * >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter is only available for fleets of type <code>instant</code>. For fleets of type
     * <code>maintain</code> and <code>request</code>, you must specify the AMI ID in the launch template.
     * </p>
     * </note>
     * 
     * @return The ID of the AMI in the format <code>ami-17characters00000</code>.</p>
     *         <p>
     *         Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The
     *         Systems Manager parameter will resolve to an AMI ID on launch.
     *         </p>
     *         <p>
     *         To reference a public parameter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>public-parameter</i> </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To reference a parameter stored in the same account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-name</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-name:label</i> </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To reference a parameter shared from another Amazon Web Services account:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-ARN</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
     *         >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is only available for fleets of type <code>instant</code>. For fleets of type
     *         <code>maintain</code> and <code>request</code>, you must specify the AMI ID in the launch template.
     *         </p>
     */
    public final String imageId() {
        return imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateOverrides)) {
            return false;
        }
        FleetLaunchTemplateOverrides other = (FleetLaunchTemplateOverrides) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(maxPrice(), other.maxPrice()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(weightedCapacity(), other.weightedCapacity()) && Objects.equals(priority(), other.priority())
                && Objects.equals(placement(), other.placement())
                && Objects.equals(instanceRequirements(), other.instanceRequirements())
                && Objects.equals(imageId(), other.imageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetLaunchTemplateOverrides").add("InstanceType", instanceTypeAsString())
                .add("MaxPrice", maxPrice()).add("SubnetId", subnetId()).add("AvailabilityZone", availabilityZone())
                .add("WeightedCapacity", weightedCapacity()).add("Priority", priority()).add("Placement", placement())
                .add("InstanceRequirements", instanceRequirements()).add("ImageId", imageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "WeightedCapacity":
            return Optional.ofNullable(clazz.cast(weightedCapacity()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("WeightedCapacity", WEIGHTED_CAPACITY_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateOverrides, T> g) {
        return obj -> g.apply((FleetLaunchTemplateOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetLaunchTemplateOverrides> {
        /**
         * <p>
         * The instance type.
         * </p>
         * <p>
         * <code>mac1.metal</code> is not supported as a launch template override.
         * </p>
         * <note>
         * <p>
         * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         * </p>
         * </note>
         * 
         * @param instanceType
         *        The instance type.</p>
         *        <p>
         *        <code>mac1.metal</code> is not supported as a launch template override.
         *        </p>
         *        <note>
         *        <p>
         *        If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         *        </p>
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * <p>
         * <code>mac1.metal</code> is not supported as a launch template override.
         * </p>
         * <note>
         * <p>
         * If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         * </p>
         * </note>
         * 
         * @param instanceType
         *        The instance type.</p>
         *        <p>
         *        <code>mac1.metal</code> is not supported as a launch template override.
         *        </p>
         *        <note>
         *        <p>
         *        If you specify <code>InstanceType</code>, you can't specify <code>InstanceRequirements</code>.
         *        </p>
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend using
         * this parameter because it can lead to increased interruptions. If you do not specify this parameter, you will
         * pay the current Spot price.
         * </p>
         * <important>
         * <p>
         * If you specify a maximum price, your instances will be interrupted more frequently than if you do not specify
         * this parameter.
         * </p>
         * </important>
         * 
         * @param maxPrice
         *        The maximum price per unit hour that you are willing to pay for a Spot Instance. We do not recommend
         *        using this parameter because it can lead to increased interruptions. If you do not specify this
         *        parameter, you will pay the current Spot price. </p> <important>
         *        <p>
         *        If you specify a maximum price, your instances will be interrupted more frequently than if you do not
         *        specify this parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(String maxPrice);

        /**
         * <p>
         * The ID of the subnet in which to launch the instances.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The Availability Zone in which to launch the instances.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to launch the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of units provided by the specified instance type. These are the same units that you chose to set
         * the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
         * </p>
         * <p>
         * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances
         * to the next whole number. If this value is not specified, the default is 1.
         * </p>
         * <note>
         * <p>
         * When specifying weights, the price used in the <code>lowest-price</code> and
         * <code>price-capacity-optimized</code> allocation strategies is per <i>unit</i> hour (where the instance price
         * is divided by the specified weight). However, if all the specified weights are above the requested
         * <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used is per
         * <i>instance</i> hour.
         * </p>
         * </note>
         * 
         * @param weightedCapacity
         *        The number of units provided by the specified instance type. These are the same units that you chose
         *        to set the target capacity in terms of instances, or a performance characteristic such as vCPUs,
         *        memory, or I/O.</p>
         *        <p>
         *        If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of
         *        instances to the next whole number. If this value is not specified, the default is 1.
         *        </p>
         *        <note>
         *        <p>
         *        When specifying weights, the price used in the <code>lowest-price</code> and
         *        <code>price-capacity-optimized</code> allocation strategies is per <i>unit</i> hour (where the
         *        instance price is divided by the specified weight). However, if all the specified weights are above
         *        the requested <code>TargetCapacity</code>, resulting in only 1 instance being launched, the price used
         *        is per <i>instance</i> hour.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(Double weightedCapacity);

        /**
         * <p>
         * The priority for the launch template override. The highest priority is launched first.
         * </p>
         * <p>
         * If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code>, EC2 Fleet uses priority
         * to determine which launch template override to use first in fulfilling On-Demand capacity.
         * </p>
         * <p>
         * If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code>, EC2 Fleet
         * uses priority on a best-effort basis to determine which launch template override to use in fulfilling Spot
         * capacity, but optimizes for capacity first.
         * </p>
         * <p>
         * Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the priority. If
         * no number is set, the override has the lowest priority. You can set the same priority for different launch
         * template overrides.
         * </p>
         * 
         * @param priority
         *        The priority for the launch template override. The highest priority is launched first.</p>
         *        <p>
         *        If the On-Demand <code>AllocationStrategy</code> is set to <code>prioritized</code>, EC2 Fleet uses
         *        priority to determine which launch template override to use first in fulfilling On-Demand capacity.
         *        </p>
         *        <p>
         *        If the Spot <code>AllocationStrategy</code> is set to <code>capacity-optimized-prioritized</code>, EC2
         *        Fleet uses priority on a best-effort basis to determine which launch template override to use in
         *        fulfilling Spot capacity, but optimizes for capacity first.
         *        </p>
         *        <p>
         *        Valid values are whole numbers starting at <code>0</code>. The lower the number, the higher the
         *        priority. If no number is set, the override has the lowest priority. You can set the same priority for
         *        different launch template overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Double priority);

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * 
         * @param placement
         *        The location where the instance launched, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(PlacementResponse placement);

        /**
         * <p>
         * The location where the instance launched, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlacementResponse.Builder} avoiding the
         * need to create one manually via {@link PlacementResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlacementResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #placement(PlacementResponse)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link PlacementResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(PlacementResponse)
         */
        default Builder placement(Consumer<PlacementResponse.Builder> placement) {
            return placement(PlacementResponse.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * <note>
         * <p>
         * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
         * </p>
         * </note>
         * 
         * @param instanceRequirements
         *        The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         *        instance types with those attributes.</p> <note>
         *        <p>
         *        If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirements instanceRequirements);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with those attributes.
         * </p>
         * <note>
         * <p>
         * If you specify <code>InstanceRequirements</code>, you can't specify <code>InstanceType</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link InstanceRequirements.Builder}
         * avoiding the need to create one manually via {@link InstanceRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRequirements.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceRequirements(InstanceRequirements)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirements)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirements.builder().applyMutation(instanceRequirements).build());
        }

        /**
         * <p>
         * The ID of the AMI in the format <code>ami-17characters00000</code>.
         * </p>
         * <p>
         * Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The Systems
         * Manager parameter will resolve to an AMI ID on launch.
         * </p>
         * <p>
         * To reference a public parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>public-parameter</i> </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To reference a parameter stored in the same account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-name</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-name:label</i> </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To reference a parameter shared from another Amazon Web Services account:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-ARN</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
         * >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter is only available for fleets of type <code>instant</code>. For fleets of type
         * <code>maintain</code> and <code>request</code>, you must specify the AMI ID in the launch template.
         * </p>
         * </note>
         * 
         * @param imageId
         *        The ID of the AMI in the format <code>ami-17characters00000</code>.</p>
         *        <p>
         *        Alternatively, you can specify a Systems Manager parameter, using one of the following formats. The
         *        Systems Manager parameter will resolve to an AMI ID on launch.
         *        </p>
         *        <p>
         *        To reference a public parameter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>public-parameter</i> </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To reference a parameter stored in the same account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-name</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-name:version-number</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-name:label</i> </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To reference a parameter shared from another Amazon Web Services account:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-ARN</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-ARN:version-number</i> </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolve:ssm:<i>parameter-ARN:label</i> </code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id"
         *        >Use a Systems Manager parameter instead of an AMI ID</a> in the <i>Amazon EC2 User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is only available for fleets of type <code>instant</code>. For fleets of type
         *        <code>maintain</code> and <code>request</code>, you must specify the AMI ID in the launch template.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String maxPrice;

        private String subnetId;

        private String availabilityZone;

        private Double weightedCapacity;

        private Double priority;

        private PlacementResponse placement;

        private InstanceRequirements instanceRequirements;

        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateOverrides model) {
            instanceType(model.instanceType);
            maxPrice(model.maxPrice);
            subnetId(model.subnetId);
            availabilityZone(model.availabilityZone);
            weightedCapacity(model.weightedCapacity);
            priority(model.priority);
            placement(model.placement);
            instanceRequirements(model.instanceRequirements);
            imageId(model.imageId);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getMaxPrice() {
            return maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Double getWeightedCapacity() {
            return weightedCapacity;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final Double getPriority() {
            return priority;
        }

        public final void setPriority(Double priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Double priority) {
            this.priority = priority;
            return this;
        }

        public final PlacementResponse.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(PlacementResponse.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(PlacementResponse placement) {
            this.placement = placement;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        @Override
        public FleetLaunchTemplateOverrides build() {
            return new FleetLaunchTemplateOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
