/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes Availability Zones, Local Zones, and Wavelength Zones.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OptInStatus")
            .getter(getter(AvailabilityZone::optInStatusAsString))
            .setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus")
                    .unmarshallLocationName("optInStatus").build()).build();

    private static final SdkField<List<AvailabilityZoneMessage>> MESSAGES_FIELD = SdkField
            .<List<AvailabilityZoneMessage>> builder(MarshallingType.LIST)
            .memberName("Messages")
            .getter(getter(AvailabilityZone::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageSet")
                    .unmarshallLocationName("messageSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<AvailabilityZoneMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(AvailabilityZoneMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RegionName")
            .getter(getter(AvailabilityZone::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName")
                    .unmarshallLocationName("regionName").build()).build();

    private static final SdkField<String> ZONE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ZoneName")
            .getter(getter(AvailabilityZone::zoneName))
            .setter(setter(Builder::zoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName")
                    .unmarshallLocationName("zoneName").build()).build();

    private static final SdkField<String> ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ZoneId")
            .getter(getter(AvailabilityZone::zoneId))
            .setter(setter(Builder::zoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneId")
                    .unmarshallLocationName("zoneId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(AvailabilityZone::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkBorderGroup")
            .getter(getter(AvailabilityZone::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup")
                    .unmarshallLocationName("networkBorderGroup").build()).build();

    private static final SdkField<String> ZONE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ZoneType")
            .getter(getter(AvailabilityZone::zoneType))
            .setter(setter(Builder::zoneType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneType")
                    .unmarshallLocationName("zoneType").build()).build();

    private static final SdkField<String> PARENT_ZONE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ParentZoneName")
            .getter(getter(AvailabilityZone::parentZoneName))
            .setter(setter(Builder::parentZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentZoneName")
                    .unmarshallLocationName("parentZoneName").build()).build();

    private static final SdkField<String> PARENT_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ParentZoneId")
            .getter(getter(AvailabilityZone::parentZoneId))
            .setter(setter(Builder::parentZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentZoneId")
                    .unmarshallLocationName("parentZoneId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(AvailabilityZone::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneState")
                    .unmarshallLocationName("zoneState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_IN_STATUS_FIELD,
            MESSAGES_FIELD, REGION_NAME_FIELD, ZONE_NAME_FIELD, ZONE_ID_FIELD, GROUP_NAME_FIELD, NETWORK_BORDER_GROUP_FIELD,
            ZONE_TYPE_FIELD, PARENT_ZONE_NAME_FIELD, PARENT_ZONE_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String optInStatus;

    private final List<AvailabilityZoneMessage> messages;

    private final String regionName;

    private final String zoneName;

    private final String zoneId;

    private final String groupName;

    private final String networkBorderGroup;

    private final String zoneType;

    private final String parentZoneName;

    private final String parentZoneId;

    private final String state;

    private AvailabilityZone(BuilderImpl builder) {
        this.optInStatus = builder.optInStatus;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
        this.zoneId = builder.zoneId;
        this.groupName = builder.groupName;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.zoneType = builder.zoneType;
        this.parentZoneName = builder.parentZoneName;
        this.parentZoneId = builder.parentZoneId;
        this.state = builder.state;
    }

    /**
     * <p>
     * For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.
     * </p>
     * <p>
     * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
     * <code>opted-in</code>, and <code>not-opted-in</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link AvailabilityZoneOptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optInStatusAsString}.
     * </p>
     * 
     * @return For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.</p>
     *         <p>
     *         For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
     *         <code>opted-in</code>, and <code>not-opted-in</code>.
     * @see AvailabilityZoneOptInStatus
     */
    public final AvailabilityZoneOptInStatus optInStatus() {
        return AvailabilityZoneOptInStatus.fromValue(optInStatus);
    }

    /**
     * <p>
     * For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.
     * </p>
     * <p>
     * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
     * <code>opted-in</code>, and <code>not-opted-in</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #optInStatus} will
     * return {@link AvailabilityZoneOptInStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #optInStatusAsString}.
     * </p>
     * 
     * @return For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.</p>
     *         <p>
     *         For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
     *         <code>opted-in</code>, and <code>not-opted-in</code>.
     * @see AvailabilityZoneOptInStatus
     */
    public final String optInStatusAsString() {
        return optInStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
     */
    public final List<AvailabilityZoneMessage> messages() {
        return messages;
    }

    /**
     * <p>
     * The name of the Region.
     * </p>
     * 
     * @return The name of the Region.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The name of the Availability Zone, Local Zone, or Wavelength Zone.
     * </p>
     * 
     * @return The name of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    public final String zoneName() {
        return zoneName;
    }

    /**
     * <p>
     * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
     * </p>
     * 
     * @return The ID of the Availability Zone, Local Zone, or Wavelength Zone.
     */
    public final String zoneId() {
        return zoneId;
    }

    /**
     * <p>
     * The name of the zone group. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Availability Zones - <code>us-east-1-zg-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Local Zones - <code>us-west-2-lax-1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Wavelength Zones - <code>us-east-1-wl1-bos-wlz-1</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the zone group. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Availability Zones - <code>us-east-1-zg-1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Local Zones - <code>us-west-2-lax-1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Wavelength Zones - <code>us-east-1-wl1-bos-wlz-1</code>
     *         </p>
     *         </li>
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The name of the network border group.
     * </p>
     * 
     * @return The name of the network border group.
     */
    public final String networkBorderGroup() {
        return networkBorderGroup;
    }

    /**
     * <p>
     * The type of zone. The valid values are <code>availability-zone</code>, <code>local-zone</code>, and
     * <code>wavelength-zone</code>.
     * </p>
     * 
     * @return The type of zone. The valid values are <code>availability-zone</code>, <code>local-zone</code>, and
     *         <code>wavelength-zone</code>.
     */
    public final String zoneType() {
        return zoneType;
    }

    /**
     * <p>
     * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API
     * calls.
     * </p>
     * 
     * @return The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations,
     *         such as API calls.
     */
    public final String parentZoneName() {
        return parentZoneName;
    }

    /**
     * <p>
     * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as API
     * calls.
     * </p>
     * 
     * @return The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such
     *         as API calls.
     */
    public final String parentZoneId() {
        return parentZoneId;
    }

    /**
     * <p>
     * The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always <code>available</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AvailabilityZoneState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always
     *         <code>available</code>.
     * @see AvailabilityZoneState
     */
    public final AvailabilityZoneState state() {
        return AvailabilityZoneState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always <code>available</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AvailabilityZoneState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always
     *         <code>available</code>.
     * @see AvailabilityZoneState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optInStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(zoneId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(zoneType());
        hashCode = 31 * hashCode + Objects.hashCode(parentZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(parentZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(optInStatusAsString(), other.optInStatusAsString()) && hasMessages() == other.hasMessages()
                && Objects.equals(messages(), other.messages()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(zoneName(), other.zoneName()) && Objects.equals(zoneId(), other.zoneId())
                && Objects.equals(groupName(), other.groupName())
                && Objects.equals(networkBorderGroup(), other.networkBorderGroup())
                && Objects.equals(zoneType(), other.zoneType()) && Objects.equals(parentZoneName(), other.parentZoneName())
                && Objects.equals(parentZoneId(), other.parentZoneId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailabilityZone").add("OptInStatus", optInStatusAsString())
                .add("Messages", hasMessages() ? messages() : null).add("RegionName", regionName()).add("ZoneName", zoneName())
                .add("ZoneId", zoneId()).add("GroupName", groupName()).add("NetworkBorderGroup", networkBorderGroup())
                .add("ZoneType", zoneType()).add("ParentZoneName", parentZoneName()).add("ParentZoneId", parentZoneId())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptInStatus":
            return Optional.ofNullable(clazz.cast(optInStatusAsString()));
        case "Messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ZoneName":
            return Optional.ofNullable(clazz.cast(zoneName()));
        case "ZoneId":
            return Optional.ofNullable(clazz.cast(zoneId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        case "ZoneType":
            return Optional.ofNullable(clazz.cast(zoneType()));
        case "ParentZoneName":
            return Optional.ofNullable(clazz.cast(parentZoneName()));
        case "ParentZoneId":
            return Optional.ofNullable(clazz.cast(parentZoneId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptInStatus", OPT_IN_STATUS_FIELD);
        map.put("MessageSet", MESSAGES_FIELD);
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("ZoneName", ZONE_NAME_FIELD);
        map.put("ZoneId", ZONE_ID_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
        map.put("ZoneType", ZONE_TYPE_FIELD);
        map.put("ParentZoneName", PARENT_ZONE_NAME_FIELD);
        map.put("ParentZoneId", PARENT_ZONE_ID_FIELD);
        map.put("ZoneState", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.
         * </p>
         * <p>
         * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
         * <code>opted-in</code>, and <code>not-opted-in</code>.
         * </p>
         * 
         * @param optInStatus
         *        For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.</p>
         *        <p>
         *        For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
         *        <code>opted-in</code>, and <code>not-opted-in</code>.
         * @see AvailabilityZoneOptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneOptInStatus
         */
        Builder optInStatus(String optInStatus);

        /**
         * <p>
         * For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.
         * </p>
         * <p>
         * For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
         * <code>opted-in</code>, and <code>not-opted-in</code>.
         * </p>
         * 
         * @param optInStatus
         *        For Availability Zones, this parameter always has the value of <code>opt-in-not-required</code>.</p>
         *        <p>
         *        For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible values are
         *        <code>opted-in</code>, and <code>not-opted-in</code>.
         * @see AvailabilityZoneOptInStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneOptInStatus
         */
        Builder optInStatus(AvailabilityZoneOptInStatus optInStatus);

        /**
         * <p>
         * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         * </p>
         * 
         * @param messages
         *        Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<AvailabilityZoneMessage> messages);

        /**
         * <p>
         * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         * </p>
         * 
         * @param messages
         *        Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(AvailabilityZoneMessage... messages);

        /**
         * <p>
         * Any messages about the Availability Zone, Local Zone, or Wavelength Zone.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage.Builder#build()} is called
         * immediately and its result is passed to {@link #messages(List<AvailabilityZoneMessage>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<AvailabilityZoneMessage>)
         */
        Builder messages(Consumer<AvailabilityZoneMessage.Builder>... messages);

        /**
         * <p>
         * The name of the Region.
         * </p>
         * 
         * @param regionName
         *        The name of the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The name of the Availability Zone, Local Zone, or Wavelength Zone.
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone, Local Zone, or Wavelength Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);

        /**
         * <p>
         * The ID of the Availability Zone, Local Zone, or Wavelength Zone.
         * </p>
         * 
         * @param zoneId
         *        The ID of the Availability Zone, Local Zone, or Wavelength Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneId(String zoneId);

        /**
         * <p>
         * The name of the zone group. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Availability Zones - <code>us-east-1-zg-1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Local Zones - <code>us-west-2-lax-1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Wavelength Zones - <code>us-east-1-wl1-bos-wlz-1</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupName
         *        The name of the zone group. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Availability Zones - <code>us-east-1-zg-1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Local Zones - <code>us-west-2-lax-1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Wavelength Zones - <code>us-east-1-wl1-bos-wlz-1</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The name of the network border group.
         * </p>
         * 
         * @param networkBorderGroup
         *        The name of the network border group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        /**
         * <p>
         * The type of zone. The valid values are <code>availability-zone</code>, <code>local-zone</code>, and
         * <code>wavelength-zone</code>.
         * </p>
         * 
         * @param zoneType
         *        The type of zone. The valid values are <code>availability-zone</code>, <code>local-zone</code>, and
         *        <code>wavelength-zone</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneType(String zoneType);

        /**
         * <p>
         * The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as
         * API calls.
         * </p>
         * 
         * @param parentZoneName
         *        The name of the zone that handles some of the Local Zone or Wavelength Zone control plane operations,
         *        such as API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentZoneName(String parentZoneName);

        /**
         * <p>
         * The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations, such as
         * API calls.
         * </p>
         * 
         * @param parentZoneId
         *        The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane operations,
         *        such as API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentZoneId(String parentZoneId);

        /**
         * <p>
         * The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always
         * <code>available</code>.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always
         *        <code>available</code>.
         * @see AvailabilityZoneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always
         * <code>available</code>.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone, Local Zone, or Wavelength Zone. This value is always
         *        <code>available</code>.
         * @see AvailabilityZoneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneState
         */
        Builder state(AvailabilityZoneState state);
    }

    static final class BuilderImpl implements Builder {
        private String optInStatus;

        private List<AvailabilityZoneMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private String regionName;

        private String zoneName;

        private String zoneId;

        private String groupName;

        private String networkBorderGroup;

        private String zoneType;

        private String parentZoneName;

        private String parentZoneId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            optInStatus(model.optInStatus);
            messages(model.messages);
            regionName(model.regionName);
            zoneName(model.zoneName);
            zoneId(model.zoneId);
            groupName(model.groupName);
            networkBorderGroup(model.networkBorderGroup);
            zoneType(model.zoneType);
            parentZoneName(model.parentZoneName);
            parentZoneId(model.parentZoneId);
            state(model.state);
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(AvailabilityZoneOptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final List<AvailabilityZoneMessage.Builder> getMessages() {
            List<AvailabilityZoneMessage.Builder> result = AvailabilityZoneMessageListCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage.BuilderImpl> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<AvailabilityZoneMessage.Builder>... messages) {
            messages(Stream.of(messages).map(c -> AvailabilityZoneMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getZoneName() {
            return zoneName;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final String getZoneId() {
            return zoneId;
        }

        public final void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public final Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final String getZoneType() {
            return zoneType;
        }

        public final void setZoneType(String zoneType) {
            this.zoneType = zoneType;
        }

        @Override
        public final Builder zoneType(String zoneType) {
            this.zoneType = zoneType;
            return this;
        }

        public final String getParentZoneName() {
            return parentZoneName;
        }

        public final void setParentZoneName(String parentZoneName) {
            this.parentZoneName = parentZoneName;
        }

        @Override
        public final Builder parentZoneName(String parentZoneName) {
            this.parentZoneName = parentZoneName;
            return this;
        }

        public final String getParentZoneId() {
            return parentZoneId;
        }

        public final void setParentZoneId(String parentZoneId) {
            this.parentZoneId = parentZoneId;
        }

        @Override
        public final Builder parentZoneId(String parentZoneId) {
            this.parentZoneId = parentZoneId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
