/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AssignPrivateIpAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssignPrivateIpAddressesRequest extends Ec2Request implements
        ToCopyableBuilder<AssignPrivateIpAddressesRequest.Builder, AssignPrivateIpAddressesRequest> {
    private static final SdkField<List<String>> IPV4_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(AssignPrivateIpAddressesRequest::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefix")
                    .unmarshallLocationName("Ipv4Prefix").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4PrefixCount")
            .getter(getter(AssignPrivateIpAddressesRequest::ipv4PrefixCount))
            .setter(setter(Builder::ipv4PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount")
                    .unmarshallLocationName("Ipv4PrefixCount").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssignPrivateIpAddressesRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(AssignPrivateIpAddressesRequest::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PrivateIpAddress")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PrivateIpAddress").unmarshallLocationName("PrivateIpAddress")
                                                    .build()).build()).build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(AssignPrivateIpAddressesRequest::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .unmarshallLocationName("secondaryPrivateIpAddressCount").build()).build();

    private static final SdkField<Boolean> ALLOW_REASSIGNMENT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowReassignment")
            .getter(getter(AssignPrivateIpAddressesRequest::allowReassignment))
            .setter(setter(Builder::allowReassignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReassignment")
                    .unmarshallLocationName("allowReassignment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV4_PREFIXES_FIELD,
            IPV4_PREFIX_COUNT_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, ALLOW_REASSIGNMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> ipv4Prefixes;

    private final Integer ipv4PrefixCount;

    private final String networkInterfaceId;

    private final List<String> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final Boolean allowReassignment;

    private AssignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.allowReassignment = builder.allowReassignment;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv4 prefixes assigned to the network interface. You can't use this option if you use the
     * <code>Ipv4PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Prefixes} method.
     * </p>
     * 
     * @return One or more IPv4 prefixes assigned to the network interface. You can't use this option if you use the
     *         <code>Ipv4PrefixCount</code> option.
     */
    public final List<String> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You can't
     * use this option if you use the <code>Ipv4 Prefixes</code> option.
     * </p>
     * 
     * @return The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You
     *         can't use this option if you use the <code>Ipv4 Prefixes</code> option.
     */
    public final Integer ipv4PrefixCount() {
        return ipv4PrefixCount;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify
     * this parameter when also specifying a number of secondary IP addresses.
     * </p>
     * <p>
     * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return The IP addresses to be assigned as a secondary private IP address to the network interface. You can't
     *         specify this parameter when also specifying a number of secondary IP addresses.</p>
     *         <p>
     *         If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
     *         range.
     */
    public final List<String> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when
     * also specifying private IP addresses.
     * </p>
     * 
     * @return The number of secondary IP addresses to assign to the network interface. You can't specify this parameter
     *         when also specifying private IP addresses.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * Indicates whether to allow an IP address that is already assigned to another network interface or instance to be
     * reassigned to the specified network interface.
     * </p>
     * 
     * @return Indicates whether to allow an IP address that is already assigned to another network interface or
     *         instance to be reassigned to the specified network interface.
     */
    public final Boolean allowReassignment() {
        return allowReassignment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(allowReassignment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest) obj;
        return hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(ipv4PrefixCount(), other.ipv4PrefixCount())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && Objects.equals(allowReassignment(), other.allowReassignment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssignPrivateIpAddressesRequest").add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null)
                .add("Ipv4PrefixCount", ipv4PrefixCount()).add("NetworkInterfaceId", networkInterfaceId())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount())
                .add("AllowReassignment", allowReassignment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv4PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv4PrefixCount()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        case "AllowReassignment":
            return Optional.ofNullable(clazz.cast(allowReassignment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ipv4Prefix", IPV4_PREFIXES_FIELD);
        map.put("Ipv4PrefixCount", IPV4_PREFIX_COUNT_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("SecondaryPrivateIpAddressCount", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD);
        map.put("AllowReassignment", ALLOW_REASSIGNMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssignPrivateIpAddressesRequest, T> g) {
        return obj -> g.apply((AssignPrivateIpAddressesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
        /**
         * <p>
         * One or more IPv4 prefixes assigned to the network interface. You can't use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 prefixes assigned to the network interface. You can't use this option if you use the
         *        <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<String> ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 prefixes assigned to the network interface. You can't use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 prefixes assigned to the network interface. You can't use this option if you use the
         *        <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(String... ipv4Prefixes);

        /**
         * <p>
         * The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface. You
         * can't use this option if you use the <code>Ipv4 Prefixes</code> option.
         * </p>
         * 
         * @param ipv4PrefixCount
         *        The number of IPv4 prefixes that Amazon Web Services automatically assigns to the network interface.
         *        You can't use this option if you use the <code>Ipv4 Prefixes</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4PrefixCount(Integer ipv4PrefixCount);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify
         * this parameter when also specifying a number of secondary IP addresses.
         * </p>
         * <p>
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         * </p>
         * 
         * @param privateIpAddresses
         *        The IP addresses to be assigned as a secondary private IP address to the network interface. You can't
         *        specify this parameter when also specifying a number of secondary IP addresses.</p>
         *        <p>
         *        If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<String> privateIpAddresses);

        /**
         * <p>
         * The IP addresses to be assigned as a secondary private IP address to the network interface. You can't specify
         * this parameter when also specifying a number of secondary IP addresses.
         * </p>
         * <p>
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         * </p>
         * 
         * @param privateIpAddresses
         *        The IP addresses to be assigned as a secondary private IP address to the network interface. You can't
         *        specify this parameter when also specifying a number of secondary IP addresses.</p>
         *        <p>
         *        If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(String... privateIpAddresses);

        /**
         * <p>
         * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter
         * when also specifying private IP addresses.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary IP addresses to assign to the network interface. You can't specify this
         *        parameter when also specifying private IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * Indicates whether to allow an IP address that is already assigned to another network interface or instance to
         * be reassigned to the specified network interface.
         * </p>
         * 
         * @param allowReassignment
         *        Indicates whether to allow an IP address that is already assigned to another network interface or
         *        instance to be reassigned to the specified network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowReassignment(Boolean allowReassignment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();

        private Integer ipv4PrefixCount;

        private String networkInterfaceId;

        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private Boolean allowReassignment;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesRequest model) {
            super(model);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv4PrefixCount(model.ipv4PrefixCount);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            allowReassignment(model.allowReassignment);
        }

        public final Collection<String> getIpv4Prefixes() {
            if (ipv4Prefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return ipv4Prefixes;
        }

        public final void setIpv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = IpPrefixListCopier.copy(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<String> ipv4Prefixes) {
            this.ipv4Prefixes = IpPrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(String... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Collection<String> getPrivateIpAddresses() {
            if (privateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return privateIpAddresses;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final Boolean getAllowReassignment() {
            return allowReassignment;
        }

        public final void setAllowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
        }

        @Override
        public final Builder allowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssignPrivateIpAddressesRequest build() {
            return new AssignPrivateIpAddressesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
