/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Autonomous System Number (ASN) and BYOIP CIDR association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsnAssociation implements SdkPojo, Serializable, ToCopyableBuilder<AsnAssociation.Builder, AsnAssociation> {
    private static final SdkField<String> ASN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Asn")
            .getter(getter(AsnAssociation::asn))
            .setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").unmarshallLocationName("asn")
                    .build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(AsnAssociation::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("cidr").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(AsnAssociation::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(AsnAssociation::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_FIELD, CIDR_FIELD,
            STATUS_MESSAGE_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String asn;

    private final String cidr;

    private final String statusMessage;

    private final String state;

    private AsnAssociation(BuilderImpl builder) {
        this.asn = builder.asn;
        this.cidr = builder.cidr;
        this.statusMessage = builder.statusMessage;
        this.state = builder.state;
    }

    /**
     * <p>
     * The association's ASN.
     * </p>
     * 
     * @return The association's ASN.
     */
    public final String asn() {
        return asn;
    }

    /**
     * <p>
     * The association's CIDR.
     * </p>
     * 
     * @return The association's CIDR.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The association's status message.
     * </p>
     * 
     * @return The association's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AsnAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The association's state.
     * @see AsnAssociationState
     */
    public final AsnAssociationState state() {
        return AsnAssociationState.fromValue(state);
    }

    /**
     * <p>
     * The association's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AsnAssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The association's state.
     * @see AsnAssociationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsnAssociation)) {
            return false;
        }
        AsnAssociation other = (AsnAssociation) obj;
        return Objects.equals(asn(), other.asn()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsnAssociation").add("Asn", asn()).add("Cidr", cidr()).add("StatusMessage", statusMessage())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Asn", ASN_FIELD);
        map.put("Cidr", CIDR_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsnAssociation, T> g) {
        return obj -> g.apply((AsnAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsnAssociation> {
        /**
         * <p>
         * The association's ASN.
         * </p>
         * 
         * @param asn
         *        The association's ASN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(String asn);

        /**
         * <p>
         * The association's CIDR.
         * </p>
         * 
         * @param cidr
         *        The association's CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The association's status message.
         * </p>
         * 
         * @param statusMessage
         *        The association's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The association's state.
         * </p>
         * 
         * @param state
         *        The association's state.
         * @see AsnAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsnAssociationState
         */
        Builder state(String state);

        /**
         * <p>
         * The association's state.
         * </p>
         * 
         * @param state
         *        The association's state.
         * @see AsnAssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsnAssociationState
         */
        Builder state(AsnAssociationState state);
    }

    static final class BuilderImpl implements Builder {
        private String asn;

        private String cidr;

        private String statusMessage;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AsnAssociation model) {
            asn(model.asn);
            cidr(model.cidr);
            statusMessage(model.statusMessage);
            state(model.state);
        }

        public final String getAsn() {
            return asn;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AsnAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public AsnAssociation build() {
            return new AsnAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
