/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceSetCopier;
import software.amazon.awssdk.services.ec2.model.InstanceTopology;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceTopologyResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceTopologyResponse> {
    private static final SdkField<List<InstanceTopology>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(DescribeInstanceTopologyResponse.getter(DescribeInstanceTopologyResponse::instances)).setter(DescribeInstanceTopologyResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSet").unmarshallLocationName("instanceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTopology::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceTopologyResponse.getter(DescribeInstanceTopologyResponse::nextToken)).setter(DescribeInstanceTopologyResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceTopology> instances;
    private final String nextToken;

    private DescribeInstanceTopologyResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<InstanceTopology> instances() {
        return this.instances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceTopologyResponse)) {
            return false;
        }
        DescribeInstanceTopologyResponse other = (DescribeInstanceTopologyResponse)((Object)obj);
        return this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceTopologyResponse").add("Instances", this.hasInstances() ? this.instances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceTopologyResponse, T> g) {
        return obj -> g.apply((DescribeInstanceTopologyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceTopology> instances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceTopologyResponse model) {
            super(model);
            this.instances(model.instances);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceTopology.Builder> getInstances() {
            List<InstanceTopology.Builder> result = InstanceSetCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<InstanceTopology.BuilderImpl> instances) {
            this.instances = InstanceSetCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<InstanceTopology> instances) {
            this.instances = InstanceSetCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceTopology ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceTopology.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (InstanceTopology)((InstanceTopology.Builder)InstanceTopology.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstanceTopologyResponse build() {
            return new DescribeInstanceTopologyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceTopologyResponse> {
        public Builder instances(Collection<InstanceTopology> var1);

        public Builder instances(InstanceTopology ... var1);

        public Builder instances(Consumer<InstanceTopology.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

