/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule associated with a transit gateway policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayPolicyRule implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayPolicyRule.Builder, TransitGatewayPolicyRule> {
    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCidrBlock")
            .getter(getter(TransitGatewayPolicyRule::sourceCidrBlock))
            .setter(setter(Builder::sourceCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock")
                    .unmarshallLocationName("sourceCidrBlock").build()).build();

    private static final SdkField<String> SOURCE_PORT_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourcePortRange")
            .getter(getter(TransitGatewayPolicyRule::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("sourcePortRange").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(TransitGatewayPolicyRule::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationPortRange")
            .getter(getter(TransitGatewayPolicyRule::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("destinationPortRange").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(TransitGatewayPolicyRule::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<TransitGatewayPolicyRuleMetaData> META_DATA_FIELD = SdkField
            .<TransitGatewayPolicyRuleMetaData> builder(MarshallingType.SDK_POJO)
            .memberName("MetaData")
            .getter(getter(TransitGatewayPolicyRule::metaData))
            .setter(setter(Builder::metaData))
            .constructor(TransitGatewayPolicyRuleMetaData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetaData")
                    .unmarshallLocationName("metaData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SOURCE_CIDR_BLOCK_FIELD, SOURCE_PORT_RANGE_FIELD, DESTINATION_CIDR_BLOCK_FIELD,
                    DESTINATION_PORT_RANGE_FIELD, PROTOCOL_FIELD, META_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceCidrBlock;

    private final String sourcePortRange;

    private final String destinationCidrBlock;

    private final String destinationPortRange;

    private final String protocol;

    private final TransitGatewayPolicyRuleMetaData metaData;

    private TransitGatewayPolicyRule(BuilderImpl builder) {
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPortRange = builder.destinationPortRange;
        this.protocol = builder.protocol;
        this.metaData = builder.metaData;
    }

    /**
     * <p>
     * The source CIDR block for the transit gateway policy rule.
     * </p>
     * 
     * @return The source CIDR block for the transit gateway policy rule.
     */
    public final String sourceCidrBlock() {
        return sourceCidrBlock;
    }

    /**
     * <p>
     * The port range for the transit gateway policy rule. Currently this is set to * (all).
     * </p>
     * 
     * @return The port range for the transit gateway policy rule. Currently this is set to * (all).
     */
    public final String sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The destination CIDR block for the transit gateway policy rule.
     * </p>
     * 
     * @return The destination CIDR block for the transit gateway policy rule.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The port range for the transit gateway policy rule. Currently this is set to * (all).
     * </p>
     * 
     * @return The port range for the transit gateway policy rule. Currently this is set to * (all).
     */
    public final String destinationPortRange() {
        return destinationPortRange;
    }

    /**
     * <p>
     * The protocol used by the transit gateway policy rule.
     * </p>
     * 
     * @return The protocol used by the transit gateway policy rule.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The meta data tags used for the transit gateway policy rule.
     * </p>
     * 
     * @return The meta data tags used for the transit gateway policy rule.
     */
    public final TransitGatewayPolicyRuleMetaData metaData() {
        return metaData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(metaData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPolicyRule)) {
            return false;
        }
        TransitGatewayPolicyRule other = (TransitGatewayPolicyRule) obj;
        return Objects.equals(sourceCidrBlock(), other.sourceCidrBlock())
                && Objects.equals(sourcePortRange(), other.sourcePortRange())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationPortRange(), other.destinationPortRange())
                && Objects.equals(protocol(), other.protocol()) && Objects.equals(metaData(), other.metaData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayPolicyRule").add("SourceCidrBlock", sourceCidrBlock())
                .add("SourcePortRange", sourcePortRange()).add("DestinationCidrBlock", destinationCidrBlock())
                .add("DestinationPortRange", destinationPortRange()).add("Protocol", protocol()).add("MetaData", metaData())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceCidrBlock":
            return Optional.ofNullable(clazz.cast(sourceCidrBlock()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "MetaData":
            return Optional.ofNullable(clazz.cast(metaData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPolicyRule, T> g) {
        return obj -> g.apply((TransitGatewayPolicyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayPolicyRule> {
        /**
         * <p>
         * The source CIDR block for the transit gateway policy rule.
         * </p>
         * 
         * @param sourceCidrBlock
         *        The source CIDR block for the transit gateway policy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCidrBlock(String sourceCidrBlock);

        /**
         * <p>
         * The port range for the transit gateway policy rule. Currently this is set to * (all).
         * </p>
         * 
         * @param sourcePortRange
         *        The port range for the transit gateway policy rule. Currently this is set to * (all).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(String sourcePortRange);

        /**
         * <p>
         * The destination CIDR block for the transit gateway policy rule.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block for the transit gateway policy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The port range for the transit gateway policy rule. Currently this is set to * (all).
         * </p>
         * 
         * @param destinationPortRange
         *        The port range for the transit gateway policy rule. Currently this is set to * (all).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(String destinationPortRange);

        /**
         * <p>
         * The protocol used by the transit gateway policy rule.
         * </p>
         * 
         * @param protocol
         *        The protocol used by the transit gateway policy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The meta data tags used for the transit gateway policy rule.
         * </p>
         * 
         * @param metaData
         *        The meta data tags used for the transit gateway policy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaData(TransitGatewayPolicyRuleMetaData metaData);

        /**
         * <p>
         * The meta data tags used for the transit gateway policy rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitGatewayPolicyRuleMetaData.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayPolicyRuleMetaData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayPolicyRuleMetaData.Builder#build()} is called
         * immediately and its result is passed to {@link #metaData(TransitGatewayPolicyRuleMetaData)}.
         * 
         * @param metaData
         *        a consumer that will call methods on {@link TransitGatewayPolicyRuleMetaData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metaData(TransitGatewayPolicyRuleMetaData)
         */
        default Builder metaData(Consumer<TransitGatewayPolicyRuleMetaData.Builder> metaData) {
            return metaData(TransitGatewayPolicyRuleMetaData.builder().applyMutation(metaData).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceCidrBlock;

        private String sourcePortRange;

        private String destinationCidrBlock;

        private String destinationPortRange;

        private String protocol;

        private TransitGatewayPolicyRuleMetaData metaData;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPolicyRule model) {
            sourceCidrBlock(model.sourceCidrBlock);
            sourcePortRange(model.sourcePortRange);
            destinationCidrBlock(model.destinationCidrBlock);
            destinationPortRange(model.destinationPortRange);
            protocol(model.protocol);
            metaData(model.metaData);
        }

        public final String getSourceCidrBlock() {
            return sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getSourcePortRange() {
            return sourcePortRange;
        }

        public final void setSourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
        }

        @Override
        public final Builder sourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPortRange() {
            return destinationPortRange;
        }

        public final void setDestinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
        }

        @Override
        public final Builder destinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final TransitGatewayPolicyRuleMetaData.Builder getMetaData() {
            return metaData != null ? metaData.toBuilder() : null;
        }

        public final void setMetaData(TransitGatewayPolicyRuleMetaData.BuilderImpl metaData) {
            this.metaData = metaData != null ? metaData.build() : null;
        }

        @Override
        public final Builder metaData(TransitGatewayPolicyRuleMetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        @Override
        public TransitGatewayPolicyRule build() {
            return new TransitGatewayPolicyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
