/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIpamPoolRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteIpamPoolRequest.Builder, DeleteIpamPoolRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DeleteIpamPoolRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolId")
            .getter(getter(DeleteIpamPoolRequest::ipamPoolId))
            .setter(setter(Builder::ipamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId")
                    .unmarshallLocationName("IpamPoolId").build()).build();

    private static final SdkField<Boolean> CASCADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Cascade")
            .getter(getter(DeleteIpamPoolRequest::cascade))
            .setter(setter(Builder::cascade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cascade")
                    .unmarshallLocationName("Cascade").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_POOL_ID_FIELD, CASCADE_FIELD));

    private final Boolean dryRun;

    private final String ipamPoolId;

    private final Boolean cascade;

    private DeleteIpamPoolRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPoolId = builder.ipamPoolId;
        this.cascade = builder.cascade;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the pool to delete.
     * </p>
     * 
     * @return The ID of the pool to delete.
     */
    public final String ipamPoolId() {
        return ipamPoolId;
    }

    /**
     * <p>
     * Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs,
     * allocations, and other pools.
     * </p>
     * <important>
     * <p>
     * You can only use this option to delete pools in the private scope or pools in the public scope with a source
     * resource. A source resource is a resource used to provision CIDRs to a resource planning pool.
     * </p>
     * </important>
     * 
     * @return Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned
     *         CIDRs, allocations, and other pools.</p> <important>
     *         <p>
     *         You can only use this option to delete pools in the private scope or pools in the public scope with a
     *         source resource. A source resource is a resource used to provision CIDRs to a resource planning pool.
     *         </p>
     */
    public final Boolean cascade() {
        return cascade;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(cascade());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIpamPoolRequest)) {
            return false;
        }
        DeleteIpamPoolRequest other = (DeleteIpamPoolRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamPoolId(), other.ipamPoolId())
                && Objects.equals(cascade(), other.cascade());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteIpamPoolRequest").add("DryRun", dryRun()).add("IpamPoolId", ipamPoolId())
                .add("Cascade", cascade()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipamPoolId()));
        case "Cascade":
            return Optional.ofNullable(clazz.cast(cascade()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIpamPoolRequest, T> g) {
        return obj -> g.apply((DeleteIpamPoolRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIpamPoolRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the pool to delete.
         * </p>
         * 
         * @param ipamPoolId
         *        The ID of the pool to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolId(String ipamPoolId);

        /**
         * <p>
         * Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned CIDRs,
         * allocations, and other pools.
         * </p>
         * <important>
         * <p>
         * You can only use this option to delete pools in the private scope or pools in the public scope with a source
         * resource. A source resource is a resource used to provision CIDRs to a resource planning pool.
         * </p>
         * </important>
         * 
         * @param cascade
         *        Enables you to quickly delete an IPAM pool and all resources within that pool, including provisioned
         *        CIDRs, allocations, and other pools.</p> <important>
         *        <p>
         *        You can only use this option to delete pools in the private scope or pools in the public scope with a
         *        source resource. A source resource is a resource used to provision CIDRs to a resource planning pool.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cascade(Boolean cascade);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamPoolId;

        private Boolean cascade;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIpamPoolRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamPoolId(model.ipamPoolId);
            cascade(model.cascade);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPoolId() {
            return ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final Boolean getCascade() {
            return cascade;
        }

        public final void setCascade(Boolean cascade) {
            this.cascade = cascade;
        }

        @Override
        public final Builder cascade(Boolean cascade) {
            this.cascade = cascade;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIpamPoolRequest build() {
            return new DeleteIpamPoolRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
