/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeyPairRequest extends Ec2Request implements
        ToCopyableBuilder<CreateKeyPairRequest.Builder, CreateKeyPairRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyName")
            .getter(getter(CreateKeyPairRequest::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("KeyName").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateKeyPairRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> KEY_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyType")
            .getter(getter(CreateKeyPairRequest::keyTypeAsString))
            .setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType")
                    .unmarshallLocationName("KeyType").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateKeyPairRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyFormat")
            .getter(getter(CreateKeyPairRequest::keyFormatAsString))
            .setter(setter(Builder::keyFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFormat")
                    .unmarshallLocationName("KeyFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD, DRY_RUN_FIELD,
            KEY_TYPE_FIELD, TAG_SPECIFICATIONS_FIELD, KEY_FORMAT_FIELD));

    private final String keyName;

    private final Boolean dryRun;

    private final String keyType;

    private final List<TagSpecification> tagSpecifications;

    private final String keyFormat;

    private CreateKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.dryRun = builder.dryRun;
        this.keyType = builder.keyType;
        this.tagSpecifications = builder.tagSpecifications;
        this.keyFormat = builder.keyFormat;
    }

    /**
     * <p>
     * A unique name for the key pair.
     * </p>
     * <p>
     * Constraints: Up to 255 ASCII characters
     * </p>
     * 
     * @return A unique name for the key pair.</p>
     *         <p>
     *         Constraints: Up to 255 ASCII characters
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The type of key pair. Note that ED25519 keys are not supported for Windows instances.
     * </p>
     * <p>
     * Default: <code>rsa</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of key pair. Note that ED25519 keys are not supported for Windows instances.</p>
     *         <p>
     *         Default: <code>rsa</code>
     * @see KeyType
     */
    public final KeyType keyType() {
        return KeyType.fromValue(keyType);
    }

    /**
     * <p>
     * The type of key pair. Note that ED25519 keys are not supported for Windows instances.
     * </p>
     * <p>
     * Default: <code>rsa</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return The type of key pair. Note that ED25519 keys are not supported for Windows instances.</p>
     *         <p>
     *         Default: <code>rsa</code>
     * @see KeyType
     */
    public final String keyTypeAsString() {
        return keyType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the new key pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the new key pair.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * The format of the key pair.
     * </p>
     * <p>
     * Default: <code>pem</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyFormat} will
     * return {@link KeyFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyFormatAsString}.
     * </p>
     * 
     * @return The format of the key pair.</p>
     *         <p>
     *         Default: <code>pem</code>
     * @see KeyFormat
     */
    public final KeyFormat keyFormat() {
        return KeyFormat.fromValue(keyFormat);
    }

    /**
     * <p>
     * The format of the key pair.
     * </p>
     * <p>
     * Default: <code>pem</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyFormat} will
     * return {@link KeyFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyFormatAsString}.
     * </p>
     * 
     * @return The format of the key pair.</p>
     *         <p>
     *         Default: <code>pem</code>
     * @see KeyFormat
     */
    public final String keyFormatAsString() {
        return keyFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(keyFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairRequest)) {
            return false;
        }
        CreateKeyPairRequest other = (CreateKeyPairRequest) obj;
        return Objects.equals(keyName(), other.keyName()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(keyTypeAsString(), other.keyTypeAsString())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(keyFormatAsString(), other.keyFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeyPairRequest").add("KeyName", keyName()).add("DryRun", dryRun())
                .add("KeyType", keyTypeAsString()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("KeyFormat", keyFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "KeyFormat":
            return Optional.ofNullable(clazz.cast(keyFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyPairRequest, T> g) {
        return obj -> g.apply((CreateKeyPairRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeyPairRequest> {
        /**
         * <p>
         * A unique name for the key pair.
         * </p>
         * <p>
         * Constraints: Up to 255 ASCII characters
         * </p>
         * 
         * @param keyName
         *        A unique name for the key pair.</p>
         *        <p>
         *        Constraints: Up to 255 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The type of key pair. Note that ED25519 keys are not supported for Windows instances.
         * </p>
         * <p>
         * Default: <code>rsa</code>
         * </p>
         * 
         * @param keyType
         *        The type of key pair. Note that ED25519 keys are not supported for Windows instances.</p>
         *        <p>
         *        Default: <code>rsa</code>
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(String keyType);

        /**
         * <p>
         * The type of key pair. Note that ED25519 keys are not supported for Windows instances.
         * </p>
         * <p>
         * Default: <code>rsa</code>
         * </p>
         * 
         * @param keyType
         *        The type of key pair. Note that ED25519 keys are not supported for Windows instances.</p>
         *        <p>
         *        Default: <code>rsa</code>
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(KeyType keyType);

        /**
         * <p>
         * The tags to apply to the new key pair.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new key pair.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the new key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the new key pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * The format of the key pair.
         * </p>
         * <p>
         * Default: <code>pem</code>
         * </p>
         * 
         * @param keyFormat
         *        The format of the key pair.</p>
         *        <p>
         *        Default: <code>pem</code>
         * @see KeyFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyFormat
         */
        Builder keyFormat(String keyFormat);

        /**
         * <p>
         * The format of the key pair.
         * </p>
         * <p>
         * Default: <code>pem</code>
         * </p>
         * 
         * @param keyFormat
         *        The format of the key pair.</p>
         *        <p>
         *        Default: <code>pem</code>
         * @see KeyFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyFormat
         */
        Builder keyFormat(KeyFormat keyFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String keyName;

        private Boolean dryRun;

        private String keyType;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String keyFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairRequest model) {
            super(model);
            keyName(model.keyName);
            dryRun(model.dryRun);
            keyType(model.keyType);
            tagSpecifications(model.tagSpecifications);
            keyFormat(model.keyFormat);
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getKeyType() {
            return keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKeyFormat() {
            return keyFormat;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        @Override
        public final Builder keyFormat(KeyFormat keyFormat) {
            this.keyFormat(keyFormat == null ? null : keyFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeyPairRequest build() {
            return new CreateKeyPairRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
