/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImageRequest extends Ec2Request implements
        ToCopyableBuilder<CreateImageRequest.Builder, CreateImageRequest> {
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(CreateImageRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BlockDeviceMapping")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BlockDeviceMapping")
                                                    .unmarshallLocationName("BlockDeviceMapping").build()).build()).build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateImageRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(CreateImageRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateImageRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<Boolean> NO_REBOOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoReboot")
            .getter(getter(CreateImageRequest::noReboot))
            .setter(setter(Builder::noReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoReboot")
                    .unmarshallLocationName("noReboot").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateImageRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD,
            DESCRIPTION_FIELD, DRY_RUN_FIELD, INSTANCE_ID_FIELD, NAME_FIELD, NO_REBOOT_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final Boolean dryRun;

    private final String instanceId;

    private final String name;

    private final Boolean noReboot;

    private final List<TagSpecification> tagSpecifications;

    private CreateImageRequest(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.noReboot = builder.noReboot;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The block device mappings.
     * </p>
     * <p>
     * When using the CreateImage action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't change the volume size using the VolumeSize parameter. If you want a different volume size, you must
     * first change the volume size of the source instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't modify the encryption status of existing volumes or snapshots. To create an AMI with volumes or
     * snapshots that have a different encryption status (for example, where the source volume and snapshots are
     * unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the <a>CopyImage</a> action.
     * </p>
     * </li>
     * <li>
     * <p>
     * The only option that can be changed for existing mappings or snapshots is <code>DeleteOnTermination</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return The block device mappings.</p>
     *         <p>
     *         When using the CreateImage action:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You can't change the volume size using the VolumeSize parameter. If you want a different volume size, you
     *         must first change the volume size of the source instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can't modify the encryption status of existing volumes or snapshots. To create an AMI with volumes or
     *         snapshots that have a different encryption status (for example, where the source volume and snapshots are
     *         unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the <a>CopyImage</a>
     *         action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The only option that can be changed for existing mappings or snapshots is
     *         <code>DeleteOnTermination</code>.
     *         </p>
     *         </li>
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * A description for the new image.
     * </p>
     * 
     * @return A description for the new image.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A name for the new image.
     * </p>
     * <p>
     * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
     * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     * </p>
     * 
     * @return A name for the new image.</p>
     *         <p>
     *         Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods
     *         (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates whether or not the instance should be automatically rebooted before creating the image. Specify one of
     * the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code> - The instance is not rebooted before creating the image. This creates crash-consistent
     * snapshots that include only the data that has been written to the volumes at the time the snapshots are created.
     * Buffered data and data in memory that has not yet been written to the volumes is not included in the snapshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code> - The instance is rebooted before creating the image. This ensures that all buffered data and
     * data in memory is written to the volumes before the snapshots are created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether or not the instance should be automatically rebooted before creating the image. Specify
     *         one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code> - The instance is not rebooted before creating the image. This creates crash-consistent
     *         snapshots that include only the data that has been written to the volumes at the time the snapshots are
     *         created. Buffered data and data in memory that has not yet been written to the volumes is not included in
     *         the snapshots.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code> - The instance is rebooted before creating the image. This ensures that all buffered
     *         data and data in memory is written to the volumes before the snapshots are created.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean noReboot() {
        return noReboot;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to the
     * instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied to all
     * of the snapshots that are created.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify other values for <code>ResourceType</code>, the request fails.
     * </p>
     * <p>
     * To tag an AMI or snapshot after it has been created, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are
     *         attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same
     *         tag is applied to all of the snapshots that are created.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify other values for <code>ResourceType</code>, the request fails.
     *         </p>
     *         <p>
     *         To tag an AMI or snapshot after it has been created, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(noReboot());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest) obj;
        return hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(description(), other.description()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(noReboot(), other.noReboot()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateImageRequest")
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("Description", description()).add("DryRun", dryRun()).add("InstanceId", instanceId()).add("Name", name())
                .add("NoReboot", noReboot()).add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NoReboot":
            return Optional.ofNullable(clazz.cast(noReboot()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRequest, T> g) {
        return obj -> g.apply((CreateImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateImageRequest> {
        /**
         * <p>
         * The block device mappings.
         * </p>
         * <p>
         * When using the CreateImage action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can't change the volume size using the VolumeSize parameter. If you want a different volume size, you
         * must first change the volume size of the source instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't modify the encryption status of existing volumes or snapshots. To create an AMI with volumes or
         * snapshots that have a different encryption status (for example, where the source volume and snapshots are
         * unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the <a>CopyImage</a>
         * action.
         * </p>
         * </li>
         * <li>
         * <p>
         * The only option that can be changed for existing mappings or snapshots is <code>DeleteOnTermination</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param blockDeviceMappings
         *        The block device mappings.</p>
         *        <p>
         *        When using the CreateImage action:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can't change the volume size using the VolumeSize parameter. If you want a different volume size,
         *        you must first change the volume size of the source instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't modify the encryption status of existing volumes or snapshots. To create an AMI with volumes
         *        or snapshots that have a different encryption status (for example, where the source volume and
         *        snapshots are unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the
         *        <a>CopyImage</a> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The only option that can be changed for existing mappings or snapshots is
         *        <code>DeleteOnTermination</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mappings.
         * </p>
         * <p>
         * When using the CreateImage action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can't change the volume size using the VolumeSize parameter. If you want a different volume size, you
         * must first change the volume size of the source instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't modify the encryption status of existing volumes or snapshots. To create an AMI with volumes or
         * snapshots that have a different encryption status (for example, where the source volume and snapshots are
         * unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the <a>CopyImage</a>
         * action.
         * </p>
         * </li>
         * <li>
         * <p>
         * The only option that can be changed for existing mappings or snapshots is <code>DeleteOnTermination</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param blockDeviceMappings
         *        The block device mappings.</p>
         *        <p>
         *        When using the CreateImage action:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You can't change the volume size using the VolumeSize parameter. If you want a different volume size,
         *        you must first change the volume size of the source instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't modify the encryption status of existing volumes or snapshots. To create an AMI with volumes
         *        or snapshots that have a different encryption status (for example, where the source volume and
         *        snapshots are unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the
         *        <a>CopyImage</a> action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The only option that can be changed for existing mappings or snapshots is
         *        <code>DeleteOnTermination</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mappings.
         * </p>
         * <p>
         * When using the CreateImage action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You can't change the volume size using the VolumeSize parameter. If you want a different volume size, you
         * must first change the volume size of the source instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't modify the encryption status of existing volumes or snapshots. To create an AMI with volumes or
         * snapshots that have a different encryption status (for example, where the source volume and snapshots are
         * unencrypted, and you want to create an AMI with encrypted volumes or snapshots), use the <a>CopyImage</a>
         * action.
         * </p>
         * </li>
         * <li>
         * <p>
         * The only option that can be changed for existing mappings or snapshots is <code>DeleteOnTermination</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.BlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * A description for the new image.
         * </p>
         * 
         * @param description
         *        A description for the new image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A name for the new image.
         * </p>
         * <p>
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
         * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * </p>
         * 
         * @param name
         *        A name for the new image.</p>
         *        <p>
         *        Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ),
         *        periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates whether or not the instance should be automatically rebooted before creating the image. Specify one
         * of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code> - The instance is not rebooted before creating the image. This creates crash-consistent
         * snapshots that include only the data that has been written to the volumes at the time the snapshots are
         * created. Buffered data and data in memory that has not yet been written to the volumes is not included in the
         * snapshots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code> - The instance is rebooted before creating the image. This ensures that all buffered data
         * and data in memory is written to the volumes before the snapshots are created.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param noReboot
         *        Indicates whether or not the instance should be automatically rebooted before creating the image.
         *        Specify one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code> - The instance is not rebooted before creating the image. This creates
         *        crash-consistent snapshots that include only the data that has been written to the volumes at the time
         *        the snapshots are created. Buffered data and data in memory that has not yet been written to the
         *        volumes is not included in the snapshots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code> - The instance is rebooted before creating the image. This ensures that all
         *        buffered data and data in memory is written to the volumes before the snapshots are created.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noReboot(Boolean noReboot);

        /**
         * <p>
         * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to
         * the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied
         * to all of the snapshots that are created.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify other values for <code>ResourceType</code>, the request fails.
         * </p>
         * <p>
         * To tag an AMI or snapshot after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or
         *        both.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are
         *        attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The
         *        same tag is applied to all of the snapshots that are created.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify other values for <code>ResourceType</code>, the request fails.
         *        </p>
         *        <p>
         *        To tag an AMI or snapshot after it has been created, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to
         * the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied
         * to all of the snapshots that are created.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify other values for <code>ResourceType</code>, the request fails.
         * </p>
         * <p>
         * To tag an AMI or snapshot after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or
         *        both.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are
         *        attached to the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The
         *        same tag is applied to all of the snapshots that are created.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify other values for <code>ResourceType</code>, the request fails.
         *        </p>
         *        <p>
         *        To tag an AMI or snapshot after it has been created, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the AMI and snapshots on creation. You can tag the AMI, the snapshots, or both.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To tag the AMI, the value for <code>ResourceType</code> must be <code>image</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To tag the snapshots that are created of the root volume and of other Amazon EBS volumes that are attached to
         * the instance, the value for <code>ResourceType</code> must be <code>snapshot</code>. The same tag is applied
         * to all of the snapshots that are created.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify other values for <code>ResourceType</code>, the request fails.
         * </p>
         * <p>
         * To tag an AMI or snapshot after it has been created, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html">CreateTags</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean dryRun;

        private String instanceId;

        private String name;

        private Boolean noReboot;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            super(model);
            blockDeviceMappings(model.blockDeviceMappings);
            description(model.description);
            dryRun(model.dryRun);
            instanceId(model.instanceId);
            name(model.name);
            noReboot(model.noReboot);
            tagSpecifications(model.tagSpecifications);
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingRequestListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getNoReboot() {
            return noReboot;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        @Override
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
