/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the
 * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/hibernating-prerequisites.html">hibernation
 * prerequisites</a>. For more information, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html">Hibernate your Amazon EC2 instance</a> in
 * the <i>Amazon EC2 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HibernationOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<HibernationOptions.Builder, HibernationOptions> {
    private static final SdkField<Boolean> CONFIGURED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Configured")
            .getter(getter(HibernationOptions::configured))
            .setter(setter(Builder::configured))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configured")
                    .unmarshallLocationName("configured").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean configured;

    private HibernationOptions(BuilderImpl builder) {
        this.configured = builder.configured;
    }

    /**
     * <p>
     * If <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.
     * </p>
     * 
     * @return If <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for
     *         hibernation.
     */
    public final Boolean configured() {
        return configured;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configured());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HibernationOptions)) {
            return false;
        }
        HibernationOptions other = (HibernationOptions) obj;
        return Objects.equals(configured(), other.configured());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HibernationOptions").add("Configured", configured()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configured":
            return Optional.ofNullable(clazz.cast(configured()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HibernationOptions, T> g) {
        return obj -> g.apply((HibernationOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HibernationOptions> {
        /**
         * <p>
         * If <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for hibernation.
         * </p>
         * 
         * @param configured
         *        If <code>true</code>, your instance is enabled for hibernation; otherwise, it is not enabled for
         *        hibernation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configured(Boolean configured);
    }

    static final class BuilderImpl implements Builder {
        private Boolean configured;

        private BuilderImpl() {
        }

        private BuilderImpl(HibernationOptions model) {
            configured(model.configured);
        }

        public final Boolean getConfigured() {
            return configured;
        }

        public final void setConfigured(Boolean configured) {
            this.configured = configured;
        }

        @Override
        public final Builder configured(Boolean configured) {
            this.configured = configured;
            return this;
        }

        @Override
        public HibernationOptions build() {
            return new HibernationOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
