/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointConnectionNotificationsResponse extends Ec2Response
        implements
        ToCopyableBuilder<DeleteVpcEndpointConnectionNotificationsResponse.Builder, DeleteVpcEndpointConnectionNotificationsResponse> {
    private static final SdkField<List<UnsuccessfulItem>> UNSUCCESSFUL_FIELD = SdkField
            .<List<UnsuccessfulItem>> builder(MarshallingType.LIST)
            .memberName("Unsuccessful")
            .getter(getter(DeleteVpcEndpointConnectionNotificationsResponse::unsuccessful))
            .setter(setter(Builder::unsuccessful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful")
                    .unmarshallLocationName("unsuccessful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<UnsuccessfulItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnsuccessfulItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNSUCCESSFUL_FIELD));

    private final List<UnsuccessfulItem> unsuccessful;

    private DeleteVpcEndpointConnectionNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Unsuccessful property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnsuccessful() {
        return unsuccessful != null && !(unsuccessful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the notifications that could not be deleted successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsuccessful} method.
     * </p>
     * 
     * @return Information about the notifications that could not be deleted successfully.
     */
    public final List<UnsuccessfulItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessful() ? unsuccessful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointConnectionNotificationsResponse)) {
            return false;
        }
        DeleteVpcEndpointConnectionNotificationsResponse other = (DeleteVpcEndpointConnectionNotificationsResponse) obj;
        return hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcEndpointConnectionNotificationsResponse")
                .add("Unsuccessful", hasUnsuccessful() ? unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Unsuccessful":
            return Optional.ofNullable(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointConnectionNotificationsResponse, T> g) {
        return obj -> g.apply((DeleteVpcEndpointConnectionNotificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVpcEndpointConnectionNotificationsResponse> {
        /**
         * <p>
         * Information about the notifications that could not be deleted successfully.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the notifications that could not be deleted successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful);

        /**
         * <p>
         * Information about the notifications that could not be deleted successfully.
         * </p>
         * 
         * @param unsuccessful
         *        Information about the notifications that could not be deleted successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(UnsuccessfulItem... unsuccessful);

        /**
         * <p>
         * Information about the notifications that could not be deleted successfully.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.UnsuccessfulItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.UnsuccessfulItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.UnsuccessfulItem.Builder#build()} is called immediately and
         * its result is passed to {@link #unsuccessful(List<UnsuccessfulItem>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.UnsuccessfulItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(java.util.Collection<UnsuccessfulItem>)
         */
        Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<UnsuccessfulItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointConnectionNotificationsResponse model) {
            super(model);
            unsuccessful(model.unsuccessful);
        }

        public final List<UnsuccessfulItem.Builder> getUnsuccessful() {
            List<UnsuccessfulItem.Builder> result = UnsuccessfulItemSetCopier.copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<UnsuccessfulItem.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> UnsuccessfulItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteVpcEndpointConnectionNotificationsResponse build() {
            return new DeleteVpcEndpointConnectionNotificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
