/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation;

public class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher
implements SdkPublisher<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher(Ec2AsyncClient client, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher(Ec2AsyncClient client, DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocalGatewayRouteTableVirtualInterfaceGroupAssociation> localGatewayRouteTableVirtualInterfaceGroupAssociations() {
        Function<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.localGatewayRouteTableVirtualInterfaceGroupAssociations() != null) {
                return response.localGatewayRouteTableVirtualInterfaceGroupAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> {
        private DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse> nextPage(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher.this.client.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher.this.firstRequest);
            }
            return DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher.this.client.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations((DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest)((Object)DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

