/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StoreImageTaskResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StoreImageTaskResult> {
    private static final SdkField<String> AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmiId").getter(StoreImageTaskResult.getter(StoreImageTaskResult::amiId)).setter(StoreImageTaskResult.setter(Builder::amiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").unmarshallLocationName("amiId").build()}).build();
    private static final SdkField<Instant> TASK_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TaskStartTime").getter(StoreImageTaskResult.getter(StoreImageTaskResult::taskStartTime)).setter(StoreImageTaskResult.setter(Builder::taskStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStartTime").unmarshallLocationName("taskStartTime").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(StoreImageTaskResult.getter(StoreImageTaskResult::bucket)).setter(StoreImageTaskResult.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("bucket").build()}).build();
    private static final SdkField<String> S3_OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3objectKey").getter(StoreImageTaskResult.getter(StoreImageTaskResult::s3objectKey)).setter(StoreImageTaskResult.setter(Builder::s3objectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3objectKey").unmarshallLocationName("s3objectKey").build()}).build();
    private static final SdkField<Integer> PROGRESS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgressPercentage").getter(StoreImageTaskResult.getter(StoreImageTaskResult::progressPercentage)).setter(StoreImageTaskResult.setter(Builder::progressPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercentage").unmarshallLocationName("progressPercentage").build()}).build();
    private static final SdkField<String> STORE_TASK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StoreTaskState").getter(StoreImageTaskResult.getter(StoreImageTaskResult::storeTaskState)).setter(StoreImageTaskResult.setter(Builder::storeTaskState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoreTaskState").unmarshallLocationName("storeTaskState").build()}).build();
    private static final SdkField<String> STORE_TASK_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StoreTaskFailureReason").getter(StoreImageTaskResult.getter(StoreImageTaskResult::storeTaskFailureReason)).setter(StoreImageTaskResult.setter(Builder::storeTaskFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoreTaskFailureReason").unmarshallLocationName("storeTaskFailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_ID_FIELD, TASK_START_TIME_FIELD, BUCKET_FIELD, S3_OBJECT_KEY_FIELD, PROGRESS_PERCENTAGE_FIELD, STORE_TASK_STATE_FIELD, STORE_TASK_FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String amiId;
    private final Instant taskStartTime;
    private final String bucket;
    private final String s3objectKey;
    private final Integer progressPercentage;
    private final String storeTaskState;
    private final String storeTaskFailureReason;

    private StoreImageTaskResult(BuilderImpl builder) {
        this.amiId = builder.amiId;
        this.taskStartTime = builder.taskStartTime;
        this.bucket = builder.bucket;
        this.s3objectKey = builder.s3objectKey;
        this.progressPercentage = builder.progressPercentage;
        this.storeTaskState = builder.storeTaskState;
        this.storeTaskFailureReason = builder.storeTaskFailureReason;
    }

    public final String amiId() {
        return this.amiId;
    }

    public final Instant taskStartTime() {
        return this.taskStartTime;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String s3objectKey() {
        return this.s3objectKey;
    }

    public final Integer progressPercentage() {
        return this.progressPercentage;
    }

    public final String storeTaskState() {
        return this.storeTaskState;
    }

    public final String storeTaskFailureReason() {
        return this.storeTaskFailureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3objectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeTaskState());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeTaskFailureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoreImageTaskResult)) {
            return false;
        }
        StoreImageTaskResult other = (StoreImageTaskResult)obj;
        return Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.taskStartTime(), other.taskStartTime()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.s3objectKey(), other.s3objectKey()) && Objects.equals(this.progressPercentage(), other.progressPercentage()) && Objects.equals(this.storeTaskState(), other.storeTaskState()) && Objects.equals(this.storeTaskFailureReason(), other.storeTaskFailureReason());
    }

    public final String toString() {
        return ToString.builder((String)"StoreImageTaskResult").add("AmiId", (Object)this.amiId()).add("TaskStartTime", (Object)this.taskStartTime()).add("Bucket", (Object)this.bucket()).add("S3objectKey", (Object)this.s3objectKey()).add("ProgressPercentage", (Object)this.progressPercentage()).add("StoreTaskState", (Object)this.storeTaskState()).add("StoreTaskFailureReason", (Object)this.storeTaskFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmiId": {
                return Optional.ofNullable(clazz.cast(this.amiId()));
            }
            case "TaskStartTime": {
                return Optional.ofNullable(clazz.cast(this.taskStartTime()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "S3objectKey": {
                return Optional.ofNullable(clazz.cast(this.s3objectKey()));
            }
            case "ProgressPercentage": {
                return Optional.ofNullable(clazz.cast(this.progressPercentage()));
            }
            case "StoreTaskState": {
                return Optional.ofNullable(clazz.cast(this.storeTaskState()));
            }
            case "StoreTaskFailureReason": {
                return Optional.ofNullable(clazz.cast(this.storeTaskFailureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StoreImageTaskResult, T> g) {
        return obj -> g.apply((StoreImageTaskResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amiId;
        private Instant taskStartTime;
        private String bucket;
        private String s3objectKey;
        private Integer progressPercentage;
        private String storeTaskState;
        private String storeTaskFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StoreImageTaskResult model) {
            this.amiId(model.amiId);
            this.taskStartTime(model.taskStartTime);
            this.bucket(model.bucket);
            this.s3objectKey(model.s3objectKey);
            this.progressPercentage(model.progressPercentage);
            this.storeTaskState(model.storeTaskState);
            this.storeTaskFailureReason(model.storeTaskFailureReason);
        }

        public final String getAmiId() {
            return this.amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final Instant getTaskStartTime() {
            return this.taskStartTime;
        }

        public final void setTaskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
        }

        @Override
        public final Builder taskStartTime(Instant taskStartTime) {
            this.taskStartTime = taskStartTime;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getS3objectKey() {
            return this.s3objectKey;
        }

        public final void setS3objectKey(String s3objectKey) {
            this.s3objectKey = s3objectKey;
        }

        @Override
        public final Builder s3objectKey(String s3objectKey) {
            this.s3objectKey = s3objectKey;
            return this;
        }

        public final Integer getProgressPercentage() {
            return this.progressPercentage;
        }

        public final void setProgressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final String getStoreTaskState() {
            return this.storeTaskState;
        }

        public final void setStoreTaskState(String storeTaskState) {
            this.storeTaskState = storeTaskState;
        }

        @Override
        public final Builder storeTaskState(String storeTaskState) {
            this.storeTaskState = storeTaskState;
            return this;
        }

        public final String getStoreTaskFailureReason() {
            return this.storeTaskFailureReason;
        }

        public final void setStoreTaskFailureReason(String storeTaskFailureReason) {
            this.storeTaskFailureReason = storeTaskFailureReason;
        }

        @Override
        public final Builder storeTaskFailureReason(String storeTaskFailureReason) {
            this.storeTaskFailureReason = storeTaskFailureReason;
            return this;
        }

        public StoreImageTaskResult build() {
            return new StoreImageTaskResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StoreImageTaskResult> {
        public Builder amiId(String var1);

        public Builder taskStartTime(Instant var1);

        public Builder bucket(String var1);

        public Builder s3objectKey(String var1);

        public Builder progressPercentage(Integer var1);

        public Builder storeTaskState(String var1);

        public Builder storeTaskFailureReason(String var1);
    }
}

