/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamExternalResourceVerificationTokenState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TokenState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamExternalResourceVerificationToken
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamExternalResourceVerificationToken> {
    private static final SdkField<String> IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamExternalResourceVerificationTokenId").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::ipamExternalResourceVerificationTokenId)).setter(IpamExternalResourceVerificationToken.setter(Builder::ipamExternalResourceVerificationTokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamExternalResourceVerificationTokenId").unmarshallLocationName("ipamExternalResourceVerificationTokenId").build()}).build();
    private static final SdkField<String> IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamExternalResourceVerificationTokenArn").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::ipamExternalResourceVerificationTokenArn)).setter(IpamExternalResourceVerificationToken.setter(Builder::ipamExternalResourceVerificationTokenArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamExternalResourceVerificationTokenArn").unmarshallLocationName("ipamExternalResourceVerificationTokenArn").build()}).build();
    private static final SdkField<String> IPAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamId").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::ipamId)).setter(IpamExternalResourceVerificationToken.setter(Builder::ipamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamId").unmarshallLocationName("ipamId").build()}).build();
    private static final SdkField<String> IPAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamArn").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::ipamArn)).setter(IpamExternalResourceVerificationToken.setter(Builder::ipamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamArn").unmarshallLocationName("ipamArn").build()}).build();
    private static final SdkField<String> IPAM_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamRegion").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::ipamRegion)).setter(IpamExternalResourceVerificationToken.setter(Builder::ipamRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamRegion").unmarshallLocationName("ipamRegion").build()}).build();
    private static final SdkField<String> TOKEN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenValue").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::tokenValue)).setter(IpamExternalResourceVerificationToken.setter(Builder::tokenValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValue").unmarshallLocationName("tokenValue").build()}).build();
    private static final SdkField<String> TOKEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TokenName").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::tokenName)).setter(IpamExternalResourceVerificationToken.setter(Builder::tokenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenName").unmarshallLocationName("tokenName").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotAfter").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::notAfter)).setter(IpamExternalResourceVerificationToken.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").unmarshallLocationName("notAfter").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::statusAsString)).setter(IpamExternalResourceVerificationToken.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::tags)).setter(IpamExternalResourceVerificationToken.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamExternalResourceVerificationToken.getter(IpamExternalResourceVerificationToken::stateAsString)).setter(IpamExternalResourceVerificationToken.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ID_FIELD, IPAM_EXTERNAL_RESOURCE_VERIFICATION_TOKEN_ARN_FIELD, IPAM_ID_FIELD, IPAM_ARN_FIELD, IPAM_REGION_FIELD, TOKEN_VALUE_FIELD, TOKEN_NAME_FIELD, NOT_AFTER_FIELD, STATUS_FIELD, TAGS_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipamExternalResourceVerificationTokenId;
    private final String ipamExternalResourceVerificationTokenArn;
    private final String ipamId;
    private final String ipamArn;
    private final String ipamRegion;
    private final String tokenValue;
    private final String tokenName;
    private final Instant notAfter;
    private final String status;
    private final List<Tag> tags;
    private final String state;

    private IpamExternalResourceVerificationToken(BuilderImpl builder) {
        this.ipamExternalResourceVerificationTokenId = builder.ipamExternalResourceVerificationTokenId;
        this.ipamExternalResourceVerificationTokenArn = builder.ipamExternalResourceVerificationTokenArn;
        this.ipamId = builder.ipamId;
        this.ipamArn = builder.ipamArn;
        this.ipamRegion = builder.ipamRegion;
        this.tokenValue = builder.tokenValue;
        this.tokenName = builder.tokenName;
        this.notAfter = builder.notAfter;
        this.status = builder.status;
        this.tags = builder.tags;
        this.state = builder.state;
    }

    public final String ipamExternalResourceVerificationTokenId() {
        return this.ipamExternalResourceVerificationTokenId;
    }

    public final String ipamExternalResourceVerificationTokenArn() {
        return this.ipamExternalResourceVerificationTokenArn;
    }

    public final String ipamId() {
        return this.ipamId;
    }

    public final String ipamArn() {
        return this.ipamArn;
    }

    public final String ipamRegion() {
        return this.ipamRegion;
    }

    public final String tokenValue() {
        return this.tokenValue;
    }

    public final String tokenName() {
        return this.tokenName;
    }

    public final Instant notAfter() {
        return this.notAfter;
    }

    public final TokenState status() {
        return TokenState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final IpamExternalResourceVerificationTokenState state() {
        return IpamExternalResourceVerificationTokenState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamExternalResourceVerificationTokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamExternalResourceVerificationTokenArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamExternalResourceVerificationToken)) {
            return false;
        }
        IpamExternalResourceVerificationToken other = (IpamExternalResourceVerificationToken)obj;
        return Objects.equals(this.ipamExternalResourceVerificationTokenId(), other.ipamExternalResourceVerificationTokenId()) && Objects.equals(this.ipamExternalResourceVerificationTokenArn(), other.ipamExternalResourceVerificationTokenArn()) && Objects.equals(this.ipamId(), other.ipamId()) && Objects.equals(this.ipamArn(), other.ipamArn()) && Objects.equals(this.ipamRegion(), other.ipamRegion()) && Objects.equals(this.tokenValue(), other.tokenValue()) && Objects.equals(this.tokenName(), other.tokenName()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IpamExternalResourceVerificationToken").add("IpamExternalResourceVerificationTokenId", (Object)this.ipamExternalResourceVerificationTokenId()).add("IpamExternalResourceVerificationTokenArn", (Object)this.ipamExternalResourceVerificationTokenArn()).add("IpamId", (Object)this.ipamId()).add("IpamArn", (Object)this.ipamArn()).add("IpamRegion", (Object)this.ipamRegion()).add("TokenValue", (Object)this.tokenValue()).add("TokenName", (Object)this.tokenName()).add("NotAfter", (Object)this.notAfter()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamExternalResourceVerificationTokenId": {
                return Optional.ofNullable(clazz.cast(this.ipamExternalResourceVerificationTokenId()));
            }
            case "IpamExternalResourceVerificationTokenArn": {
                return Optional.ofNullable(clazz.cast(this.ipamExternalResourceVerificationTokenArn()));
            }
            case "IpamId": {
                return Optional.ofNullable(clazz.cast(this.ipamId()));
            }
            case "IpamArn": {
                return Optional.ofNullable(clazz.cast(this.ipamArn()));
            }
            case "IpamRegion": {
                return Optional.ofNullable(clazz.cast(this.ipamRegion()));
            }
            case "TokenValue": {
                return Optional.ofNullable(clazz.cast(this.tokenValue()));
            }
            case "TokenName": {
                return Optional.ofNullable(clazz.cast(this.tokenName()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamExternalResourceVerificationToken, T> g) {
        return obj -> g.apply((IpamExternalResourceVerificationToken)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipamExternalResourceVerificationTokenId;
        private String ipamExternalResourceVerificationTokenArn;
        private String ipamId;
        private String ipamArn;
        private String ipamRegion;
        private String tokenValue;
        private String tokenName;
        private Instant notAfter;
        private String status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamExternalResourceVerificationToken model) {
            this.ipamExternalResourceVerificationTokenId(model.ipamExternalResourceVerificationTokenId);
            this.ipamExternalResourceVerificationTokenArn(model.ipamExternalResourceVerificationTokenArn);
            this.ipamId(model.ipamId);
            this.ipamArn(model.ipamArn);
            this.ipamRegion(model.ipamRegion);
            this.tokenValue(model.tokenValue);
            this.tokenName(model.tokenName);
            this.notAfter(model.notAfter);
            this.status(model.status);
            this.tags(model.tags);
            this.state(model.state);
        }

        public final String getIpamExternalResourceVerificationTokenId() {
            return this.ipamExternalResourceVerificationTokenId;
        }

        public final void setIpamExternalResourceVerificationTokenId(String ipamExternalResourceVerificationTokenId) {
            this.ipamExternalResourceVerificationTokenId = ipamExternalResourceVerificationTokenId;
        }

        @Override
        public final Builder ipamExternalResourceVerificationTokenId(String ipamExternalResourceVerificationTokenId) {
            this.ipamExternalResourceVerificationTokenId = ipamExternalResourceVerificationTokenId;
            return this;
        }

        public final String getIpamExternalResourceVerificationTokenArn() {
            return this.ipamExternalResourceVerificationTokenArn;
        }

        public final void setIpamExternalResourceVerificationTokenArn(String ipamExternalResourceVerificationTokenArn) {
            this.ipamExternalResourceVerificationTokenArn = ipamExternalResourceVerificationTokenArn;
        }

        @Override
        public final Builder ipamExternalResourceVerificationTokenArn(String ipamExternalResourceVerificationTokenArn) {
            this.ipamExternalResourceVerificationTokenArn = ipamExternalResourceVerificationTokenArn;
            return this;
        }

        public final String getIpamId() {
            return this.ipamId;
        }

        public final void setIpamId(String ipamId) {
            this.ipamId = ipamId;
        }

        @Override
        public final Builder ipamId(String ipamId) {
            this.ipamId = ipamId;
            return this;
        }

        public final String getIpamArn() {
            return this.ipamArn;
        }

        public final void setIpamArn(String ipamArn) {
            this.ipamArn = ipamArn;
        }

        @Override
        public final Builder ipamArn(String ipamArn) {
            this.ipamArn = ipamArn;
            return this;
        }

        public final String getIpamRegion() {
            return this.ipamRegion;
        }

        public final void setIpamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
        }

        @Override
        public final Builder ipamRegion(String ipamRegion) {
            this.ipamRegion = ipamRegion;
            return this;
        }

        public final String getTokenValue() {
            return this.tokenValue;
        }

        public final void setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        @Override
        public final Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public final String getTokenName() {
            return this.tokenName;
        }

        public final void setTokenName(String tokenName) {
            this.tokenName = tokenName;
        }

        @Override
        public final Builder tokenName(String tokenName) {
            this.tokenName = tokenName;
            return this;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TokenState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamExternalResourceVerificationTokenState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public IpamExternalResourceVerificationToken build() {
            return new IpamExternalResourceVerificationToken(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamExternalResourceVerificationToken> {
        public Builder ipamExternalResourceVerificationTokenId(String var1);

        public Builder ipamExternalResourceVerificationTokenArn(String var1);

        public Builder ipamId(String var1);

        public Builder ipamArn(String var1);

        public Builder ipamRegion(String var1);

        public Builder tokenValue(String var1);

        public Builder tokenName(String var1);

        public Builder notAfter(Instant var1);

        public Builder status(String var1);

        public Builder status(TokenState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(IpamExternalResourceVerificationTokenState var1);
    }
}

