/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTransitGatewayRoutesResponse extends Ec2Response implements
        ToCopyableBuilder<SearchTransitGatewayRoutesResponse.Builder, SearchTransitGatewayRoutesResponse> {
    private static final SdkField<List<TransitGatewayRoute>> ROUTES_FIELD = SdkField
            .<List<TransitGatewayRoute>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(SearchTransitGatewayRoutesResponse::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet")
                    .unmarshallLocationName("routeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> ADDITIONAL_ROUTES_AVAILABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AdditionalRoutesAvailable")
            .getter(getter(SearchTransitGatewayRoutesResponse::additionalRoutesAvailable))
            .setter(setter(Builder::additionalRoutesAvailable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRoutesAvailable")
                    .unmarshallLocationName("additionalRoutesAvailable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_FIELD,
            ADDITIONAL_ROUTES_AVAILABLE_FIELD));

    private final List<TransitGatewayRoute> routes;

    private final Boolean additionalRoutesAvailable;

    private SearchTransitGatewayRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.routes = builder.routes;
        this.additionalRoutesAvailable = builder.additionalRoutesAvailable;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return Information about the routes.
     */
    public final List<TransitGatewayRoute> routes() {
        return routes;
    }

    /**
     * <p>
     * Indicates whether there are additional routes available.
     * </p>
     * 
     * @return Indicates whether there are additional routes available.
     */
    public final Boolean additionalRoutesAvailable() {
        return additionalRoutesAvailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(additionalRoutesAvailable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTransitGatewayRoutesResponse)) {
            return false;
        }
        SearchTransitGatewayRoutesResponse other = (SearchTransitGatewayRoutesResponse) obj;
        return hasRoutes() == other.hasRoutes() && Objects.equals(routes(), other.routes())
                && Objects.equals(additionalRoutesAvailable(), other.additionalRoutesAvailable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTransitGatewayRoutesResponse").add("Routes", hasRoutes() ? routes() : null)
                .add("AdditionalRoutesAvailable", additionalRoutesAvailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "AdditionalRoutesAvailable":
            return Optional.ofNullable(clazz.cast(additionalRoutesAvailable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTransitGatewayRoutesResponse, T> g) {
        return obj -> g.apply((SearchTransitGatewayRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, SearchTransitGatewayRoutesResponse> {
        /**
         * <p>
         * Information about the routes.
         * </p>
         * 
         * @param routes
         *        Information about the routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<TransitGatewayRoute> routes);

        /**
         * <p>
         * Information about the routes.
         * </p>
         * 
         * @param routes
         *        Information about the routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(TransitGatewayRoute... routes);

        /**
         * <p>
         * Information about the routes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayRoute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TransitGatewayRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayRoute.Builder#build()} is called immediately
         * and its result is passed to {@link #routes(List<TransitGatewayRoute>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TransitGatewayRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<TransitGatewayRoute>)
         */
        Builder routes(Consumer<TransitGatewayRoute.Builder>... routes);

        /**
         * <p>
         * Indicates whether there are additional routes available.
         * </p>
         * 
         * @param additionalRoutesAvailable
         *        Indicates whether there are additional routes available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalRoutesAvailable(Boolean additionalRoutesAvailable);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TransitGatewayRoute> routes = DefaultSdkAutoConstructList.getInstance();

        private Boolean additionalRoutesAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTransitGatewayRoutesResponse model) {
            super(model);
            routes(model.routes);
            additionalRoutesAvailable(model.additionalRoutesAvailable);
        }

        public final List<TransitGatewayRoute.Builder> getRoutes() {
            List<TransitGatewayRoute.Builder> result = TransitGatewayRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<TransitGatewayRoute.BuilderImpl> routes) {
            this.routes = TransitGatewayRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<TransitGatewayRoute> routes) {
            this.routes = TransitGatewayRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(TransitGatewayRoute... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<TransitGatewayRoute.Builder>... routes) {
            routes(Stream.of(routes).map(c -> TransitGatewayRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAdditionalRoutesAvailable() {
            return additionalRoutesAvailable;
        }

        public final void setAdditionalRoutesAvailable(Boolean additionalRoutesAvailable) {
            this.additionalRoutesAvailable = additionalRoutesAvailable;
        }

        @Override
        public final Builder additionalRoutesAvailable(Boolean additionalRoutesAvailable) {
            this.additionalRoutesAvailable = additionalRoutesAvailable;
            return this;
        }

        @Override
        public SearchTransitGatewayRoutesResponse build() {
            return new SearchTransitGatewayRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
