/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an IPv6 prefix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceIpv6Prefix implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceIpv6Prefix.Builder, InstanceIpv6Prefix> {
    private static final SdkField<String> IPV6_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Ipv6Prefix")
            .getter(getter(InstanceIpv6Prefix::ipv6Prefix))
            .setter(setter(Builder::ipv6Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefix")
                    .unmarshallLocationName("ipv6Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipv6Prefix;

    private InstanceIpv6Prefix(BuilderImpl builder) {
        this.ipv6Prefix = builder.ipv6Prefix;
    }

    /**
     * <p>
     * One or more IPv6 prefixes assigned to the network interface.
     * </p>
     * 
     * @return One or more IPv6 prefixes assigned to the network interface.
     */
    public final String ipv6Prefix() {
        return ipv6Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceIpv6Prefix)) {
            return false;
        }
        InstanceIpv6Prefix other = (InstanceIpv6Prefix) obj;
        return Objects.equals(ipv6Prefix(), other.ipv6Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceIpv6Prefix").add("Ipv6Prefix", ipv6Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ipv6Prefix":
            return Optional.ofNullable(clazz.cast(ipv6Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceIpv6Prefix, T> g) {
        return obj -> g.apply((InstanceIpv6Prefix) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceIpv6Prefix> {
        /**
         * <p>
         * One or more IPv6 prefixes assigned to the network interface.
         * </p>
         * 
         * @param ipv6Prefix
         *        One or more IPv6 prefixes assigned to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefix(String ipv6Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String ipv6Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceIpv6Prefix model) {
            ipv6Prefix(model.ipv6Prefix);
        }

        public final String getIpv6Prefix() {
            return ipv6Prefix;
        }

        public final void setIpv6Prefix(String ipv6Prefix) {
            this.ipv6Prefix = ipv6Prefix;
        }

        @Override
        public final Builder ipv6Prefix(String ipv6Prefix) {
            this.ipv6Prefix = ipv6Prefix;
            return this;
        }

        @Override
        public InstanceIpv6Prefix build() {
            return new InstanceIpv6Prefix(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
