/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceNetworkAclAssociationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ReplaceNetworkAclAssociationRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(ReplaceNetworkAclAssociationRequest.getter(ReplaceNetworkAclAssociationRequest::associationId)).setter(ReplaceNetworkAclAssociationRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ReplaceNetworkAclAssociationRequest.getter(ReplaceNetworkAclAssociationRequest::dryRun)).setter(ReplaceNetworkAclAssociationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkAclId").getter(ReplaceNetworkAclAssociationRequest.getter(ReplaceNetworkAclAssociationRequest::networkAclId)).setter(ReplaceNetworkAclAssociationRequest.setter(Builder::networkAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").unmarshallLocationName("networkAclId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, DRY_RUN_FIELD, NETWORK_ACL_ID_FIELD));
    private final String associationId;
    private final Boolean dryRun;
    private final String networkAclId;

    private ReplaceNetworkAclAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.dryRun = builder.dryRun;
        this.networkAclId = builder.networkAclId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String networkAclId() {
        return this.networkAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceNetworkAclAssociationRequest)) {
            return false;
        }
        ReplaceNetworkAclAssociationRequest other = (ReplaceNetworkAclAssociationRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.networkAclId(), other.networkAclId());
    }

    public final String toString() {
        return ToString.builder((String)"ReplaceNetworkAclAssociationRequest").add("AssociationId", (Object)this.associationId()).add("DryRun", (Object)this.dryRun()).add("NetworkAclId", (Object)this.networkAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "NetworkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceNetworkAclAssociationRequest, T> g) {
        return obj -> g.apply((ReplaceNetworkAclAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String associationId;
        private Boolean dryRun;
        private String networkAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceNetworkAclAssociationRequest model) {
            super(model);
            this.associationId(model.associationId);
            this.dryRun(model.dryRun);
            this.networkAclId(model.networkAclId);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplaceNetworkAclAssociationRequest build() {
            return new ReplaceNetworkAclAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReplaceNetworkAclAssociationRequest> {
        public Builder associationId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder networkAclId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

