/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpamPoolCidrFailureReason;
import software.amazon.awssdk.services.ec2.model.IpamPoolCidrState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPoolCidr
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPoolCidr> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(IpamPoolCidr.getter(IpamPoolCidr::cidr)).setter(IpamPoolCidr.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("cidr").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamPoolCidr.getter(IpamPoolCidr::stateAsString)).setter(IpamPoolCidr.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<IpamPoolCidrFailureReason> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureReason").getter(IpamPoolCidr.getter(IpamPoolCidr::failureReason)).setter(IpamPoolCidr.setter(Builder::failureReason)).constructor(IpamPoolCidrFailureReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").unmarshallLocationName("failureReason").build()}).build();
    private static final SdkField<String> IPAM_POOL_CIDR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolCidrId").getter(IpamPoolCidr.getter(IpamPoolCidr::ipamPoolCidrId)).setter(IpamPoolCidr.setter(Builder::ipamPoolCidrId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolCidrId").unmarshallLocationName("ipamPoolCidrId").build()}).build();
    private static final SdkField<Integer> NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetmaskLength").getter(IpamPoolCidr.getter(IpamPoolCidr::netmaskLength)).setter(IpamPoolCidr.setter(Builder::netmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetmaskLength").unmarshallLocationName("netmaskLength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, STATE_FIELD, FAILURE_REASON_FIELD, IPAM_POOL_CIDR_ID_FIELD, NETMASK_LENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidr;
    private final String state;
    private final IpamPoolCidrFailureReason failureReason;
    private final String ipamPoolCidrId;
    private final Integer netmaskLength;

    private IpamPoolCidr(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.state = builder.state;
        this.failureReason = builder.failureReason;
        this.ipamPoolCidrId = builder.ipamPoolCidrId;
        this.netmaskLength = builder.netmaskLength;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final IpamPoolCidrState state() {
        return IpamPoolCidrState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final IpamPoolCidrFailureReason failureReason() {
        return this.failureReason;
    }

    public final String ipamPoolCidrId() {
        return this.ipamPoolCidrId;
    }

    public final Integer netmaskLength() {
        return this.netmaskLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolCidrId());
        hashCode = 31 * hashCode + Objects.hashCode(this.netmaskLength());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPoolCidr)) {
            return false;
        }
        IpamPoolCidr other = (IpamPoolCidr)obj;
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.ipamPoolCidrId(), other.ipamPoolCidrId()) && Objects.equals(this.netmaskLength(), other.netmaskLength());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPoolCidr").add("Cidr", (Object)this.cidr()).add("State", (Object)this.stateAsString()).add("FailureReason", (Object)this.failureReason()).add("IpamPoolCidrId", (Object)this.ipamPoolCidrId()).add("NetmaskLength", (Object)this.netmaskLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "IpamPoolCidrId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolCidrId()));
            }
            case "NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.netmaskLength()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamPoolCidr, T> g) {
        return obj -> g.apply((IpamPoolCidr)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidr;
        private String state;
        private IpamPoolCidrFailureReason failureReason;
        private String ipamPoolCidrId;
        private Integer netmaskLength;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPoolCidr model) {
            this.cidr(model.cidr);
            this.state(model.state);
            this.failureReason(model.failureReason);
            this.ipamPoolCidrId(model.ipamPoolCidrId);
            this.netmaskLength(model.netmaskLength);
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamPoolCidrState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final IpamPoolCidrFailureReason.Builder getFailureReason() {
            return this.failureReason != null ? this.failureReason.toBuilder() : null;
        }

        public final void setFailureReason(IpamPoolCidrFailureReason.BuilderImpl failureReason) {
            this.failureReason = failureReason != null ? failureReason.build() : null;
        }

        @Override
        public final Builder failureReason(IpamPoolCidrFailureReason failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getIpamPoolCidrId() {
            return this.ipamPoolCidrId;
        }

        public final void setIpamPoolCidrId(String ipamPoolCidrId) {
            this.ipamPoolCidrId = ipamPoolCidrId;
        }

        @Override
        public final Builder ipamPoolCidrId(String ipamPoolCidrId) {
            this.ipamPoolCidrId = ipamPoolCidrId;
            return this;
        }

        public final Integer getNetmaskLength() {
            return this.netmaskLength;
        }

        public final void setNetmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
        }

        @Override
        public final Builder netmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
            return this;
        }

        public IpamPoolCidr build() {
            return new IpamPoolCidr(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPoolCidr> {
        public Builder cidr(String var1);

        public Builder state(String var1);

        public Builder state(IpamPoolCidrState var1);

        public Builder failureReason(IpamPoolCidrFailureReason var1);

        default public Builder failureReason(Consumer<IpamPoolCidrFailureReason.Builder> failureReason) {
            return this.failureReason((IpamPoolCidrFailureReason)((IpamPoolCidrFailureReason.Builder)IpamPoolCidrFailureReason.builder().applyMutation(failureReason)).build());
        }

        public Builder ipamPoolCidrId(String var1);

        public Builder netmaskLength(Integer var1);
    }
}

