/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Phase2IntegrityAlgorithmsListCopier {
    static List<Phase2IntegrityAlgorithmsListValue> copy(
            Collection<? extends Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithmsListParam) {
        List<Phase2IntegrityAlgorithmsListValue> list;
        if (phase2IntegrityAlgorithmsListParam == null || phase2IntegrityAlgorithmsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2IntegrityAlgorithmsListValue> modifiableList = new ArrayList<>();
            phase2IntegrityAlgorithmsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Phase2IntegrityAlgorithmsListValue> copyFromBuilder(
            Collection<? extends Phase2IntegrityAlgorithmsListValue.Builder> phase2IntegrityAlgorithmsListParam) {
        List<Phase2IntegrityAlgorithmsListValue> list;
        if (phase2IntegrityAlgorithmsListParam == null || phase2IntegrityAlgorithmsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2IntegrityAlgorithmsListValue> modifiableList = new ArrayList<>();
            phase2IntegrityAlgorithmsListParam.forEach(entry -> {
                Phase2IntegrityAlgorithmsListValue member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Phase2IntegrityAlgorithmsListValue.Builder> copyToBuilder(
            Collection<? extends Phase2IntegrityAlgorithmsListValue> phase2IntegrityAlgorithmsListParam) {
        List<Phase2IntegrityAlgorithmsListValue.Builder> list;
        if (phase2IntegrityAlgorithmsListParam == null || phase2IntegrityAlgorithmsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Phase2IntegrityAlgorithmsListValue.Builder> modifiableList = new ArrayList<>();
            phase2IntegrityAlgorithmsListParam.forEach(entry -> {
                Phase2IntegrityAlgorithmsListValue.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
