/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A security group connection tracking specification that enables you to set the idle timeout for connection tracking
 * on an Elastic network interface. For more information, see <a href=
 * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts"
 * >Connection tracking timeouts</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionTrackingSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionTrackingSpecification.Builder, ConnectionTrackingSpecification> {
    private static final SdkField<Integer> TCP_ESTABLISHED_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TcpEstablishedTimeout")
            .getter(getter(ConnectionTrackingSpecification::tcpEstablishedTimeout))
            .setter(setter(Builder::tcpEstablishedTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TcpEstablishedTimeout")
                    .unmarshallLocationName("tcpEstablishedTimeout").build()).build();

    private static final SdkField<Integer> UDP_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("UdpTimeout")
            .getter(getter(ConnectionTrackingSpecification::udpTimeout))
            .setter(setter(Builder::udpTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UdpTimeout")
                    .unmarshallLocationName("udpTimeout").build()).build();

    private static final SdkField<Integer> UDP_STREAM_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("UdpStreamTimeout")
            .getter(getter(ConnectionTrackingSpecification::udpStreamTimeout))
            .setter(setter(Builder::udpStreamTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UdpStreamTimeout")
                    .unmarshallLocationName("udpStreamTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TCP_ESTABLISHED_TIMEOUT_FIELD,
            UDP_TIMEOUT_FIELD, UDP_STREAM_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer tcpEstablishedTimeout;

    private final Integer udpTimeout;

    private final Integer udpStreamTimeout;

    private ConnectionTrackingSpecification(BuilderImpl builder) {
        this.tcpEstablishedTimeout = builder.tcpEstablishedTimeout;
        this.udpTimeout = builder.udpTimeout;
        this.udpStreamTimeout = builder.udpStreamTimeout;
    }

    /**
     * <p>
     * Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000 seconds (5
     * days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
     * </p>
     * 
     * @return Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000
     *         seconds (5 days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
     */
    public final Integer tcpEstablishedTimeout() {
        return tcpEstablishedTimeout;
    }

    /**
     * <p>
     * Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
     * request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
     * </p>
     * 
     * @return Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
     *         request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
     */
    public final Integer udpTimeout() {
        return udpTimeout;
    }

    /**
     * <p>
     * Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one request-response
     * transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
     * </p>
     * 
     * @return Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one
     *         request-response transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
     */
    public final Integer udpStreamTimeout() {
        return udpStreamTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tcpEstablishedTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(udpTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(udpStreamTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTrackingSpecification)) {
            return false;
        }
        ConnectionTrackingSpecification other = (ConnectionTrackingSpecification) obj;
        return Objects.equals(tcpEstablishedTimeout(), other.tcpEstablishedTimeout())
                && Objects.equals(udpTimeout(), other.udpTimeout())
                && Objects.equals(udpStreamTimeout(), other.udpStreamTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionTrackingSpecification").add("TcpEstablishedTimeout", tcpEstablishedTimeout())
                .add("UdpTimeout", udpTimeout()).add("UdpStreamTimeout", udpStreamTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TcpEstablishedTimeout":
            return Optional.ofNullable(clazz.cast(tcpEstablishedTimeout()));
        case "UdpTimeout":
            return Optional.ofNullable(clazz.cast(udpTimeout()));
        case "UdpStreamTimeout":
            return Optional.ofNullable(clazz.cast(udpStreamTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTrackingSpecification, T> g) {
        return obj -> g.apply((ConnectionTrackingSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionTrackingSpecification> {
        /**
         * <p>
         * Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000 seconds
         * (5 days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
         * </p>
         * 
         * @param tcpEstablishedTimeout
         *        Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000
         *        seconds (5 days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpEstablishedTimeout(Integer tcpEstablishedTimeout);

        /**
         * <p>
         * Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
         * request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
         * </p>
         * 
         * @param udpTimeout
         *        Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
         *        request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpTimeout(Integer udpTimeout);

        /**
         * <p>
         * Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one request-response
         * transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
         * </p>
         * 
         * @param udpStreamTimeout
         *        Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one
         *        request-response transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpStreamTimeout(Integer udpStreamTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer tcpEstablishedTimeout;

        private Integer udpTimeout;

        private Integer udpStreamTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTrackingSpecification model) {
            tcpEstablishedTimeout(model.tcpEstablishedTimeout);
            udpTimeout(model.udpTimeout);
            udpStreamTimeout(model.udpStreamTimeout);
        }

        public final Integer getTcpEstablishedTimeout() {
            return tcpEstablishedTimeout;
        }

        public final void setTcpEstablishedTimeout(Integer tcpEstablishedTimeout) {
            this.tcpEstablishedTimeout = tcpEstablishedTimeout;
        }

        @Override
        public final Builder tcpEstablishedTimeout(Integer tcpEstablishedTimeout) {
            this.tcpEstablishedTimeout = tcpEstablishedTimeout;
            return this;
        }

        public final Integer getUdpTimeout() {
            return udpTimeout;
        }

        public final void setUdpTimeout(Integer udpTimeout) {
            this.udpTimeout = udpTimeout;
        }

        @Override
        public final Builder udpTimeout(Integer udpTimeout) {
            this.udpTimeout = udpTimeout;
            return this;
        }

        public final Integer getUdpStreamTimeout() {
            return udpStreamTimeout;
        }

        public final void setUdpStreamTimeout(Integer udpStreamTimeout) {
            this.udpStreamTimeout = udpStreamTimeout;
        }

        @Override
        public final Builder udpStreamTimeout(Integer udpStreamTimeout) {
            this.udpStreamTimeout = udpStreamTimeout;
            return this;
        }

        @Override
        public ConnectionTrackingSpecification build() {
            return new ConnectionTrackingSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
